/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.maxbotix.MaxSonarI2CXL;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

class MaxSonarI2CXLAccess
extends HardwareAccess<MaxSonarI2CXL> {
    private final MaxSonarI2CXL maxSonarI2CXL;

    MaxSonarI2CXLAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, MaxSonarI2CXL.class);
        this.maxSonarI2CXL = (MaxSonarI2CXL)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"getDistanceSync"})
    public double getDistanceSync(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistanceSync");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
            if (distanceUnit != null) {
                double d = this.maxSonarI2CXL.getDistanceSync(distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"getDistanceSync"})
    public double getDistanceSync_withDelay(int sonarPropagationDelayMs, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistanceSync");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
            if (distanceUnit != null) {
                double d = this.maxSonarI2CXL.getDistanceSync(sonarPropagationDelayMs, distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"getDistanceAsync"})
    public double getDistanceAsync(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistanceAsync");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
            if (distanceUnit != null) {
                double d = this.maxSonarI2CXL.getDistanceAsync(distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"getDistanceAsync"})
    public double getDistanceAsync_withDelay(int sonarPropagationDelayMs, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistanceAsync");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
            if (distanceUnit != null) {
                double d = this.maxSonarI2CXL.getDistanceAsync(sonarPropagationDelayMs, distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.maxSonarI2CXL.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.maxSonarI2CXL.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.maxSonarI2CXL.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.maxSonarI2CXL.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MaxSonarI2CXL.class}, methodName={"writeI2cAddrToSensorEEPROM"})
    public void writeI2cAddrToSensorEEPROM(byte addr) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".writeI2cAddrToSensorEEPROM");
            this.maxSonarI2CXL.writeI2cAddrToSensorEEPROM(addr);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

