/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareUtil;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HuskyLensAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LLResultAccess;
import com.qualcomm.hardware.limelightvision.LLResult;
import com.qualcomm.robotcore.eventloop.opmode.LinearOpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.hardware.Gamepad;
import com.qualcomm.robotcore.hardware.HardwareMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.firstinspires.ftc.robotcore.external.JavaUtil;
import org.firstinspires.ftc.robotcore.external.Telemetry;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.opmode.BlocksClassFilter;

class MiscAccess
extends Access {
    private HardwareMap hardwareMap;

    MiscAccess(BlocksOpMode blocksOpMode, String identifier, HardwareMap hardwareMap) {
        super(blocksOpMode, identifier, "");
        this.hardwareMap = hardwareMap;
    }

    @JavascriptInterface
    public Object getNull() {
        try {
            this.startBlockExecution(BlockType.SPECIAL, "null");
            Object var1_1 = null;
            return var1_1;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isNull(Object value) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "isNull");
            boolean bl = value == null;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isNotNull(Object value) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "isNotNull");
            boolean bl = value != null;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String formatNumber(double number, int precision) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "formatNumber");
            String string = JavaUtil.formatNumber((double)number, (int)precision);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String formatNumber_withWidth(double number, int width, int precision) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "formatNumber");
            String string = JavaUtil.formatNumber((double)number, (int)width, (int)precision);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double roundDecimal(double number, int precision) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "roundDecimal");
            double d = Double.parseDouble(JavaUtil.formatNumber((double)number, (int)precision));
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public Object callJava(String methodLookupString, String json, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9, Object a10, Object a11, Object a12, Object a13, Object a14, Object a15, Object a16, Object a17, Object a18, Object a19, Object a20) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "Java method " + BlocksClassFilter.getUserVisibleName((String)methodLookupString));
            Object object = this.callJavaVarArgs(methodLookupString, json, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
            return object;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean callJava_boolean(String methodLookupString, String json, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9, Object a10, Object a11, Object a12, Object a13, Object a14, Object a15, Object a16, Object a17, Object a18, Object a19, Object a20) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "Java method " + BlocksClassFilter.getUserVisibleName((String)methodLookupString));
            boolean bl = (Boolean)this.callJavaVarArgs(methodLookupString, json, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String callJava_String(String methodLookupString, String json, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9, Object a10, Object a11, Object a12, Object a13, Object a14, Object a15, Object a16, Object a17, Object a18, Object a19, Object a20) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "Java method " + BlocksClassFilter.getUserVisibleName((String)methodLookupString));
            Object result = this.callJavaVarArgs(methodLookupString, json, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
            String string = result == null ? null : result.toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    private Object callJavaVarArgs(String methodLookupString, String json, Object ... objectArgs) throws Throwable {
        Class<?>[] parameterTypes;
        Method method = BlocksClassFilter.getInstance().findStaticMethod(methodLookupString);
        if (method == null) {
            throw new RuntimeException("Could not find method " + methodLookupString + ".");
        }
        Object[] jsonArgs = (Object[])SimpleGson.getInstance().fromJson(json, Object[].class);
        if (jsonArgs.length != (parameterTypes = method.getParameterTypes()).length || objectArgs.length < parameterTypes.length) {
            throw new RuntimeException("Number of arguments does not match required number of parameters.");
        }
        String[] parameterLabels = HardwareUtil.getParameterLabels(method);
        ArrayList<Gamepad> gamepads = new ArrayList<Gamepad>();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.determineArgument(this.adjustParameterType(parameterTypes[i]), objectArgs[i], jsonArgs[i], parameterLabels[i], gamepads);
        }
        try {
            return method.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke method " + methodLookupString + ".", e);
        }
    }

    @JavascriptInterface
    public Object callHardware(String deviceName, String methodLookupString, String json, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9, Object a10, Object a11, Object a12, Object a13, Object a14, Object a15, Object a16, Object a17, Object a18, Object a19, Object a20) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "Hardware method " + BlocksClassFilter.getUserVisibleName((String)methodLookupString));
            Object object = this.callHardwareVarArgs(deviceName, methodLookupString, json, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
            return object;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean callHardware_boolean(String deviceName, String methodLookupString, String json, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9, Object a10, Object a11, Object a12, Object a13, Object a14, Object a15, Object a16, Object a17, Object a18, Object a19, Object a20) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "Hardware method " + BlocksClassFilter.getUserVisibleName((String)methodLookupString));
            boolean bl = (Boolean)this.callHardwareVarArgs(deviceName, methodLookupString, json, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String callHardware_String(String deviceName, String methodLookupString, String json, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9, Object a10, Object a11, Object a12, Object a13, Object a14, Object a15, Object a16, Object a17, Object a18, Object a19, Object a20) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "Hardware method " + BlocksClassFilter.getUserVisibleName((String)methodLookupString));
            Object result = this.callHardwareVarArgs(deviceName, methodLookupString, json, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
            String string = result == null ? null : result.toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    private Object callHardwareVarArgs(String deviceName, String methodLookupString, String json, Object ... objectArgs) throws Throwable {
        Class<?>[] parameterTypes;
        Method method = BlocksClassFilter.getInstance().findHardwareMethod(methodLookupString);
        if (method == null) {
            throw new RuntimeException("Could not find method " + methodLookupString + ".");
        }
        Object hardwareDevice = this.hardwareMap.get(method.getDeclaringClass(), deviceName);
        Object[] jsonArgs = (Object[])SimpleGson.getInstance().fromJson(json, Object[].class);
        if (jsonArgs.length != (parameterTypes = method.getParameterTypes()).length || objectArgs.length < parameterTypes.length) {
            throw new RuntimeException("Number of arguments does not match required number of parameters.");
        }
        String[] parameterLabels = HardwareUtil.getParameterLabels(method);
        ArrayList<Gamepad> gamepads = new ArrayList<Gamepad>();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.determineArgument(this.adjustParameterType(parameterTypes[i]), objectArgs[i], jsonArgs[i], parameterLabels[i], gamepads);
        }
        try {
            return method.invoke(hardwareDevice, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke method " + methodLookupString + ".", e);
        }
    }

    private Class adjustParameterType(Class parameterType) {
        if (parameterType.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (parameterType.equals(Character.TYPE)) {
            return Character.class;
        }
        if (parameterType.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (parameterType.equals(Short.TYPE)) {
            return Short.class;
        }
        if (parameterType.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (parameterType.equals(Long.TYPE)) {
            return Long.class;
        }
        if (parameterType.equals(Float.TYPE)) {
            return Float.class;
        }
        if (parameterType.equals(Double.TYPE)) {
            return Double.class;
        }
        return parameterType;
    }

    private Object determineArgument(Class parameterType, Object objectArg, Object jsonArg, String parameterLabel, List<Gamepad> gamepads) {
        if (parameterType.equals(LinearOpMode.class) || parameterType.equals(OpMode.class)) {
            return this.blocksOpMode;
        }
        if (parameterType.equals(HardwareMap.class)) {
            return this.blocksOpMode.hardwareMap;
        }
        if (parameterType.equals(Telemetry.class)) {
            return this.blocksOpMode.telemetry;
        }
        if (parameterType.equals(Gamepad.class)) {
            if (parameterLabel.equals("gamepad1")) {
                return this.blocksOpMode.gamepad1;
            }
            if (parameterLabel.equals("gamepad2")) {
                return this.blocksOpMode.gamepad2;
            }
            if (gamepads.isEmpty()) {
                gamepads.add(this.blocksOpMode.gamepad1);
                gamepads.add(this.blocksOpMode.gamepad2);
            }
            return gamepads.remove(0);
        }
        if (objectArg == null) {
            if (jsonArg == null) {
                return null;
            }
            if (parameterType.equals(jsonArg.getClass())) {
                return jsonArg;
            }
            if (jsonArg instanceof String) {
                try {
                    return this.coerceStringValue((String)jsonArg, parameterType);
                }
                catch (Exception exception) {
                    try {
                        return parameterType.cast(jsonArg);
                    }
                    catch (Exception exception2) {}
                }
            }
        } else {
            if (parameterType.equals(objectArg.getClass())) {
                return objectArg;
            }
            try {
                return parameterType.cast(objectArg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Unable to convert " + objectArg + " and/or " + jsonArg + " to " + parameterType + ".");
    }

    private Object coerceStringValue(String value, Class parameterType) {
        if (parameterType.equals(Character.class)) {
            if (value.length() >= 1) {
                return new Character(value.charAt(0));
            }
        } else {
            if (parameterType.equals(Byte.class)) {
                return (byte)MiscAccess.round(value);
            }
            if (parameterType.equals(Short.class)) {
                return (short)MiscAccess.round(value);
            }
            if (parameterType.equals(Integer.class)) {
                return (int)MiscAccess.round(value);
            }
            if (parameterType.equals(Long.class)) {
                return MiscAccess.round(value);
            }
            if (parameterType.equals(Float.class)) {
                return Float.valueOf(value);
            }
            if (parameterType.equals(Double.class)) {
                return Double.valueOf(value);
            }
            if (parameterType.isEnum()) {
                return this.coerceToEnum(value, parameterType);
            }
        }
        throw new RuntimeException("Unable to convert \"" + value + "\" to " + parameterType);
    }

    private Object coerceToEnum(String value, Class parameterType) {
        return this.checkArg(value, parameterType, parameterType.getSimpleName());
    }

    private static long round(String value) {
        return Math.round(Double.valueOf(value));
    }

    @JavascriptInterface
    public int listLength(Object o) {
        try {
            this.startBlockExecution(BlockType.SPECIAL, "length of");
            int n = JavaUtil.listLength((Object)o);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean listIsEmpty(Object o) {
        try {
            this.startBlockExecution(BlockType.SPECIAL, "is empty");
            boolean bl = JavaUtil.listIsEmpty((Object)o);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String huskyLensBlockToText(String json) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "HuskyLens.Block", "toText");
            String string = HuskyLensAccess.huskyLensBlockToText(json);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String huskyLensArrowToText(String json) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "HuskyLens.Arrow", "toText");
            String string = HuskyLensAccess.huskyLensArrowToText(json);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String objectToJson(Object o) {
        try {
            if (o instanceof LLResult) {
                return LLResultAccess.llResultToJson((LLResult)o);
            }
            return MiscAccess.toJson(o);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
    }
}

