/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cCompassSensor;
import com.qualcomm.robotcore.hardware.CompassSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.MagneticFlux;

class MrI2cCompassSensorAccess
extends HardwareAccess<ModernRoboticsI2cCompassSensor> {
    private final ModernRoboticsI2cCompassSensor mrI2cCompassSensor;

    MrI2cCompassSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, ModernRoboticsI2cCompassSensor.class);
        this.mrI2cCompassSensor = (ModernRoboticsI2cCompassSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getDirection"})
    public double getDirection() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Direction");
            double d = this.mrI2cCompassSensor.getDirection();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.mrI2cCompassSensor.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.mrI2cCompassSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.mrI2cCompassSensor.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.mrI2cCompassSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getAcceleration"})
    public double getXAccel() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".XAccel");
            Acceleration acceleration = this.mrI2cCompassSensor.getAcceleration();
            if (acceleration != null) {
                double d = acceleration.xAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getAcceleration"})
    public double getYAccel() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".YAccel");
            Acceleration acceleration = this.mrI2cCompassSensor.getAcceleration();
            if (acceleration != null) {
                double d = acceleration.yAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getAcceleration"})
    public double getZAccel() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZAccel");
            Acceleration acceleration = this.mrI2cCompassSensor.getAcceleration();
            if (acceleration != null) {
                double d = acceleration.zAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getMagneticFlux"})
    public double getXMagneticFlux() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".XMagneticFlux");
            MagneticFlux magneticFlux = this.mrI2cCompassSensor.getMagneticFlux();
            if (magneticFlux != null) {
                double d = magneticFlux.x;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getMagneticFlux"})
    public double getYMagneticFlux() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".YMagneticFlux");
            MagneticFlux magneticFlux = this.mrI2cCompassSensor.getMagneticFlux();
            if (magneticFlux != null) {
                double d = magneticFlux.y;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"getMagneticFlux"})
    public double getZMagneticFlux() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZMagneticFlux");
            MagneticFlux magneticFlux = this.mrI2cCompassSensor.getMagneticFlux();
            if (magneticFlux != null) {
                double d = magneticFlux.z;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"setMode"})
    public void setMode(String compassModeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setMode");
            CompassSensor.CompassMode compassMode = this.checkArg(compassModeString, CompassSensor.CompassMode.class, "compassMode");
            if (compassMode != null) {
                this.mrI2cCompassSensor.setMode(compassMode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"isCalibrating"})
    public boolean isCalibrating() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isCalibrating");
            boolean bl = this.mrI2cCompassSensor.isCalibrating();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cCompassSensor.class}, methodName={"calibrationFailed"})
    public boolean calibrationFailed() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".calibrationFailed");
            boolean bl = this.mrI2cCompassSensor.calibrationFailed();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

