/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cRangeSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

class MrI2cRangeSensorAccess
extends HardwareAccess<ModernRoboticsI2cRangeSensor> {
    private final ModernRoboticsI2cRangeSensor mrI2cRangeSensor;

    MrI2cRangeSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, ModernRoboticsI2cRangeSensor.class);
        this.mrI2cRangeSensor = (ModernRoboticsI2cRangeSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"getLightDetected"})
    public double getLightDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LightDetected");
            double d = this.mrI2cRangeSensor.getLightDetected();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"getRawLightDetected"})
    public double getRawLightDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawLightDetected");
            double d = this.mrI2cRangeSensor.getRawLightDetected();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"getRawLightDetectedMax"})
    public double getRawLightDetectedMax() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawLightDetectedMax");
            double d = this.mrI2cRangeSensor.getRawLightDetectedMax();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"rawUltrasonic"})
    public double getRawUltrasonic() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawUltrasonic");
            double d = this.mrI2cRangeSensor.rawUltrasonic();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"rawOptical"})
    public double getRawOptical() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawOptical");
            double d = this.mrI2cRangeSensor.rawOptical();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"cmUltrasonic"})
    public double getCmUltrasonic() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".CmUltrasonic");
            double d = this.mrI2cRangeSensor.cmUltrasonic();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"cmOptical"})
    public double getCmOptical() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".CmOptical");
            double d = this.mrI2cRangeSensor.cmOptical();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"getDistance"})
    public double getDistance(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistance");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "unit");
            if (distanceUnit != null) {
                double d = this.mrI2cRangeSensor.getDistance(distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.mrI2cRangeSensor.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.mrI2cRangeSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.mrI2cRangeSensor.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cRangeSensor.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.mrI2cRangeSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

