/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.external.hardware.camera.BuiltinCameraDirection;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.UnnormalizedAngleUnit;

class NavigationAccess
extends Access {
    private final HardwareMap hardwareMap;

    NavigationAccess(BlocksOpMode blocksOpMode, String identifier, HardwareMap hardwareMap) {
        super(blocksOpMode, identifier, "");
        this.hardwareMap = hardwareMap;
    }

    @JavascriptInterface
    @Block(classes={AngleUnit.class}, methodName={"normalize"})
    public double angleUnit_normalize(double angle, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AngleUnit", ".normalize");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                double d = angleUnit.normalize(angle);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngleUnit.class}, methodName={"fromUnit"})
    public double angleUnit_convert(double angle, String fromAngleUnitString, String toAngleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AngleUnit", ".convert");
            AngleUnit fromAngleUnit = this.checkArg(fromAngleUnitString, AngleUnit.class, "from");
            AngleUnit toAngleUnit = this.checkArg(toAngleUnitString, AngleUnit.class, "to");
            if (fromAngleUnit != null && toAngleUnit != null) {
                double d = toAngleUnit.fromUnit(fromAngleUnit, angle);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={UnnormalizedAngleUnit.class}, methodName={"fromUnit"})
    public double unnormalizedAngleUnit_convert(double angle, String fromAngleUnitString, String toAngleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "UnnormalizedAngleUnit", ".convert");
            AngleUnit fromAngleUnit = this.checkArg(fromAngleUnitString, AngleUnit.class, "from");
            AngleUnit toAngleUnit = this.checkArg(toAngleUnitString, AngleUnit.class, "to");
            if (fromAngleUnit != null && toAngleUnit != null) {
                double d = toAngleUnit.getUnnormalized().fromUnit(fromAngleUnit.getUnnormalized(), angle);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    private BuiltinCameraDirection checkBuiltinCameraDirection(String cameraDirectionString) {
        return this.checkArg(cameraDirectionString, BuiltinCameraDirection.class, "cameraDirection");
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public BuiltinCameraDirection getBuiltinCameraDirection(String cameraDirectionString) {
        return this.checkBuiltinCameraDirection(cameraDirectionString);
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public WebcamName getWebcamName(String webcamNameString) {
        return (WebcamName)this.hardwareMap.tryGet(WebcamName.class, webcamNameString);
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public CameraName createSwitchableCameraNameForAllWebcams() {
        return ClassFactory.createSwitchableCameraNameForAllWebcams((HardwareMap)this.hardwareMap);
    }
}

