/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.digitalchickenlabs.CachingOctoQuad;
import com.qualcomm.hardware.digitalchickenlabs.OctoQuadBase;
import com.qualcomm.hardware.digitalchickenlabs.OctoQuadImpl;
import com.qualcomm.robotcore.hardware.HardwareMap;

class OctoQuadAccess
extends HardwareAccess<OctoQuadImpl> {
    private final CachingOctoQuad octoQuad;

    OctoQuadAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, OctoQuadImpl.class);
        this.octoQuad = (CachingOctoQuad)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"getChipId"})
    public int getChipId() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ChipId");
            byte by = this.octoQuad.getChipId();
            return by;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"getFirmwareVersionString"})
    public String getFirmwareVersionString() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".FirmwareVersionString");
            String string = this.octoQuad.getFirmwareVersionString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"resetAllPositions"})
    public void resetAllPositions() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetAllPositions");
            this.octoQuad.resetAllPositions();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"resetSinglePosition"})
    public void resetSinglePosition(int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetSinglePosition");
            this.octoQuad.resetSinglePosition(index);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setSingleEncoderDirection"})
    public void setSingleEncoderDirection(int index, String encoderDirectionString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setEncoderDirection");
            OctoQuadBase.EncoderDirection encoderDirection = this.checkArg(encoderDirectionString, OctoQuadBase.EncoderDirection.class, "");
            if (encoderDirection != null) {
                this.octoQuad.setSingleEncoderDirection(index, encoderDirection);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"getSingleEncoderDirection"})
    public String getSingleEncoderDirection(int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".SingleEncoderDirection");
            OctoQuadBase.EncoderDirection encoderDirection = this.octoQuad.getSingleEncoderDirection(index);
            if (encoderDirection != null) {
                String string = encoderDirection.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setAllVelocitySampleIntervals"})
    public void setAllVelocitySampleIntervals(int intervalMillis) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".AllVelocitySampleIntervals");
            this.octoQuad.setAllVelocitySampleIntervals(intervalMillis);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setSingleVelocitySampleInterval"})
    public void setSingleVelocitySampleInterval(int index, int intervalMillis) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".SingleVelocitySampleInterval");
            this.octoQuad.setSingleVelocitySampleInterval(index, intervalMillis);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"getSingleVelocitySampleInterval"})
    public int getSingleVelocitySampleInterval(int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getSingleVelocitySampleInterval");
            int n = this.octoQuad.getSingleVelocitySampleInterval(index);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setSingleChannelPulseWidthParams"})
    public void setSingleChannelPulseWidthParams(int index, int min_length_us, int max_length_us) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setSingleChannelPulseWidthParams");
            this.octoQuad.setSingleChannelPulseWidthParams(index, min_length_us, max_length_us);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"resetEverything"})
    public void resetEverything() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetEverything");
            this.octoQuad.resetEverything();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setChannelBankConfig"})
    public void setChannelBankConfig(String channelBankConfigString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".ChannelBankConfig");
            OctoQuadBase.ChannelBankConfig channelBankConfig = this.checkArg(channelBankConfigString, OctoQuadBase.ChannelBankConfig.class, "");
            if (channelBankConfig != null) {
                this.octoQuad.setChannelBankConfig(channelBankConfig);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"getChannelBankConfig"})
    public String getChannelBankConfig() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ChannelBankConfig");
            OctoQuadBase.ChannelBankConfig channelBankConfig = this.octoQuad.getChannelBankConfig();
            if (channelBankConfig != null) {
                String string = channelBankConfig.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setI2cRecoveryMode"})
    public void setI2cRecoveryMode(String i2cRecoveryModeString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cRecoveryMode");
            OctoQuadBase.I2cRecoveryMode i2cRecoveryMode = this.checkArg(i2cRecoveryModeString, OctoQuadBase.I2cRecoveryMode.class, "");
            if (i2cRecoveryMode != null) {
                this.octoQuad.setI2cRecoveryMode(i2cRecoveryMode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"getI2cRecoveryMode"})
    public String getI2cRecoveryMode() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cRecoveryMode");
            OctoQuadBase.I2cRecoveryMode i2cRecoveryMode = this.octoQuad.getI2cRecoveryMode();
            if (i2cRecoveryMode != null) {
                String string = i2cRecoveryMode.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"saveParametersToFlash"})
    public void saveParametersToFlash() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".saveParametersToFlash");
            this.octoQuad.saveParametersToFlash();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"setCachingMode"})
    public void setCachingMode(String cachingModeString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".CachingMode");
            CachingOctoQuad.CachingMode cachingMode = this.checkArg(cachingModeString, CachingOctoQuad.CachingMode.class, "");
            if (cachingMode != null) {
                this.octoQuad.setCachingMode(cachingMode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"refreshCache"})
    public void refreshCache() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".refreshCache");
            this.octoQuad.refreshCache();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"readSinglePosition_Caching"})
    public int readSinglePosition_Caching(int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".readSinglePosition_Caching");
            int n = this.octoQuad.readSinglePosition_Caching(index);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CachingOctoQuad.class}, methodName={"readSingleVelocity_Caching"})
    public int readSingleVelocity_Caching(int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".readSingleVelocity_Caching");
            short s = this.octoQuad.readSingleVelocity_Caching(index);
            return s;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

