/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.OpenGLMatrix;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;

class OpenGLMatrixAccess
extends Access {
    OpenGLMatrixAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "OpenGLMatrix");
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, constructor=true)
    public OpenGLMatrix create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            OpenGLMatrix openGLMatrix = new OpenGLMatrix();
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, constructor=true)
    public OpenGLMatrix create_withMatrixF(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                OpenGLMatrix openGLMatrix = new OpenGLMatrix(matrix);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"rotation"})
    public OpenGLMatrix rotation(String angleUnitString, float angle, float dx, float dy, float dz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rotation");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                OpenGLMatrix openGLMatrix = OpenGLMatrix.rotation((AngleUnit)angleUnit, (float)angle, (float)dx, (float)dy, (float)dz);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"rotation"})
    public OpenGLMatrix rotation_withAxesArgs(String axesReferenceString, String axesOrderString, String angleUnitString, float firstAngle, float secondAngle, float thirdAngle) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rotation");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                OpenGLMatrix openGLMatrix = OpenGLMatrix.rotation((AxesReference)axesReference, (AxesOrder)axesOrder, (AngleUnit)angleUnit, (float)firstAngle, (float)secondAngle, (float)thirdAngle);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"translation"})
    public OpenGLMatrix translation(float dx, float dy, float dz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".translation");
            OpenGLMatrix openGLMatrix = OpenGLMatrix.translation((float)dx, (float)dy, (float)dz);
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"identityMatrix"})
    public OpenGLMatrix identityMatrix() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".identityMatrix");
            OpenGLMatrix openGLMatrix = OpenGLMatrix.identityMatrix();
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"scale"})
    public void scale_with3(Object matrixArg, float scaleX, float scaleY, float scaleZ) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".scale");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            if (matrix != null) {
                matrix.scale(scaleX, scaleY, scaleZ);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"scale"})
    public void scale_with1(Object matrixArg, float scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".scale");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            if (matrix != null) {
                matrix.scale(scale);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"translate"})
    public void translate(Object matrixArg, float dx, float dy, float dz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".translate");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            if (matrix != null) {
                matrix.translate(dx, dy, dz);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"rotate"})
    public void rotate(Object matrixArg, String angleUnitString, float angle, float dx, float dy, float dz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rotate");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (matrix != null && angleUnit != null) {
                matrix.rotate(angleUnit, angle, dx, dy, dz);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"rotate"})
    public void rotate_withAxesArgs(Object matrixArg, String axesReferenceString, String axesOrderString, String angleUnitString, float firstAngle, float secondAngle, float thirdAngle) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rotate");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (matrix != null && axesReference != null && axesOrder != null && angleUnit != null) {
                matrix.rotate(axesReference, axesOrder, angleUnit, firstAngle, secondAngle, thirdAngle);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"scaled"})
    public OpenGLMatrix scaled_with3(Object matrixArg, float scaleX, float scaleY, float scaleZ) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".scaled");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            if (matrix != null) {
                OpenGLMatrix openGLMatrix = matrix.scaled(scaleX, scaleY, scaleZ);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"scaled"})
    public OpenGLMatrix scaled_with1(Object matrixArg, float scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".scaled");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            if (matrix != null) {
                OpenGLMatrix openGLMatrix = matrix.scaled(scale);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"translated"})
    public OpenGLMatrix translated(Object matrixArg, float dx, float dy, float dz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".translated");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            if (matrix != null) {
                OpenGLMatrix openGLMatrix = matrix.translated(dx, dy, dz);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"rotated"})
    public OpenGLMatrix rotated(Object matrixArg, String angleUnitString, float angle, float dx, float dy, float dz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rotated");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (matrix != null && angleUnit != null) {
                OpenGLMatrix openGLMatrix = matrix.rotated(angleUnit, angle, dx, dy, dz);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"rotated"})
    public OpenGLMatrix rotated_withAxesArgs(Object matrixArg, String axesReferenceString, String axesOrderString, String angleUnitString, float firstAngle, float secondAngle, float thirdAngle) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rotated");
            OpenGLMatrix matrix = this.checkOpenGLMatrix(matrixArg);
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (matrix != null && axesReference != null && axesOrder != null && angleUnit != null) {
                OpenGLMatrix openGLMatrix = matrix.rotated(axesReference, axesOrder, angleUnit, firstAngle, secondAngle, thirdAngle);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"multiplied"})
    public OpenGLMatrix multiplied(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiplied");
            OpenGLMatrix matrix1 = this.checkArg(matrix1Arg, OpenGLMatrix.class, "matrix1");
            OpenGLMatrix matrix2 = this.checkArg(matrix2Arg, OpenGLMatrix.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                OpenGLMatrix openGLMatrix = matrix1.multiplied(matrix2);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OpenGLMatrix.class}, methodName={"multiply"})
    public void multiply(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiply");
            OpenGLMatrix matrix1 = this.checkArg(matrix1Arg, OpenGLMatrix.class, "matrix1");
            OpenGLMatrix matrix2 = this.checkArg(matrix2Arg, OpenGLMatrix.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                matrix1.multiply(matrix2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

