/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.vision.opencv.ColorRange;
import org.firstinspires.ftc.vision.opencv.ColorSpace;
import org.firstinspires.ftc.vision.opencv.ImageRegion;
import org.opencv.core.Scalar;

class OpencvAccess
extends Access {
    OpencvAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "");
    }

    private ColorSpace checkColorSpace(String colorSpaceString) {
        return this.checkArg(colorSpaceString, ColorSpace.class, "colorSpace");
    }

    private Scalar checkScalar(Object scalarArg, String socketName) {
        return this.checkArg(scalarArg, Scalar.class, socketName);
    }

    @JavascriptInterface
    @Block(classes={ColorRange.class}, fieldName={"BLUE", "RED", "YELLOW", "GREEN"})
    public ColorRange colorRange(String color) {
        try {
            this.startBlockExecution(BlockType.GETTER, "ColorRange", "." + color);
            if (color.equals("BLUE")) {
                ColorRange colorRange = ColorRange.BLUE;
                return colorRange;
            }
            if (color.equals("RED")) {
                ColorRange colorRange = ColorRange.RED;
                return colorRange;
            }
            if (color.equals("YELLOW")) {
                ColorRange colorRange = ColorRange.YELLOW;
                return colorRange;
            }
            if (color.equals("GREEN")) {
                ColorRange colorRange = ColorRange.GREEN;
                return colorRange;
            }
            ColorRange colorRange = null;
            return colorRange;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRange.class}, constructor=true)
    public ColorRange createColorRange(String colorSpaceString, Object minArg, Object maxArg) {
        try {
            this.startBlockExecution(BlockType.CREATE, "ColorRange", "");
            ColorSpace colorSpace = this.checkColorSpace(colorSpaceString);
            Scalar min = this.checkScalar(minArg, "min");
            Scalar max = this.checkScalar(maxArg, "max");
            if (colorSpace != null && min != null && max != null) {
                ColorRange colorRange = new ColorRange(colorSpace, min, max);
                return colorRange;
            }
            ColorRange colorRange = null;
            return colorRange;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ImageRegion.class}, methodName={"asImageCoordinates"})
    public ImageRegion asImageCoordinates(int left, int top, int right, int bottom) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ImageRegion", ".asImageCoordinates");
            ImageRegion imageRegion = ImageRegion.asImageCoordinates((int)left, (int)top, (int)right, (int)bottom);
            return imageRegion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ImageRegion.class}, methodName={"asUnityCenterCoordinates"})
    public ImageRegion asUnityCenterCoordinates(double left, double top, double right, double bottom) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ImageRegion", ".asUnityCenterCoordinates");
            ImageRegion imageRegion = ImageRegion.asUnityCenterCoordinates((double)left, (double)top, (double)right, (double)bottom);
            return imageRegion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ImageRegion.class}, methodName={"entireFrame"})
    public ImageRegion entireFrame() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ImageRegion", ".entireFrame");
            ImageRegion imageRegion = ImageRegion.entireFrame();
            return imageRegion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Scalar.class}, constructor=true)
    public Scalar createScalar_with3(double v0, double v1, double v2) {
        try {
            this.startBlockExecution(BlockType.CREATE, "Scalar", "");
            Scalar scalar = new Scalar(v0, v1, v2);
            return scalar;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

