/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsAnalogOpticalDistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.OpticalDistanceSensor;

class OpticalDistanceSensorAccess
extends HardwareAccess<OpticalDistanceSensor> {
    private final OpticalDistanceSensor opticalDistanceSensor;

    OpticalDistanceSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, OpticalDistanceSensor.class);
        this.opticalDistanceSensor = (OpticalDistanceSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsAnalogOpticalDistanceSensor.class, OpticalDistanceSensor.class}, methodName={"getLightDetected"})
    public double getLightDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LightDetected");
            double d = this.opticalDistanceSensor.getLightDetected();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsAnalogOpticalDistanceSensor.class, OpticalDistanceSensor.class}, methodName={"getRawLightDetected"})
    public double getRawLightDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawLightDetected");
            double d = this.opticalDistanceSensor.getRawLightDetected();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsAnalogOpticalDistanceSensor.class, OpticalDistanceSensor.class}, methodName={"getRawLightDetectedMax"})
    public double getRawLightDetectedMax() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawLightDetectedMax");
            double d = this.opticalDistanceSensor.getRawLightDetectedMax();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsAnalogOpticalDistanceSensor.class}, methodName={"enableLed"})
    public void enableLed(boolean enable) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".enableLed");
            this.opticalDistanceSensor.enableLed(enable);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

