/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.OpenGLMatrix;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;

class OrientationAccess
extends Access {
    OrientationAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "Orientation");
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"axesReference"})
    public String getAxesReference(Object orientationArg) {
        try {
            AxesReference axesReference;
            this.startBlockExecution(BlockType.GETTER, ".AxesReference");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null && (axesReference = orientation.axesReference) != null) {
                String string = axesReference.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"axesOrder"})
    public String getAxesOrder(Object orientationArg) {
        try {
            AxesOrder axesOrder;
            this.startBlockExecution(BlockType.GETTER, ".AxesOrder");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null && (axesOrder = orientation.axesOrder) != null) {
                String string = axesOrder.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"angleUnit"})
    public String getAngleUnit(Object orientationArg) {
        try {
            AngleUnit angleUnit;
            this.startBlockExecution(BlockType.GETTER, ".AngleUnit");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null && (angleUnit = orientation.angleUnit) != null) {
                String string = angleUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"firstAngle"})
    public float getFirstAngle(Object orientationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".FirstAngle");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null) {
                float f = orientation.firstAngle;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"secondAngle"})
    public float getSecondAngle(Object orientationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".SecondAngle");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null) {
                float f = orientation.secondAngle;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"thirdAngle"})
    public float getThirdAngle(Object orientationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ThirdAngle");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null) {
                float f = orientation.thirdAngle;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object orientationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null) {
                long l = orientation.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, constructor=true)
    public Orientation create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Orientation orientation = new Orientation();
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, constructor=true)
    public Orientation create_withArgs(String axesReferenceString, String axesOrderString, String angleUnitString, float firstAngle, float secondAngle, float thirdAngle, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                Orientation orientation = new Orientation(axesReference, axesOrder, angleUnit, firstAngle, secondAngle, thirdAngle, acquisitionTime);
                return orientation;
            }
            Orientation orientation = null;
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, constructor=true)
    public Orientation create_withArgs2(String axesReferenceString, String axesOrderString, String angleUnitString, float firstAngle, float secondAngle, float thirdAngle) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                Orientation orientation = new Orientation(axesReference, axesOrder, angleUnit, firstAngle, secondAngle, thirdAngle, 0L);
                return orientation;
            }
            Orientation orientation = null;
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"toAngleUnit"})
    public Orientation toAngleUnit(Object orientationArg, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toAngleUnit");
            Orientation orientation = this.checkOrientation(orientationArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (orientation != null && angleUnit != null) {
                Orientation orientation2 = orientation.toAngleUnit(angleUnit);
                return orientation2;
            }
            Orientation orientation3 = null;
            return orientation3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"toAxesReference"})
    public Orientation toAxesReference(Object orientationArg, String axesReferenceString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toAxesReference");
            Orientation orientation = this.checkOrientation(orientationArg);
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            if (orientation != null && axesReference != null) {
                Orientation orientation2 = orientation.toAxesReference(axesReference);
                return orientation2;
            }
            Orientation orientation3 = null;
            return orientation3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"toAxesOrder"})
    public Orientation toAxesOrder(Object orientationArg, String axesOrderString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toAxesOrder");
            Orientation orientation = this.checkOrientation(orientationArg);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            if (orientation != null && axesOrder != null) {
                Orientation orientation2 = orientation.toAxesOrder(axesOrder);
                return orientation2;
            }
            Orientation orientation3 = null;
            return orientation3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"toString"})
    public String toText(Object orientationArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null) {
                String string = orientation.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"getRotationMatrix"})
    public OpenGLMatrix getRotationMatrix(Object orientationArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRotationMatrix");
            Orientation orientation = this.checkOrientation(orientationArg);
            if (orientation != null) {
                OpenGLMatrix openGLMatrix = orientation.getRotationMatrix();
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"getRotationMatrix"})
    public OpenGLMatrix getRotationMatrix_withArgs(String axesReferenceString, String axesOrderString, String angleUnitString, float firstAngle, float secondAngle, float thirdAngle) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRotationMatrix");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                OpenGLMatrix openGLMatrix = Orientation.getRotationMatrix((AxesReference)axesReference, (AxesOrder)axesOrder, (AngleUnit)angleUnit, (float)firstAngle, (float)secondAngle, (float)thirdAngle);
                return openGLMatrix;
            }
            OpenGLMatrix openGLMatrix = null;
            return openGLMatrix;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Orientation.class}, methodName={"getOrientation"})
    public Orientation getOrientation(Object matrixArg, String axesReferenceString, String axesOrderString, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getOrientation");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (matrix != null && axesReference != null && axesOrder != null && angleUnit != null) {
                Orientation orientation = Orientation.getOrientation((MatrixF)matrix, (AxesReference)axesReference, (AxesOrder)axesOrder, (AngleUnit)angleUnit);
                return orientation;
            }
            Orientation orientation = null;
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

