/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.hardware.MotorControlAlgorithm;
import com.qualcomm.robotcore.hardware.PIDFCoefficients;

class PIDFCoefficientsAccess
extends Access {
    PIDFCoefficientsAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "PIDFCoefficients");
    }

    private PIDFCoefficients checkPIDFCoefficients(Object pidfCoefficientsArg) {
        return this.checkArg(pidfCoefficientsArg, PIDFCoefficients.class, "pidfCoefficients");
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, constructor=true)
    public PIDFCoefficients create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            PIDFCoefficients pIDFCoefficients = new PIDFCoefficients();
            return pIDFCoefficients;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, constructor=true)
    public PIDFCoefficients create_withPIDFAlgorithm(double p, double i, double d, double f, String algorithmString) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            MotorControlAlgorithm algorithm = this.checkArg(algorithmString, MotorControlAlgorithm.class, "algorithm");
            if (algorithm != null) {
                PIDFCoefficients pIDFCoefficients = new PIDFCoefficients(p, i, d, f, algorithm);
                return pIDFCoefficients;
            }
            PIDFCoefficients pIDFCoefficients = null;
            return pIDFCoefficients;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, constructor=true)
    public PIDFCoefficients create_withPIDF(double p, double i, double d, double f) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            PIDFCoefficients pIDFCoefficients = new PIDFCoefficients(p, i, d, f);
            return pIDFCoefficients;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, constructor=true)
    public PIDFCoefficients create_withPIDFCoefficients(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                PIDFCoefficients pIDFCoefficients = new PIDFCoefficients(pidfCoefficients);
                return pIDFCoefficients;
            }
            PIDFCoefficients pIDFCoefficients = null;
            return pIDFCoefficients;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"p"})
    public void setP(Object pidfCoefficientsArg, double p) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".P");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                pidfCoefficients.p = p;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"p"})
    public double getP(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".P");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                double d = pidfCoefficients.p;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"i"})
    public void setI(Object pidfCoefficientsArg, double i) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                pidfCoefficients.i = i;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"i"})
    public double getI(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                double d = pidfCoefficients.i;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"d"})
    public void setD(Object pidfCoefficientsArg, double d) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".D");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                pidfCoefficients.d = d;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"d"})
    public double getD(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".D");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                double d = pidfCoefficients.d;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"f"})
    public void setF(Object pidfCoefficientsArg, double f) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".F");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                pidfCoefficients.f = f;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"f"})
    public double getF(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".F");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                double d = pidfCoefficients.f;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"algorithm"})
    public void setAlgorithm(Object pidfCoefficientsArg, String algorithmString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Algorithm");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            MotorControlAlgorithm algorithm = this.checkArg(algorithmString, MotorControlAlgorithm.class, "");
            if (pidfCoefficients != null && algorithm != null) {
                pidfCoefficients.algorithm = algorithm;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, fieldName={"algorithm"})
    public String getAlgorithm(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Algorithm");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null && pidfCoefficients.algorithm != null) {
                String string = pidfCoefficients.algorithm.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PIDFCoefficients.class}, methodName={"toString"})
    public String toText(Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            PIDFCoefficients pidfCoefficients = this.checkPIDFCoefficients(pidfCoefficientsArg);
            if (pidfCoefficients != null) {
                String string = pidfCoefficients.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

