/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Position;

class PositionAccess
extends Access {
    PositionAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "Position");
    }

    @JavascriptInterface
    @Block(classes={Position.class}, fieldName={"unit"})
    public String getDistanceUnit(Object positionArg) {
        try {
            DistanceUnit distanceUnit;
            this.startBlockExecution(BlockType.GETTER, ".DistanceUnit");
            Position position = this.checkPosition(positionArg);
            if (position != null && (distanceUnit = position.unit) != null) {
                String string = distanceUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, fieldName={"x"})
    public double getX(Object positionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".X");
            Position position = this.checkPosition(positionArg);
            if (position != null) {
                double d = position.x;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, fieldName={"y"})
    public double getY(Object positionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Y");
            Position position = this.checkPosition(positionArg);
            if (position != null) {
                double d = position.y;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, fieldName={"z"})
    public double getZ(Object positionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Z");
            Position position = this.checkPosition(positionArg);
            if (position != null) {
                double d = position.z;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object positionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            Position position = this.checkPosition(positionArg);
            if (position != null) {
                long l = position.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, constructor=true)
    public Position create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Position position = new Position();
            return position;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, constructor=true)
    public Position create_withArgs(String distanceUnitString, double x, double y, double z, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (distanceUnit != null) {
                Position position = new Position(distanceUnit, x, y, z, acquisitionTime);
                return position;
            }
            Position position = null;
            return position;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, methodName={"toUnit"})
    public Position toDistanceUnit(Object positionArg, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toDistanceUnit");
            Position position = this.checkPosition(positionArg);
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (position != null && distanceUnit != null) {
                Position position2 = position.toUnit(distanceUnit);
                return position2;
            }
            Position position3 = null;
            return position3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Position.class}, methodName={"toString"})
    public String toText(Object positionArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            Position position = this.checkPosition(positionArg);
            if (position != null) {
                String string = position.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

