/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.vision.opencv.ImageRegion;
import org.firstinspires.ftc.vision.opencv.PredominantColorProcessor;

class PredominantColorAccess
extends Access {
    PredominantColorAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "");
    }

    private PredominantColorProcessor.Builder checkPredominantColorProcessorBuilder(Object predominantColorProcessorBuilderArg) {
        return this.checkArg(predominantColorProcessorBuilderArg, PredominantColorProcessor.Builder.class, "predominantColorProcessorBuilder");
    }

    private PredominantColorProcessor checkPredominantColorProcessor(Object predominantColorProcessorArg) {
        return this.checkArg(predominantColorProcessorArg, PredominantColorProcessor.class, "predominantColorProcessor");
    }

    private PredominantColorProcessor.Swatch checkSwatch(String swatchString) {
        return this.checkArg(swatchString, PredominantColorProcessor.Swatch.class, "swatch");
    }

    @JavascriptInterface
    @Block(classes={PredominantColorProcessor.Builder.class}, constructor=true)
    public PredominantColorProcessor.Builder createPredominantColorProcessorBuilder() {
        try {
            this.startBlockExecution(BlockType.CREATE, "PredominantColorProcessor.Builder", "");
            PredominantColorProcessor.Builder builder = new PredominantColorProcessor.Builder();
            return builder;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PredominantColorProcessor.Builder.class}, methodName={"setRoi"})
    public void setRoi(Object predominantColorProcessorBuilderArg, Object imageRegionArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "PredominantColorProcessor.Builder", ".setRoi");
            PredominantColorProcessor.Builder predominantColorProcessorBuilder = this.checkPredominantColorProcessorBuilder(predominantColorProcessorBuilderArg);
            ImageRegion imageRegion = this.checkImageRegion(imageRegionArg);
            if (predominantColorProcessorBuilder != null && imageRegion != null) {
                predominantColorProcessorBuilder.setRoi(imageRegion);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PredominantColorProcessor.Builder.class}, methodName={"setSwatches"})
    public void setSwatches(Object predominantColorProcessorBuilderArg, String json) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "PredominantColorProcessor.Builder", ".setSwatches");
            PredominantColorProcessor.Builder predominantColorProcessorBuilder = this.checkPredominantColorProcessorBuilder(predominantColorProcessorBuilderArg);
            if (predominantColorProcessorBuilder != null) {
                String[] swatchStrings = PredominantColorAccess.fromJson(json, String[].class);
                PredominantColorProcessor.Swatch[] swatches = new PredominantColorProcessor.Swatch[swatchStrings.length];
                for (int i = 0; i < swatches.length; ++i) {
                    swatches[i] = this.checkSwatch(swatchStrings[i]);
                }
                predominantColorProcessorBuilder.setSwatches(swatches);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PredominantColorProcessor.Builder.class}, methodName={"build"})
    public PredominantColorProcessor buildPredominantColorProcessor(Object predominantColorProcessorBuilderArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "PredominantColorProcessor.Builder", ".build");
            PredominantColorProcessor.Builder predominantColorProcessorBuilder = this.checkPredominantColorProcessorBuilder(predominantColorProcessorBuilderArg);
            if (predominantColorProcessorBuilder != null) {
                PredominantColorProcessor predominantColorProcessor = predominantColorProcessorBuilder.build();
                return predominantColorProcessor;
            }
            PredominantColorProcessor predominantColorProcessor = null;
            return predominantColorProcessor;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PredominantColorProcessor.class}, methodName={"getAnalysis"})
    public String getAnalysis(Object predominantColorProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "PredominantColorProcessor", ".getAnalysis");
            PredominantColorProcessor predominantColorProcessor = this.checkPredominantColorProcessor(predominantColorProcessorArg);
            if (predominantColorProcessor != null) {
                String string = PredominantColorAccess.toJson(predominantColorProcessor.getAnalysis());
                return string;
            }
            String string = null;
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

