/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;

class QuaternionAccess
extends Access {
    QuaternionAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "Quaternion");
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, fieldName={"w"})
    public float getW(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".W");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                float f = quaternion.w;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, fieldName={"x"})
    public float getX(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".X");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                float f = quaternion.x;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, fieldName={"y"})
    public float getY(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Y");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                float f = quaternion.y;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, fieldName={"z"})
    public float getZ(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Z");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                float f = quaternion.z;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                long l = quaternion.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, methodName={"magnitude"})
    public float getMagnitude(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Magnitude");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                float f = quaternion.magnitude();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, constructor=true)
    public Quaternion create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Quaternion quaternion = new Quaternion();
            return quaternion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, constructor=true)
    public Quaternion create_withArgs(float w, float x, float y, float z, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Quaternion quaternion = new Quaternion(w, x, y, z, acquisitionTime);
            return quaternion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, constructor=true)
    public Quaternion create_withArgs2(float w, float x, float y, float z) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Quaternion quaternion = new Quaternion(w, x, y, z, 0L);
            return quaternion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, methodName={"normalized"})
    public Quaternion normalized(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".normalized");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                Quaternion quaternion2 = quaternion.normalized();
                return quaternion2;
            }
            Quaternion quaternion3 = null;
            return quaternion3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, methodName={"congugate"})
    public Quaternion congugate(Object quaternionArg) {
        return this.conjugate(quaternionArg);
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, methodName={"conjugate"})
    public Quaternion conjugate(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".conjugate");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                Quaternion quaternion2 = quaternion.conjugate();
                return quaternion2;
            }
            Quaternion quaternion3 = null;
            return quaternion3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Quaternion.class}, methodName={"toString"})
    public String toText(Object quaternionArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            Quaternion quaternion = this.checkQuaternion(quaternionArg);
            if (quaternion != null) {
                String string = quaternion.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

