/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.rev.RevBlinkinLedDriver;
import com.qualcomm.robotcore.hardware.HardwareMap;

class RevBlinkinLedDriverAccess
extends HardwareAccess<RevBlinkinLedDriver> {
    private final RevBlinkinLedDriver revBlinkinLedDriver;

    RevBlinkinLedDriverAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, RevBlinkinLedDriver.class);
        this.revBlinkinLedDriver = (RevBlinkinLedDriver)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={RevBlinkinLedDriver.class}, methodName={"setPattern"})
    public void setPattern(String blinkinPatternString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Pattern");
            RevBlinkinLedDriver.BlinkinPattern blinkinPattern = this.checkBlinkinPattern(blinkinPatternString);
            if (blinkinPattern != null) {
                this.revBlinkinLedDriver.setPattern(blinkinPattern);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

