/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.PwmControl;
import com.qualcomm.robotcore.hardware.Servo;
import com.qualcomm.robotcore.hardware.ServoImplEx;

class ServoAccess
extends HardwareAccess<ServoImplEx> {
    private final ServoImplEx servo;

    ServoAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, ServoImplEx.class);
        this.servo = (ServoImplEx)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={Servo.class}, methodName={"setDirection"})
    public void setDirection(String directionString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Direction");
            Servo.Direction direction = this.checkArg(directionString, Servo.Direction.class, "");
            if (direction != null) {
                this.servo.setDirection(direction);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Servo.class}, methodName={"getDirection"})
    public String getDirection() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Direction");
            Servo.Direction direction = this.servo.getDirection();
            if (direction != null) {
                String string = direction.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Servo.class}, methodName={"setPosition"})
    public void setPosition(double position) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Position");
            this.servo.setPosition(position);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Servo.class}, methodName={"getPosition"})
    public double getPosition() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Position");
            double d = this.servo.getPosition();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Servo.class}, methodName={"scaleRange"})
    public void scaleRange(double min, double max) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".scaleRange");
            this.servo.scaleRange(min, max);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PwmControl.class}, methodName={"setPwmEnable"})
    public void setPwmEnable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPwmEnable");
            this.servo.setPwmEnable();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PwmControl.class}, methodName={"setPwmDisable"})
    public void setPwmDisable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPwmDisable");
            this.servo.setPwmDisable();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PwmControl.class}, methodName={"isPwmEnabled"})
    public boolean isPwmEnabled() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isPwmEnabled");
            boolean bl = this.servo.isPwmEnabled();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

