/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.ServoController;

class ServoControllerAccess
extends HardwareAccess<ServoController> {
    private final ServoController servoController;

    ServoControllerAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, ServoController.class);
        this.servoController = (ServoController)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={ServoController.class}, methodName={"getPwmStatus"})
    public String getPwmStatus() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".PwmStatus");
            ServoController.PwmStatus pwmStatus = this.servoController.getPwmStatus();
            if (pwmStatus != null) {
                String string = pwmStatus.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ServoController.class}, methodName={"pwmEnable"})
    public void pwmEnable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".pwmEnable");
            this.servoController.pwmEnable();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ServoController.class}, methodName={"pwmDisable"})
    public void pwmDisable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".pwmDisable");
            this.servoController.pwmDisable();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

