/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.sparkfun.SparkFunLEDStick;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;

class SparkFunLEDStickAccess
extends HardwareAccess<SparkFunLEDStick> {
    private final SparkFunLEDStick sparkFunLEDStick;

    SparkFunLEDStickAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, SparkFunLEDStick.class);
        this.sparkFunLEDStick = (SparkFunLEDStick)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={SparkFunLEDStick.class}, methodName={"setColor"})
    public void setColor_withPosition(int position, long longColor) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setColor");
            int color = (int)(longColor & 0xFFFFFFFFFFFFFFFFL);
            this.sparkFunLEDStick.setColor(position, color);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunLEDStick.class}, methodName={"setColor"})
    public void setColor(long longColor) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setColor");
            int color = (int)(longColor & 0xFFFFFFFFFFFFFFFFL);
            this.sparkFunLEDStick.setColor(color);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunLEDStick.class}, methodName={"setColors"})
    public void setColors(String jsonColors) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setColors");
            long[] longColors = (long[])SimpleGson.getInstance().fromJson(jsonColors, long[].class);
            int[] colors = new int[longColors.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = (int)(longColors[i] & 0xFFFFFFFFFFFFFFFFL);
            }
            this.sparkFunLEDStick.setColors(colors);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunLEDStick.class}, methodName={"setBrightness"})
    public void setBrightness_withPosition(int position, int brightness) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setBrightness");
            this.sparkFunLEDStick.setBrightness(position, brightness);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunLEDStick.class}, methodName={"setBrightness"})
    public void setBrightness(int brightness) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setBrightness");
            this.sparkFunLEDStick.setBrightness(brightness);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunLEDStick.class}, methodName={"turnAllOff"})
    public void turnAllOff() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".turnAllOff");
            this.sparkFunLEDStick.turnAllOff();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

