/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.sparkfun.SparkFunOTOS;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;

class SparkFunOTOSAccess
extends HardwareAccess<SparkFunOTOS> {
    private final SparkFunOTOS sparkFunOTOS;

    SparkFunOTOSAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, SparkFunOTOS.class);
        this.sparkFunOTOS = (SparkFunOTOS)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getImuCalibrationProgress"})
    public int getImuCalibrationProgress() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ImuCalibrationProgress");
            int n = this.sparkFunOTOS.getImuCalibrationProgress();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getLinearScalar"})
    public double getLinearScalar() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LinearScalar");
            double d = this.sparkFunOTOS.getLinearScalar();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setLinearScalar"})
    public boolean setLinearScalar(double scalar) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".LinearScalar");
            boolean bl = this.sparkFunOTOS.setLinearScalar(scalar);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getAngularScalar"})
    public double getAngularScalar() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularScalar");
            double d = this.sparkFunOTOS.getAngularScalar();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setAngularScalar"})
    public boolean setAngularScalar(double scalar) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".AngularScalar");
            boolean bl = this.sparkFunOTOS.setAngularScalar(scalar);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getLinearUnit"})
    public String getLinearUnit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LinearUnit");
            DistanceUnit distanceUnit = this.sparkFunOTOS.getLinearUnit();
            if (distanceUnit != null) {
                String string = distanceUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setLinearUnit"})
    public void setLinearUnit(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".LinearUnit");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "");
            if (distanceUnit != null) {
                this.sparkFunOTOS.setLinearUnit(distanceUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getAngularUnit"})
    public String getAngularUnit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularUnit");
            AngleUnit angleUnit = this.sparkFunOTOS.getAngularUnit();
            if (angleUnit != null) {
                String string = angleUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setAngularUnit"})
    public void setAngularUnit(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".AngularUnit");
            AngleUnit angleUnit = this.checkArg(angleUnitString, AngleUnit.class, "");
            if (angleUnit != null) {
                this.sparkFunOTOS.setAngularUnit(angleUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getStatus"})
    public String getStatus() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Status");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getStatus());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getOffset"})
    public String getOffset() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Offset");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getOffset());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setOffset"})
    public void setOffset(String json) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Offset");
            SparkFunOTOS.Pose2D pose = (SparkFunOTOS.Pose2D)SimpleGson.getInstance().fromJson(json, SparkFunOTOS.Pose2D.class);
            this.sparkFunOTOS.setOffset(pose);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getPosition"})
    public String getPosition() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Position");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getPosition());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setPosition"})
    public void setPosition(String json) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Position");
            SparkFunOTOS.Pose2D pose = (SparkFunOTOS.Pose2D)SimpleGson.getInstance().fromJson(json, SparkFunOTOS.Pose2D.class);
            this.sparkFunOTOS.setPosition(pose);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getAcceleration"})
    public String getAcceleration() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Acceleration");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getAcceleration());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getVelocity"})
    public String getVelocity() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Velocity");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getVelocity());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getPositionStdDev"})
    public String getPositionStdDev() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".PositionStdDev");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getPositionStdDev());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getAccelerationStdDev"})
    public String getAccelerationStdDev() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AccelerationStdDev");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getAccelerationStdDev());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getVelocityStdDev"})
    public String getVelocityStdDev() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".VelocityStdDev");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getVelocityStdDev());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getSignalProcessConfig"})
    public String getSignalProcessConfig() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".SignalProcessConfig");
            String string = SimpleGson.getInstance().toJson((Object)this.sparkFunOTOS.getSignalProcessConfig());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"setSignalProcessConfig"})
    public void setSignalProcessConfig(String json) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".SignalProcessConfig");
            SparkFunOTOS.SignalProcessConfig signalProcessConfig = (SparkFunOTOS.SignalProcessConfig)SimpleGson.getInstance().fromJson(json, SparkFunOTOS.SignalProcessConfig.class);
            this.sparkFunOTOS.setSignalProcessConfig(signalProcessConfig);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getPosVelAcc"})
    public String getPosVelAcc(String json1, String json2, String json3) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getPosVelAcc");
            SimpleGson.getInstance().fromJson(json1, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json2, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json3, SparkFunOTOS.Pose2D.class);
            SparkFunOTOS.Pose2D[] posVelAcc = new SparkFunOTOS.Pose2D[3];
            for (int i = 0; i < posVelAcc.length; ++i) {
                posVelAcc[i] = new SparkFunOTOS.Pose2D();
            }
            this.sparkFunOTOS.getPosVelAcc(posVelAcc[0], posVelAcc[1], posVelAcc[2]);
            String string = SimpleGson.getInstance().toJson((Object)posVelAcc);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getPosVelAccStdDev"})
    public String getPosVelAccStdDev(String json1, String json2, String json3) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getPosVelAccStdDev");
            SimpleGson.getInstance().fromJson(json1, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json2, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json3, SparkFunOTOS.Pose2D.class);
            SparkFunOTOS.Pose2D[] posVelAccStdDev = new SparkFunOTOS.Pose2D[3];
            for (int i = 0; i < posVelAccStdDev.length; ++i) {
                posVelAccStdDev[i] = new SparkFunOTOS.Pose2D();
            }
            this.sparkFunOTOS.getPosVelAccStdDev(posVelAccStdDev[0], posVelAccStdDev[1], posVelAccStdDev[2]);
            String string = SimpleGson.getInstance().toJson((Object)posVelAccStdDev);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getPosVelAccAndStdDev"})
    public String getPosVelAccAndStdDev(String json1, String json2, String json3, String json4, String json5, String json6) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getPosVelAccAndStdDev");
            SimpleGson.getInstance().fromJson(json1, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json2, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json3, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json4, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json5, SparkFunOTOS.Pose2D.class);
            SimpleGson.getInstance().fromJson(json6, SparkFunOTOS.Pose2D.class);
            SparkFunOTOS.Pose2D[] posVelAccAndStdDev = new SparkFunOTOS.Pose2D[6];
            for (int i = 0; i < posVelAccAndStdDev.length; ++i) {
                posVelAccAndStdDev[i] = new SparkFunOTOS.Pose2D();
            }
            this.sparkFunOTOS.getPosVelAccAndStdDev(posVelAccAndStdDev[0], posVelAccAndStdDev[1], posVelAccAndStdDev[2], posVelAccAndStdDev[3], posVelAccAndStdDev[4], posVelAccAndStdDev[5]);
            String string = SimpleGson.getInstance().toJson((Object)posVelAccAndStdDev);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"getVersionInfo"})
    public String getVersionInfo(String json1, String json2) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getVersionInfo");
            SimpleGson.getInstance().fromJson(json1, SparkFunOTOS.Version.class);
            SimpleGson.getInstance().fromJson(json2, SparkFunOTOS.Version.class);
            SparkFunOTOS.Version[] versionInfo = new SparkFunOTOS.Version[2];
            for (int i = 0; i < versionInfo.length; ++i) {
                versionInfo[i] = new SparkFunOTOS.Version();
            }
            this.sparkFunOTOS.getVersionInfo(versionInfo[0], versionInfo[1]);
            String string = SimpleGson.getInstance().toJson((Object)versionInfo);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"resetTracking"})
    public void resetTracking() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetTracking");
            this.sparkFunOTOS.resetTracking();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"begin"})
    public boolean begin() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".begin");
            boolean bl = this.sparkFunOTOS.begin();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"calibrateImu"})
    public boolean calibrateImu() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".calibrateImu");
            boolean bl = this.sparkFunOTOS.calibrateImu();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"calibrateImu"})
    public boolean calibrateImu_withArgs(int numSamples, boolean waitUntilDone) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".calibrateImu");
            boolean bl = this.sparkFunOTOS.calibrateImu(numSamples, waitUntilDone);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"isConnected"})
    public boolean isConnected() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isConnected");
            boolean bl = this.sparkFunOTOS.isConnected();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={SparkFunOTOS.class}, methodName={"selfTest"})
    public boolean selfTest() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".selfTest");
            boolean bl = this.sparkFunOTOS.selfTest();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

