/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.Telemetry;

class TelemetryAccess
extends Access {
    private final Telemetry telemetry;

    TelemetryAccess(BlocksOpMode blocksOpMode, String identifier, Telemetry telemetry) {
        super(blocksOpMode, identifier, "Telemetry");
        this.telemetry = telemetry;
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"addData"})
    public void addNumericData(String key, double data) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".addData");
            this.telemetry.addData(key, (Object)data);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"addData"})
    public void addTextData(String key, String data) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".addData");
            if (data != null) {
                this.telemetry.addData(key, (Object)data);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"addData"})
    public void addObjectData(String key, Object data) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".addData");
            this.telemetry.addData(key, (Object)("" + data));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"addLine"})
    public void addLine(String text) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".addLine");
            this.telemetry.addLine(text);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"update"})
    public void update() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".update");
            this.telemetry.update();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"speak"})
    public void speakTextData(String data, String languageCode, String countryCode) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".speak");
            if (data != null) {
                this.telemetry.speak(data, languageCode, countryCode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"speak"})
    public void speakObjectData(Object data, String languageCode, String countryCode) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".speak");
            this.telemetry.speak("" + data, languageCode, countryCode);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"setDisplayFormat"})
    public void setDisplayFormat(String displayFormatString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setDisplayFormat");
            Telemetry.DisplayFormat displayFormat = this.checkArg(displayFormatString, Telemetry.DisplayFormat.class, "displayFormat");
            if (displayFormat != null) {
                this.telemetry.setDisplayFormat(displayFormat);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"setNumDecimalPlaces"})
    public void setNumDecimalPlaces(int minDecimalPlaces, int maxDecimalPlaces) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setNumDecimalPlaces");
            this.telemetry.setNumDecimalPlaces(minDecimalPlaces, maxDecimalPlaces);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"setMsTransmissionInterval"})
    public void setMsTransmissionInterval(int interval) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".MsTransmissionInterval");
            this.telemetry.setMsTransmissionInterval(interval);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Telemetry.class}, methodName={"getMsTransmissionInterval"})
    public int getMsTransmissionInterval() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".MsTransmissionInterval");
            int n = this.telemetry.getMsTransmissionInterval();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

