/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.TempUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Temperature;

class TemperatureAccess
extends Access {
    TemperatureAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "Temperature");
    }

    private Temperature checkTemperature(Object temperatureArg) {
        return this.checkArg(temperatureArg, Temperature.class, "temperature");
    }

    private TempUnit checkTempUnit(String tempUnitString) {
        return this.checkArg(tempUnitString, TempUnit.class, "tempUnit");
    }

    @JavascriptInterface
    @Block(classes={Temperature.class}, fieldName={"unit"})
    public String getTempUnit(Object temperatureArg) {
        try {
            TempUnit tempUnit;
            this.startBlockExecution(BlockType.GETTER, ".TempUnit");
            Temperature temperature = this.checkTemperature(temperatureArg);
            if (temperature != null && (tempUnit = temperature.unit) != null) {
                String string = tempUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Temperature.class}, fieldName={"temperature"})
    public double getTemperature(Object temperatureArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Temperature");
            Temperature temperature = this.checkTemperature(temperatureArg);
            if (temperature != null) {
                double d = temperature.temperature;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Temperature.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object temperatureArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            Temperature temperature = this.checkTemperature(temperatureArg);
            if (temperature != null) {
                long l = temperature.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Temperature.class}, constructor=true)
    public Temperature create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Temperature temperature = new Temperature();
            return temperature;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Temperature.class}, constructor=true)
    public Temperature create_withArgs(String tempUnitString, double temperature, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            TempUnit tempUnit = this.checkTempUnit(tempUnitString);
            if (tempUnit != null) {
                Temperature temperature2 = new Temperature(tempUnit, temperature, acquisitionTime);
                return temperature2;
            }
            Temperature temperature3 = null;
            return temperature3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Temperature.class}, methodName={"toUnit"})
    public Temperature toTempUnit(Object temperatureArg, String tempUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toTempUnit");
            Temperature temperature = this.checkTemperature(temperatureArg);
            TempUnit tempUnit = this.checkTempUnit(tempUnitString);
            if (temperature != null && tempUnit != null) {
                Temperature temperature2 = temperature.toUnit(tempUnit);
                return temperature2;
            }
            Temperature temperature3 = null;
            return temperature3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

