/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.VectorF;

class VectorFAccess
extends Access {
    VectorFAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "VectorF");
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"length"})
    public int getLength(Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Length");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                int n = vector.length();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"magnitude"})
    public float getMagnitude(Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Magnitude");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                float f = vector.magnitude();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"length"})
    public VectorF create(int length) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            VectorF vectorF = VectorF.length((int)length);
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"get"})
    public float get(Object vectorArg, int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".get");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                float f = vector.get(index);
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"put"})
    public void put(Object vectorArg, int index, float value) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".put");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                vector.put(index, value);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"toString"})
    public String toText(Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                String string = vector.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"normalized3D"})
    public VectorF normalized3D(Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".normalized3D");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                VectorF vectorF = vector.normalized3D();
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"dotProduct"})
    public float dotProduct(Object vector1Arg, Object vector2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".dotProduct");
            VectorF vector1 = this.checkArg(vector1Arg, VectorF.class, "vector1");
            VectorF vector2 = this.checkArg(vector2Arg, VectorF.class, "vector2");
            if (vector1 != null && vector2 != null) {
                float f = vector1.dotProduct(vector2);
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"multiplied"})
    public MatrixF multiplied(Object vectorArg, Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiplied");
            VectorF vector = this.checkVectorF(vectorArg);
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (vector != null && matrix != null) {
                MatrixF matrixF = vector.multiplied(matrix);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"added"})
    public MatrixF added_withMatrix(Object vectorArg, Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".added");
            VectorF vector = this.checkVectorF(vectorArg);
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (vector != null && matrix != null) {
                MatrixF matrixF = vector.added(matrix);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"added"})
    public VectorF added_withVector(Object vector1Arg, Object vector2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".added");
            VectorF vector1 = this.checkArg(vector1Arg, VectorF.class, "vector1");
            VectorF vector2 = this.checkArg(vector2Arg, VectorF.class, "vector2");
            if (vector1 != null && vector2 != null) {
                VectorF vectorF = vector1.added(vector2);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"add"})
    public void add_withVector(Object vector1Arg, Object vector2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".add");
            VectorF vector1 = this.checkArg(vector1Arg, VectorF.class, "vector1");
            VectorF vector2 = this.checkArg(vector2Arg, VectorF.class, "vector2");
            if (vector1 != null && vector2 != null) {
                vector1.add(vector2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"subtracted"})
    public MatrixF subtracted_withMatrix(Object vectorArg, Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtracted");
            VectorF vector = this.checkVectorF(vectorArg);
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (vector != null && matrix != null) {
                MatrixF matrixF = vector.subtracted(matrix);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"subtracted"})
    public VectorF subtracted_withVector(Object vector1Arg, Object vector2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtracted");
            VectorF vector1 = this.checkArg(vector1Arg, VectorF.class, "vector1");
            VectorF vector2 = this.checkArg(vector2Arg, VectorF.class, "vector2");
            if (vector1 != null && vector2 != null) {
                VectorF vectorF = vector1.subtracted(vector2);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"subtract"})
    public void subtract_withVector(Object vector1Arg, Object vector2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtract");
            VectorF vector1 = this.checkArg(vector1Arg, VectorF.class, "vector1");
            VectorF vector2 = this.checkArg(vector2Arg, VectorF.class, "vector2");
            if (vector1 != null && vector2 != null) {
                vector1.subtract(vector2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"multiplied"})
    public VectorF multiplied_withScale(Object vectorArg, float scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiplied");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                VectorF vectorF = vector.multiplied(scale);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VectorF.class}, methodName={"multiply"})
    public void multiply_withScale(Object vectorArg, float scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiply");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                vector.multiply(scale);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

