/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;

class VelocityAccess
extends Access {
    VelocityAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "Velocity");
    }

    private Velocity checkVelocity(Object velocityArg) {
        return this.checkArg(velocityArg, Velocity.class, "velocity");
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, fieldName={"unit"})
    public String getDistanceUnit(Object velocityArg) {
        try {
            DistanceUnit distanceUnit;
            this.startBlockExecution(BlockType.GETTER, ".DistanceUnit");
            Velocity velocity = this.checkVelocity(velocityArg);
            if (velocity != null && (distanceUnit = velocity.unit) != null) {
                String string = distanceUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, fieldName={"xVeloc"})
    public double getXVeloc(Object velocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".XVeloc");
            Velocity velocity = this.checkVelocity(velocityArg);
            if (velocity != null) {
                double d = velocity.xVeloc;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, fieldName={"yVeloc"})
    public double getYVeloc(Object velocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".YVeloc");
            Velocity velocity = this.checkVelocity(velocityArg);
            if (velocity != null) {
                double d = velocity.yVeloc;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, fieldName={"zVeloc"})
    public double getZVeloc(Object velocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZVeloc");
            Velocity velocity = this.checkVelocity(velocityArg);
            if (velocity != null) {
                double d = velocity.zVeloc;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object velocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            Velocity velocity = this.checkVelocity(velocityArg);
            if (velocity != null) {
                long l = velocity.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, constructor=true)
    public Velocity create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Velocity velocity = new Velocity();
            return velocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, constructor=true)
    public Velocity create_withArgs(String distanceUnitString, double xVeloc, double yVeloc, double zVeloc, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (distanceUnit != null) {
                Velocity velocity = new Velocity(distanceUnit, xVeloc, yVeloc, zVeloc, acquisitionTime);
                return velocity;
            }
            Velocity velocity = null;
            return velocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, methodName={"toUnit"})
    public Velocity toDistanceUnit(Object velocityArg, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toDistanceUnit");
            Velocity velocity = this.checkVelocity(velocityArg);
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (velocity != null && distanceUnit != null) {
                Velocity velocity2 = velocity.toUnit(distanceUnit);
                return velocity2;
            }
            Velocity velocity3 = null;
            return velocity3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Velocity.class}, methodName={"toString"})
    public String toText(Object velocityArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            Velocity velocity = this.checkVelocity(velocityArg);
            if (velocity != null) {
                String string = velocity.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

