/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.util.Size;
import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.external.hardware.camera.BuiltinCameraDirection;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.ExposureControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.FocusControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.GainControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.PtzControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.WhiteBalanceControl;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamServer;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamSource;
import org.firstinspires.ftc.robotcore.internal.camera.delegating.SwitchableCameraName;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.vision.VisionPortal;
import org.firstinspires.ftc.vision.VisionProcessor;

class VisionPortalAccess
extends Access {
    private final HardwareMap hardwareMap;

    VisionPortalAccess(BlocksOpMode blocksOpMode, String identifier, HardwareMap hardwareMap) {
        super(blocksOpMode, identifier, "");
        this.hardwareMap = hardwareMap;
    }

    private VisionPortal.Builder checkVisionPortalBuilder(Object visionPortalBuilderArg) {
        return this.checkArg(visionPortalBuilderArg, VisionPortal.Builder.class, "visionPortalBuilder");
    }

    private VisionPortal.StreamFormat checkStreamFormat(String streamFormatString) {
        return this.checkArg(streamFormatString, VisionPortal.StreamFormat.class, "streamFormat");
    }

    private VisionProcessor checkVisionProcessor(Object visionProcessorArg) {
        return this.checkArg(visionProcessorArg, VisionProcessor.class, "visionProcessor");
    }

    private VisionPortal checkVisionPortal(Object visionPortalArg) {
        return this.checkArg(visionPortalArg, VisionPortal.class, "visionPortal");
    }

    private WebcamName checkWebcamName(Object webcamNameArg) {
        return this.checkArg(webcamNameArg, WebcamName.class, "webcamName");
    }

    private VisionPortal.MultiPortalLayout checkMultiPortalLayout(String multiPortalLayoutString) {
        return this.checkArg(multiPortalLayoutString, VisionPortal.MultiPortalLayout.class, "multiPortalLayout");
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, constructor=true)
    public VisionPortal.Builder createBuilder() {
        try {
            this.startBlockExecution(BlockType.CREATE, "VisionPortal.Builder", "");
            VisionPortal.Builder builder = new VisionPortal.Builder();
            return builder;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setCamera"})
    public void setCamera(Object visionPortalBuilderArg, Object camera) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setCamera");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                if (camera instanceof BuiltinCameraDirection) {
                    visionPortalBuilder.setCamera((BuiltinCameraDirection)camera);
                } else if (camera instanceof WebcamName) {
                    visionPortalBuilder.setCamera((CameraName)((WebcamName)camera));
                } else if (camera instanceof SwitchableCameraName) {
                    visionPortalBuilder.setCamera((CameraName)((SwitchableCameraName)camera));
                } else {
                    this.reportInvalidArg("camera", "BuiltinCameraName, WebcamName, or SwitchableCameraName");
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setStreamFormat"})
    public void setStreamFormat(Object visionPortalBuilderArg, String streamFormatString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setStreamFormat");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            VisionPortal.StreamFormat streamFormat = this.checkStreamFormat(streamFormatString);
            if (visionPortalBuilder != null && streamFormat != null) {
                visionPortalBuilder.setStreamFormat(streamFormat);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"enableLiveView"})
    public void enableLiveView(Object visionPortalBuilderArg, boolean enableLiveView) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".enableLiveView");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                visionPortalBuilder.enableLiveView(enableLiveView);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setAutoStopLiveView"})
    public void setAutoStopLiveView(Object visionPortalBuilderArg, boolean autoStopLiveView) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setAutoStopLiveView");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                visionPortalBuilder.setAutoStopLiveView(autoStopLiveView);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setAutoStartStreamOnBuild"})
    public void setAutoStartStreamOnBuild(Object visionPortalBuilderArg, boolean autoStartStreamOnBuild) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setAutoStartStreamOnBuild");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                visionPortalBuilder.setAutoStartStreamOnBuild(autoStartStreamOnBuild);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setShowStatsOverlay"})
    public void setShowStatsOverlay(Object visionPortalBuilderArg, boolean showStatsOverlay) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setShowStatsOverlay");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                visionPortalBuilder.setShowStatsOverlay(showStatsOverlay);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setLiveViewContainerId"})
    public void setLiveViewContainerId(Object visionPortalBuilderArg, int viewId) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setLiveViewContainerId");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                visionPortalBuilder.setLiveViewContainerId(viewId);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"setCameraResolution"})
    public void setCameraResolution(Object visionPortalBuilderArg, int width, int height) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".setCameraResolution");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                visionPortalBuilder.setCameraResolution(new Size(width, height));
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"addProcessor"})
    public void addProcessor(Object visionPortalBuilderArg, Object visionProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".addProcessor");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            VisionProcessor visionProcessor = this.checkVisionProcessor(visionProcessorArg);
            if (visionPortalBuilder != null && visionProcessor != null) {
                visionPortalBuilder.addProcessor(visionProcessor);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.Builder.class}, methodName={"build"})
    public VisionPortal build(Object visionPortalBuilderArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal.Builder", ".build");
            VisionPortal.Builder visionPortalBuilder = this.checkVisionPortalBuilder(visionPortalBuilderArg);
            if (visionPortalBuilder != null) {
                VisionPortal visionPortal = visionPortalBuilder.build();
                return visionPortal;
            }
            VisionPortal visionPortal = null;
            return visionPortal;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"easyCreateWithDefaults"})
    public VisionPortal easyCreateWithDefaults_oneProcessor(Object camera, Object visionProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".easyCreateWithDefaults");
            VisionProcessor visionProcessor = this.checkVisionProcessor(visionProcessorArg);
            if (visionProcessor != null) {
                if (camera instanceof BuiltinCameraDirection) {
                    VisionPortal visionPortal = VisionPortal.easyCreateWithDefaults((BuiltinCameraDirection)((BuiltinCameraDirection)camera), (VisionProcessor[])new VisionProcessor[]{visionProcessor});
                    return visionPortal;
                }
                if (camera instanceof WebcamName) {
                    VisionPortal visionPortal = VisionPortal.easyCreateWithDefaults((CameraName)((WebcamName)camera), (VisionProcessor[])new VisionProcessor[]{visionProcessor});
                    return visionPortal;
                }
                if (camera instanceof SwitchableCameraName) {
                    VisionPortal visionPortal = VisionPortal.easyCreateWithDefaults((CameraName)((SwitchableCameraName)camera), (VisionProcessor[])new VisionProcessor[]{visionProcessor});
                    return visionPortal;
                }
                this.reportInvalidArg("camera", "BuiltinCameraName, WebcamName, or SwitchableCameraName");
            }
            VisionPortal visionPortal = null;
            return visionPortal;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"easyCreateWithDefaults"})
    public VisionPortal easyCreateWithDefaults_twoProcessors(Object camera, Object visionProcessor1Arg, Object visionProcessor2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".easyCreateWithDefaults");
            VisionProcessor visionProcessor1 = this.checkVisionProcessor(visionProcessor1Arg);
            VisionProcessor visionProcessor2 = this.checkVisionProcessor(visionProcessor2Arg);
            if (visionProcessor1 != null && visionProcessor2 != null) {
                if (camera instanceof BuiltinCameraDirection) {
                    VisionPortal visionPortal = VisionPortal.easyCreateWithDefaults((BuiltinCameraDirection)((BuiltinCameraDirection)camera), (VisionProcessor[])new VisionProcessor[]{visionProcessor1, visionProcessor2});
                    return visionPortal;
                }
                if (camera instanceof WebcamName) {
                    VisionPortal visionPortal = VisionPortal.easyCreateWithDefaults((CameraName)((WebcamName)camera), (VisionProcessor[])new VisionProcessor[]{visionProcessor1, visionProcessor2});
                    return visionPortal;
                }
                if (camera instanceof SwitchableCameraName) {
                    VisionPortal visionPortal = VisionPortal.easyCreateWithDefaults((CameraName)((SwitchableCameraName)camera), (VisionProcessor[])new VisionProcessor[]{visionProcessor1, visionProcessor2});
                    return visionPortal;
                }
                this.reportInvalidArg("camera", "BuiltinCameraName, WebcamName, or SwitchableCameraName");
            }
            VisionPortal visionPortal = null;
            return visionPortal;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"setProcessorEnabled"})
    public void setProcessorEnabled(Object visionPortalArg, Object visionProcessorArg, boolean enabled) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".setProcessorEnabled");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            VisionProcessor visionProcessor = this.checkVisionProcessor(visionProcessorArg);
            if (visionPortal != null && visionProcessor != null) {
                visionPortal.setProcessorEnabled(visionProcessor, enabled);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getProcessorEnabled"})
    public boolean getProcessorEnabled(Object visionPortalArg, Object visionProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getProcessorEnabled");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            VisionProcessor visionProcessor = this.checkVisionProcessor(visionProcessorArg);
            if (visionPortal != null && visionProcessor != null) {
                boolean bl = visionPortal.getProcessorEnabled(visionProcessor);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getCameraState"})
    public String getCameraState(Object visionPortalArg) {
        try {
            VisionPortal.CameraState cameraState;
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getCameraState");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null && (cameraState = visionPortal.getCameraState()) != null) {
                String string = cameraState.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"saveNextFrameRaw"})
    public void saveNextFrameRaw(Object visionPortalArg, String filename) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".saveNextFrameRaw");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                visionPortal.saveNextFrameRaw(filename);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"stopStreaming"})
    public void stopStreaming(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".stopStreaming");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                visionPortal.stopStreaming();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"resumeStreaming"})
    public void resumeStreaming(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".resumeStreaming");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                visionPortal.resumeStreaming();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"stopLiveView"})
    public void stopLiveView(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".stopLiveView");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                visionPortal.stopLiveView();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"resumeLiveView"})
    public void resumeLiveView(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".resumeLiveView");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                visionPortal.resumeLiveView();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getFps"})
    public float getFps(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getFps");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                float f = visionPortal.getFps();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getCameraControl"})
    public ExposureControl getExposureControl(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getExposureControl");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                ExposureControl exposureControl = (ExposureControl)visionPortal.getCameraControl(ExposureControl.class);
                return exposureControl;
            }
            ExposureControl exposureControl = null;
            return exposureControl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getCameraControl"})
    public FocusControl getFocusControl(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getFocusControl");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                FocusControl focusControl = (FocusControl)visionPortal.getCameraControl(FocusControl.class);
                return focusControl;
            }
            FocusControl focusControl = null;
            return focusControl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getCameraControl"})
    public GainControl getGainControl(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getGainControl");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                GainControl gainControl = (GainControl)visionPortal.getCameraControl(GainControl.class);
                return gainControl;
            }
            GainControl gainControl = null;
            return gainControl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getCameraControl"})
    public PtzControl getPtzControl(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getPtzControl");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                PtzControl ptzControl = (PtzControl)visionPortal.getCameraControl(PtzControl.class);
                return ptzControl;
            }
            PtzControl ptzControl = null;
            return ptzControl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getCameraControl"})
    public WhiteBalanceControl getWhiteBalanceControl(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getWhiteBalanceControl");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                WhiteBalanceControl whiteBalanceControl = (WhiteBalanceControl)visionPortal.getCameraControl(WhiteBalanceControl.class);
                return whiteBalanceControl;
            }
            WhiteBalanceControl whiteBalanceControl = null;
            return whiteBalanceControl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"setActiveCamera"})
    public void setActiveCamera(Object visionPortalArg, Object webcamNameArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".setActiveCamera");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            WebcamName webcamName = this.checkWebcamName(webcamNameArg);
            if (visionPortal != null) {
                visionPortal.setActiveCamera(webcamName);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"getActiveCamera"})
    public WebcamName getActiveCamera(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".getActiveCamera");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                WebcamName webcamName = visionPortal.getActiveCamera();
                return webcamName;
            }
            WebcamName webcamName = null;
            return webcamName;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public void cameraStreamServer_setSource(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "CameraStreamServer", ".setSource");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                CameraStreamServer.getInstance().setSource((CameraStreamSource)visionPortal);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"close"})
    public void close(Object visionPortalArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".close");
            VisionPortal visionPortal = this.checkVisionPortal(visionPortalArg);
            if (visionPortal != null) {
                visionPortal.close();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={VisionPortal.class}, methodName={"makeMultiPortalView"})
    public String makeMultiPortalView(int numPortals, String multiPortalLayoutString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "VisionPortal", ".makeMultiPortalView");
            VisionPortal.MultiPortalLayout multiPortalLayout = this.checkMultiPortalLayout(multiPortalLayoutString);
            if (multiPortalLayout != null) {
                String string = SimpleGson.getInstance().toJson((Object)VisionPortal.makeMultiPortalView((int)numPortals, (VisionPortal.MultiPortalLayout)multiPortalLayout));
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

