/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;

class YawPitchRollAnglesAccess
extends Access {
    YawPitchRollAnglesAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "YawPitchRollAngles");
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, methodName={"getYaw"})
    public double getYaw(Object yawPitchRollAnglesArg, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getYaw");
            YawPitchRollAngles yawPitchRollAngles = this.checkYawPitchRollAngles(yawPitchRollAnglesArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (yawPitchRollAngles != null && angleUnit != null) {
                double d = yawPitchRollAngles.getYaw(angleUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, methodName={"getPitch"})
    public double getPitch(Object yawPitchRollAnglesArg, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getPitch");
            YawPitchRollAngles yawPitchRollAngles = this.checkYawPitchRollAngles(yawPitchRollAnglesArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (yawPitchRollAngles != null && angleUnit != null) {
                double d = yawPitchRollAngles.getPitch(angleUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, methodName={"getRoll"})
    public double getRoll(Object yawPitchRollAnglesArg, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRoll");
            YawPitchRollAngles yawPitchRollAngles = this.checkYawPitchRollAngles(yawPitchRollAnglesArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (yawPitchRollAngles != null && angleUnit != null) {
                double d = yawPitchRollAngles.getRoll(angleUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, constructor=true)
    public YawPitchRollAngles create_withArgs(String angleUnitString, double yaw, double pitch, double roll, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                YawPitchRollAngles yawPitchRollAngles = new YawPitchRollAngles(angleUnit, yaw, pitch, roll, acquisitionTime);
                return yawPitchRollAngles;
            }
            YawPitchRollAngles yawPitchRollAngles = null;
            return yawPitchRollAngles;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, constructor=true)
    public YawPitchRollAngles create_withArgs2(String angleUnitString, double yaw, double pitch, double roll) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                YawPitchRollAngles yawPitchRollAngles = new YawPitchRollAngles(angleUnit, yaw, pitch, roll, 0L);
                return yawPitchRollAngles;
            }
            YawPitchRollAngles yawPitchRollAngles = null;
            return yawPitchRollAngles;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, methodName={"getAcquisitionTime"})
    public long getAcquisitionTime(Object yawPitchRollAnglesArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            YawPitchRollAngles yawPitchRollAngles = this.checkYawPitchRollAngles(yawPitchRollAnglesArg);
            if (yawPitchRollAngles != null) {
                long l = yawPitchRollAngles.getAcquisitionTime();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={YawPitchRollAngles.class}, methodName={"toString"})
    public String toText(Object yawPitchRollAnglesArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            YawPitchRollAngles yawPitchRollAngles = this.checkYawPitchRollAngles(yawPitchRollAnglesArg);
            if (yawPitchRollAngles != null) {
                String string = yawPitchRollAngles.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

