/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.util;

import android.os.Looper;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.firstinspires.ftc.robotcore.external.android.AndroidTextToSpeech;

public class AvailableTtsLocalesProvider {
    private static final AvailableTtsLocalesProvider instance = new AvailableTtsLocalesProvider();
    private static final String TAG = "AvailableTtsLocalesProvider";
    private Set<Locale> availableTtsLocales = null;

    public static AvailableTtsLocalesProvider getInstance() {
        return instance;
    }

    public synchronized Set<Locale> getAvailableTtsLocales() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            String errorMessage = "AvailableTtsLocalesProvider used from Android Main Thread. This is not allowed.";
            RobotLog.ee((String)TAG, (String)errorMessage);
            throw new RuntimeException(errorMessage);
        }
        if (this.availableTtsLocales == null) {
            this.availableTtsLocales = new HashSet<Locale>();
            AndroidTextToSpeech textToSpeech = new AndroidTextToSpeech();
            textToSpeech.initialize();
            for (Locale locale : Locale.getAvailableLocales()) {
                if (!textToSpeech.isLocaleAvailable(locale)) continue;
                this.availableTtsLocales.add(locale);
            }
            textToSpeech.close();
        }
        return this.availableTtsLocales;
    }
}

