/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.util;

import com.google.blocks.ftcrobotcontroller.util.BlocksProject;
import com.google.blocks.ftcrobotcontroller.util.ProjectsUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BlocksArchive {
    public static InputStream fetchBlocksArchive() throws IOException {
        ArrayList<BlocksProject> projects = new ArrayList<BlocksProject>();
        ProjectsUtil.fetchProjects(projects);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            for (BlocksProject project : projects) {
                ZipEntry zipEntry = new ZipEntry(project.fileName);
                zipEntry.setTime(project.dateModifiedMillis);
                zos.putNextEntry(zipEntry);
                zos.write(project.content.getBytes());
                zos.closeEntry();
            }
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

