/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.util;

import android.text.Html;
import android.util.Base64;
import com.google.blocks.ftcrobotcontroller.util.FileUtil;
import com.google.blocks.ftcrobotcontroller.util.ProjectsUtil;
import java.io.File;
import java.io.IOException;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public enum FileManager {
    SOUNDS(AppUtil.BLOCKS_SOUNDS_DIR);

    private final String VALID_NAME_REGEX = "^[a-zA-Z0-9 \\!\\#\\$\\%\\&\\'\\(\\)\\+\\,\\-\\.\\;\\=\\@\\[\\]\\^_\\{\\}\\~]+$";
    private final File dir;

    private FileManager(File dir) {
        this.dir = dir;
    }

    public String fetchJavaScript() throws IOException {
        return "\n" + "function isValidName(name) {\n" + "  if (name) {\n" + "    return /" + "^[a-zA-Z0-9 \\!\\#\\$\\%\\&\\'\\(\\)\\+\\,\\-\\.\\;\\=\\@\\[\\]\\^_\\{\\}\\~]+$" + "/.test(name);\n" + "  }\n" + "  return false;\n" + "}\n\n";
    }

    public String fetchFiles() throws IOException {
        File[] files = this.dir.listFiles();
        if (files != null) {
            StringBuilder json = new StringBuilder();
            json.append("[");
            String delimiter = "";
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                json.append(delimiter).append("{").append("\"name\":\"").append(ProjectsUtil.escapeDoubleQuotes(name)).append("\", ").append("\"escapedName\":\"").append(ProjectsUtil.escapeDoubleQuotes(Html.escapeHtml((CharSequence)name))).append("\", ").append("\"dateModifiedMillis\":").append(files[i].lastModified()).append("}");
                delimiter = ",";
            }
            json.append("]");
            return json.toString();
        }
        return "[]";
    }

    public boolean isValidName(String name) {
        if (name != null) {
            return name.matches("^[a-zA-Z0-9 \\!\\#\\$\\%\\&\\'\\(\\)\\+\\,\\-\\.\\;\\=\\@\\[\\]\\^_\\{\\}\\~]+$");
        }
        return false;
    }

    public String fetchFileContent(String name) throws IOException {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException();
        }
        byte[] content = FileUtil.readBinaryFile(new File(this.dir, name));
        return Base64.encodeToString((byte[])content, (int)0);
    }

    public void saveFile(String name, String base64Content) throws IOException {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException();
        }
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        byte[] content = Base64.decode((String)base64Content, (int)0);
        File file = new File(this.dir, name);
        File tempBackupFile = null;
        if (file.exists()) {
            long timestamp = System.currentTimeMillis();
            tempBackupFile = new File(this.dir, "backup_" + timestamp + "_" + name);
            FileUtil.copyFile(file, tempBackupFile);
        }
        FileUtil.writeBinaryFile(file, content);
        if (tempBackupFile != null) {
            tempBackupFile.delete();
        }
    }

    public void renameFile(String oldName, String newName) throws IOException {
        if (!this.isValidName(oldName) || !this.isValidName(newName)) {
            throw new IllegalArgumentException();
        }
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        File oldFile = new File(this.dir, oldName);
        File newFile = new File(this.dir, newName);
        oldFile.renameTo(newFile);
    }

    public void copyFile(String oldName, String newName) throws IOException {
        if (!this.isValidName(oldName) || !this.isValidName(newName)) {
            throw new IllegalArgumentException();
        }
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        File oldFile = new File(this.dir, oldName);
        File newFile = new File(this.dir, newName);
        FileUtil.copyFile(oldFile, newFile);
    }

    public boolean deleteFiles(String[] names) {
        for (String name : names) {
            if (this.isValidName(name)) continue;
            throw new IllegalArgumentException();
        }
        boolean success = true;
        for (String name : names) {
            File file = new File(this.dir, name);
            if (!file.exists() || file.delete()) continue;
            success = false;
        }
        return success;
    }

    public String getPathForFile(String name) {
        return new File(this.dir, name).getAbsolutePath();
    }
}

