/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.util;

import android.content.res.AssetManager;
import android.text.Html;
import android.util.Xml;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.blocks.ftcrobotcontroller.IOExceptionWithUserVisibleMessage;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItemMap;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareType;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareUtil;
import com.google.blocks.ftcrobotcontroller.util.BlocksProject;
import com.google.blocks.ftcrobotcontroller.util.CorruptFileException;
import com.google.blocks.ftcrobotcontroller.util.FileUtil;
import com.google.blocks.ftcrobotcontroller.util.OfflineBlocksProject;
import com.google.blocks.ftcrobotcontroller.util.ProjectsLockManager;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firstinspires.ftc.robotcore.external.Supplier;
import org.firstinspires.ftc.robotcore.external.ThrowingCallable;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaHelper;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeMeta;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ProjectsUtil {
    public static final String TAG = "ProjectsUtil";
    public static final String VALID_PROJECT_REGEX = "^[a-zA-Z0-9 \\!\\#\\$\\%\\&\\'\\(\\)\\+\\,\\-\\.\\;\\=\\@\\[\\]\\^_\\{\\}\\~]+$";
    private static final String XML_END_TAG = "</xml>";
    private static final String XML_TAG_EXTRA = "Extra";
    private static final String XML_TAG_OP_MODE_META = "OpModeMeta";
    private static final String XML_ATTRIBUTE_FLAVOR = "flavor";
    private static final String XML_ATTRIBUTE_GROUP = "group";
    private static final String XML_ATTRIBUTE_AUTO_TRANSITION = "autoTransition";
    private static final String XML_TAG_ENABLED = "Enabled";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final String BLOCKS_SAMPLES_PATH = "blocks/samples";
    private static final String DEFAULT_BLOCKS_SAMPLE_NAME = "default";
    private static final OpModeMeta.Flavor DEFAULT_FLAVOR = OpModeMeta.Flavor.TELEOP;
    private static final Pattern identifierFieldPattern = Pattern.compile("<field name=\"(IDENTIFIER|IDENTIFIER1|IDENTIFIER2|WEBCAM_NAME)\">(.*)</field>");
    private static final Pattern deviceNameWithSuffix = Pattern.compile("(.*)(As.*)");
    private static final String[] specialDeviceNames = new String[]{"left", "right"};

    private ProjectsUtil() {
    }

    public static String fetchProjectsWithBlocks() {
        AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
        ReadWriteFile.ensureAllChangesAreCommitted((File)AppUtil.BLOCK_OPMODES_DIR);
        return ProjectsLockManager.lockProjectsWhile(new Supplier<String>(){

            public String get() {
                File[] files = AppUtil.BLOCK_OPMODES_DIR.listFiles(new BlocksProjectFilenameFilter());
                if (files != null) {
                    StringBuilder jsonProjects = new StringBuilder();
                    jsonProjects.append("[");
                    String delimiter = "";
                    for (File file : files) {
                        String filename = file.getName();
                        String projectName = filename.substring(0, filename.length() - ".blk".length());
                        try {
                            boolean enabled = ProjectsUtil.isProjectEnabled(projectName);
                            jsonProjects.append(delimiter).append("{").append("\"name\":\"").append(ProjectsUtil.escapeDoubleQuotes(projectName)).append("\", ").append("\"escapedName\":\"").append(ProjectsUtil.escapeDoubleQuotes(Html.escapeHtml((CharSequence)projectName))).append("\", ").append("\"dateModifiedMillis\":").append(file.lastModified()).append(", ").append("\"enabled\":").append(enabled).append("}");
                            delimiter = ",";
                        }
                        catch (IOException e) {
                            RobotLog.e((String)("ProjectsUtil.fetchProjectsWithBlocks() - problem with project " + projectName));
                            RobotLog.logStackTrace((Throwable)e);
                        }
                    }
                    jsonProjects.append("]");
                    return jsonProjects.toString();
                }
                return "[]";
            }
        });
    }

    public static String escapeSingleQuotes(String s) {
        return s.replace("'", "\\'");
    }

    public static String escapeDoubleQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    public static void fetchProjectsForOfflineBlocksEditor(final List<OfflineBlocksProject> offlineBlocksProjects) throws IOException {
        AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
        ReadWriteFile.ensureAllChangesAreCommitted((File)AppUtil.BLOCK_OPMODES_DIR);
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                File[] files = AppUtil.BLOCK_OPMODES_DIR.listFiles(new BlocksProjectFilenameFilter());
                if (files != null) {
                    for (File file : files) {
                        String filename = file.getName();
                        String projectName = filename.substring(0, filename.length() - ".blk".length());
                        String blkFileContent = ProjectsUtil.fetchBlkFileContent(projectName);
                        int iXmlEndTag = blkFileContent.indexOf(ProjectsUtil.XML_END_TAG);
                        if (iXmlEndTag == -1) continue;
                        String extraXml = blkFileContent.substring(iXmlEndTag + ProjectsUtil.XML_END_TAG.length());
                        offlineBlocksProjects.add(new OfflineBlocksProject(filename, blkFileContent, projectName, file.lastModified(), ProjectsUtil.isProjectEnabled(projectName, extraXml)));
                    }
                }
                return null;
            }
        });
    }

    public static void fetchProjects(final List<BlocksProject> blocksProjects) throws IOException {
        AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
        ReadWriteFile.ensureAllChangesAreCommitted((File)AppUtil.BLOCK_OPMODES_DIR);
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                File[] files = AppUtil.BLOCK_OPMODES_DIR.listFiles(new BlocksProjectFilenameFilter());
                if (files != null) {
                    for (File file : files) {
                        String filename = file.getName();
                        String projectName = filename.substring(0, filename.length() - ".blk".length());
                        String blkFileContent = ProjectsUtil.fetchBlkFileContent(projectName);
                        blocksProjects.add(new BlocksProject(filename, blkFileContent, file.lastModified()));
                    }
                }
                return null;
            }
        });
    }

    public static String fetchSampleNames() throws IOException {
        HardwareItemMap hardwareItemMap = HardwareItemMap.newHardwareItemMap();
        StringBuilder jsonSamples = new StringBuilder();
        jsonSamples.append("[");
        AssetManager assetManager = AppUtil.getDefContext().getAssets();
        List<String> sampleFileNames = Arrays.asList(assetManager.list(BLOCKS_SAMPLES_PATH));
        Collections.sort(sampleFileNames);
        if (sampleFileNames != null) {
            String delimiter = "";
            for (String filename : sampleFileNames) {
                String sampleName;
                if (!filename.endsWith(".blk") || (sampleName = filename.substring(0, filename.length() - ".blk".length())).equals(DEFAULT_BLOCKS_SAMPLE_NAME)) continue;
                String blkFileContent = ProjectsUtil.readSample(sampleName);
                Set<HardwareUtil.Capability> requestedCapabilities = ProjectsUtil.getRequestedCapabilities(sampleName, blkFileContent);
                jsonSamples.append(delimiter).append("{").append("\"name\":\"").append(ProjectsUtil.escapeDoubleQuotes(sampleName)).append("\", ").append("\"escapedName\":\"").append(ProjectsUtil.escapeDoubleQuotes(Html.escapeHtml((CharSequence)sampleName))).append("\", ").append("\"requestedCapabilities\":[");
                String delimiter2 = "";
                for (HardwareUtil.Capability requestedCapability : requestedCapabilities) {
                    jsonSamples.append(delimiter2).append("\"").append((Object)requestedCapability).append("\"");
                    delimiter2 = ",";
                }
                jsonSamples.append("]").append("}");
                delimiter = ",";
            }
        }
        jsonSamples.append("]");
        return jsonSamples.toString();
    }

    static Map<String, String> getSamples(HardwareItemMap hardwareItemMap) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        AssetManager assetManager = AppUtil.getDefContext().getAssets();
        List<String> sampleFileNames = Arrays.asList(assetManager.list(BLOCKS_SAMPLES_PATH));
        for (String filename : sampleFileNames) {
            if (!filename.endsWith(".blk")) continue;
            String sampleName = filename.substring(0, filename.length() - ".blk".length());
            String blkFileContent = ProjectsUtil.readSampleAndReplaceDeviceNames(sampleName, hardwareItemMap);
            if (sampleName.equals(DEFAULT_BLOCKS_SAMPLE_NAME)) {
                sampleName = "";
            }
            map.put(sampleName, blkFileContent);
        }
        return map;
    }

    private static Set<HardwareUtil.Capability> getRequestedCapabilities(String sampleName, String blkFileContent) {
        LinkedHashSet<HardwareUtil.Capability> requestedCapabilities = new LinkedHashSet<HardwareUtil.Capability>();
        if (blkFileContent.contains("navigation_switchableCamera_forAllWebcams")) {
            requestedCapabilities.add(HardwareUtil.Capability.SWITCHABLE_CAMERA);
        }
        if (blkFileContent.contains("navigation_typedEnum_builtinCameraDirection") || blkFileContent.contains("navigation_webcamName")) {
            requestedCapabilities.add(HardwareUtil.Capability.VISION);
        }
        return requestedCapabilities;
    }

    public static List<OpModeMeta> fetchEnabledProjectsWithJavaScript() {
        return ProjectsLockManager.lockProjectsWhile(new Supplier<List<OpModeMeta>>(){

            public List<OpModeMeta> get() {
                String[] filenames = AppUtil.BLOCK_OPMODES_DIR.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String filename) {
                        if (filename.endsWith(".js")) {
                            String projectName = filename.substring(0, filename.length() - ".js".length());
                            return ProjectsUtil.isValidProjectName(projectName);
                        }
                        return false;
                    }
                });
                ArrayList<OpModeMeta> projects = new ArrayList<OpModeMeta>();
                if (filenames != null) {
                    for (String filename : filenames) {
                        String projectName = filename.substring(0, filename.length() - ".js".length());
                        OpModeMeta opModeMeta = ProjectsUtil.fetchOpModeMeta(projectName);
                        if (opModeMeta == null) continue;
                        projects.add(opModeMeta);
                    }
                }
                return projects;
            }
        });
    }

    @Nullable
    private static OpModeMeta fetchOpModeMeta(String projectName) {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        try {
            ProjectsUtil.ensureChangesAreCommitted(projectName);
            File blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk");
            String blkFileContent = FileUtil.readFile(blkFile);
            int iXmlEndTag = blkFileContent.indexOf(XML_END_TAG);
            if (iXmlEndTag == -1) {
                throw new CorruptFileException("File " + blkFile.getName() + " is empty or corrupt.");
            }
            String extraXml = blkFileContent.substring(iXmlEndTag + XML_END_TAG.length());
            if (!ProjectsUtil.isProjectEnabled(projectName, extraXml)) {
                return null;
            }
            return ProjectsUtil.createOpModeMeta(projectName, extraXml);
        }
        catch (IOException e) {
            if (!projectName.startsWith("backup_")) {
                RobotLog.e((String)("ProjectsUtil.fetchOpModeMeta(\"" + projectName + "\") - failed."));
                RobotLog.logStackTrace((Throwable)e);
            }
            return null;
        }
    }

    public static boolean isValidProjectName(String projectName) {
        if (projectName != null) {
            return projectName.matches(VALID_PROJECT_REGEX);
        }
        return false;
    }

    public static String fetchBlkFileContent(String projectName) throws IOException {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsUtil.ensureChangesAreCommitted(projectName);
        File blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk");
        String blkFileContent = FileUtil.readFile(blkFile);
        int iXmlEndTag = blkFileContent.indexOf(XML_END_TAG);
        if (iXmlEndTag == -1) {
            throw new CorruptFileException("File " + blkFile.getName() + " is empty or corrupt.");
        }
        String blocksContent = blkFileContent.substring(0, iXmlEndTag + XML_END_TAG.length());
        String extraXml = blkFileContent.substring(iXmlEndTag + XML_END_TAG.length());
        String upgradedBlocksContent = ProjectsUtil.upgradeBlocks(blocksContent, HardwareItemMap.newHardwareItemMap());
        if (!upgradedBlocksContent.equals(blocksContent)) {
            blkFileContent = upgradedBlocksContent + extraXml;
        }
        return blkFileContent;
    }

    private static String upgradeBlocks(String blkContent, HardwareItemMap hardwareItemMap) {
        HardwareType[] typesThatDidntHaveSuffix;
        blkContent = blkContent.replace("<block type=\"colorBlobLocatorProcessor_clearFilters", "<block type=\"colorBlobLocatorProcessor_removeAllFilters");
        blkContent = blkContent.replace("<block type=\"linearOpMode_resetStartTime", "<block type=\"linearOpMode_resetRuntime");
        blkContent = blkContent.replace("<block type=\"tfodCurrentGame_", "<block type=\"tfod_");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_activate", "<block type=\"tfod_activate");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_deactivate", "<block type=\"tfod_deactivate");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_setClippingMargins", "<block type=\"tfod_setClippingMargins");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_setZoom", "<block type=\"tfod_setZoom");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_getRecognitions", "<block type=\"tfod_getRecognitions");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_setModelFromAsset", "<block type=\"tfodLegacy_setModelFromAsset");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_setModelFromFile", "<block type=\"tfodLegacy_setModelFromFile");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_initialize_withIsModelTensorFlow2", "<block type=\"tfodLegacy_initialize_withIsModelTensorFlow2");
        blkContent = blkContent.replace("<block type=\"tfodCustomModel_initialize_withAllArgs", "<block type=\"tfodLegacy_initialize_withAllArgs");
        blkContent = blkContent.replace("<block type=\"adafruitBNO055IMU_", "<block type=\"bno055imu_");
        blkContent = ProjectsUtil.replaceIdentifierSuffixInBlocks(blkContent, hardwareItemMap.getHardwareItems(HardwareType.BNO055IMU), "AsAdafruitBNO055IMU", "AsBNO055IMU");
        blkContent = blkContent.replace("<block type=\"adafruitBNO055IMUParameters_", "<block type=\"bno055imuParameters_");
        blkContent = blkContent.replace("<shadow type=\"adafruitBNO055IMUParameters_", "<shadow type=\"bno055imuParameters_");
        blkContent = blkContent.replace("<value name=\"ADAFRUIT_BNO055IMU_PARAMETERS\">", "<value name=\"BNO055IMU_PARAMETERS\">");
        blkContent = ProjectsUtil.replaceIdentifierSuffixInBlocks(blkContent, hardwareItemMap.getHardwareItems(HardwareType.LYNX_MODULE), "asLynxModule", "AsREVModule");
        blkContent = ProjectsUtil.replaceIdentifierSuffixInBlocks(blkContent, hardwareItemMap.getHardwareItems(HardwareType.COLOR_RANGE_SENSOR), "asLynxI2cColorRangeSensor", "AsREVColorRangeSensor");
        for (HardwareType hardwareType : typesThatDidntHaveSuffix = new HardwareType[]{HardwareType.ACCELERATION_SENSOR, HardwareType.COLOR_SENSOR, HardwareType.COMPASS_SENSOR, HardwareType.CR_SERVO, HardwareType.DC_MOTOR, HardwareType.DISTANCE_SENSOR, HardwareType.GYRO_SENSOR, HardwareType.IR_SEEKER_SENSOR, HardwareType.LED, HardwareType.LIGHT_SENSOR, HardwareType.SERVO, HardwareType.TOUCH_SENSOR, HardwareType.ULTRASONIC_SENSOR}) {
            blkContent = ProjectsUtil.replaceIdentifierSuffixInBlocks(blkContent, hardwareItemMap.getHardwareItems(hardwareType), "", hardwareType.identifierSuffixForJavaScript);
        }
        return blkContent;
    }

    private static String replaceIdentifierSuffixInBlocks(String blkContent, List<HardwareItem> hardwareItemList, String oldIdentifierSuffix, String newIdentifierSuffix) {
        if (hardwareItemList != null) {
            for (HardwareItem hardwareItem : hardwareItemList) {
                String[] identifierFieldNames;
                String newIdentifier = hardwareItem.identifier;
                if (!newIdentifier.endsWith(newIdentifierSuffix)) continue;
                String oldIdentifier = newIdentifier.substring(0, newIdentifier.length() - newIdentifierSuffix.length()) + oldIdentifierSuffix;
                for (String identifierFieldName : identifierFieldNames = new String[]{"IDENTIFIER", "IDENTIFIER1", "IDENTIFIER2"}) {
                    String oldElement = "<field name=\"" + identifierFieldName + "\">" + oldIdentifier + "</field>";
                    String newElement = "<field name=\"" + identifierFieldName + "\">" + newIdentifier + "</field>";
                    blkContent = blkContent.replace(oldElement, newElement);
                }
            }
        }
        return blkContent;
    }

    public static String fetchJsFileContent(String projectName) throws IOException {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsUtil.ensureChangesAreCommitted(projectName);
        File jsFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".js");
        return FileUtil.readFile(jsFile);
    }

    private static void ensureChangesAreCommitted(String projectName) {
        File blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk");
        File jsFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".js");
        ReadWriteFile.ensureChangesAreCommitted((File)blkFile);
        ReadWriteFile.ensureChangesAreCommitted((File)jsFile);
    }

    public static String newProject(String projectName, String sampleName) throws IOException {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        return ProjectsUtil.readSampleAndReplaceDeviceNames(sampleName, HardwareItemMap.newHardwareItemMap());
    }

    private static String readSampleAndReplaceDeviceNames(String sampleName, HardwareItemMap hardwareItemMap) throws IOException {
        return ProjectsUtil.replaceDeviceNamesInSample(ProjectsUtil.readSample(sampleName), hardwareItemMap);
    }

    private static String readSample(String sampleName) throws IOException {
        if (sampleName == null || sampleName.isEmpty()) {
            sampleName = DEFAULT_BLOCKS_SAMPLE_NAME;
        }
        StringBuilder blkFileContent = new StringBuilder();
        AssetManager assetManager = AppUtil.getDefContext().getAssets();
        String assetName = "blocks/samples/" + sampleName + ".blk";
        FileUtil.readAsset(blkFileContent, assetManager, assetName);
        return blkFileContent.toString();
    }

    private static String replaceDeviceNamesInSample(String blkContent, HardwareItemMap hardwareItemMap) throws IOException {
        Map<HardwareType, Set<String>> sampleDeviceNamesMap = ProjectsUtil.getSampleDeviceNamesMap(blkContent);
        for (Map.Entry<HardwareType, Set<String>> entry : sampleDeviceNamesMap.entrySet()) {
            List<HardwareItem> items;
            HardwareType hardwareType = entry.getKey();
            Set<String> sampleDeviceNames = entry.getValue();
            if (sampleDeviceNames.isEmpty() || !hardwareItemMap.contains(hardwareType) || (items = hardwareItemMap.getHardwareItems(hardwareType)).isEmpty()) continue;
            ArrayList<String> actualDeviceNames = new ArrayList<String>();
            for (HardwareItem item : items) {
                actualDeviceNames.add(item.deviceName);
            }
            Map<String, String> replacements = ProjectsUtil.figureOutReplacements(sampleDeviceNames, actualDeviceNames);
            for (Map.Entry<String, String> replacementEntry : replacements.entrySet()) {
                String from = replacementEntry.getKey();
                String to = replacementEntry.getValue();
                blkContent = ProjectsUtil.replaceDeviceNameInBlocks(hardwareType, blkContent, from, to);
            }
        }
        return blkContent;
    }

    private static Map<HardwareType, Set<String>> getSampleDeviceNamesMap(String blkFileContent) {
        Map<String, Set<String>> mapBySuffix = ProjectsUtil.getSampleDeviceNamesMappedBySuffix(blkFileContent);
        HashMap<HardwareType, Set<String>> sampleDeviceNamesMap = new HashMap<HardwareType, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : mapBySuffix.entrySet()) {
            HardwareType hardwareType;
            String suffix = entry.getKey();
            HardwareType hardwareType2 = hardwareType = suffix == "WEBCAM_NAME" ? HardwareType.WEBCAM_NAME : HardwareType.fromIdentifierSuffixForJavaScript(suffix);
            if (hardwareType == null) continue;
            sampleDeviceNamesMap.put(hardwareType, entry.getValue());
        }
        return sampleDeviceNamesMap;
    }

    @VisibleForTesting(otherwise=2)
    static Map<String, Set<String>> getSampleDeviceNamesMappedBySuffix(String blkFileContent) {
        HashMap<String, Set<String>> mapBySuffix = new HashMap<String, Set<String>>();
        for (String line : blkFileContent.split("\n")) {
            String suffix;
            String deviceName;
            Matcher matcher1 = identifierFieldPattern.matcher(line);
            if (!matcher1.find()) continue;
            String fieldName = matcher1.group(1);
            String fieldValue = matcher1.group(2);
            if (fieldValue.equals("gamepad1") || fieldValue.equals("gamepad2")) continue;
            if (fieldName.equals("WEBCAM_NAME")) {
                deviceName = fieldValue;
                suffix = "WEBCAM_NAME";
            } else {
                Matcher matcher2 = deviceNameWithSuffix.matcher(fieldValue);
                if (!matcher2.find()) continue;
                deviceName = matcher2.group(1);
                suffix = matcher2.group(2);
            }
            HashSet<String> deviceNames = (HashSet<String>)mapBySuffix.get(suffix);
            if (deviceNames == null) {
                deviceNames = new HashSet<String>();
                mapBySuffix.put(suffix, deviceNames);
            }
            deviceNames.add(deviceName);
        }
        return mapBySuffix;
    }

    @VisibleForTesting(otherwise=2)
    static Map<String, String> figureOutReplacements(Collection<String> sampleDeviceNamesArg, Collection<String> actualDeviceNamesArg) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        ArrayList<String> sampleDeviceNames = new ArrayList<String>(sampleDeviceNamesArg);
        ArrayList<String> actualDeviceNames = new ArrayList<String>(actualDeviceNamesArg);
        Collections.sort(sampleDeviceNames);
        Collections.sort(actualDeviceNames);
        String[] itSample = sampleDeviceNames.iterator();
        block0: while (itSample.hasNext()) {
            String sampleDeviceName = (String)itSample.next();
            Iterator itActual = actualDeviceNames.iterator();
            while (itActual.hasNext()) {
                String actualDeviceName = (String)itActual.next();
                if (!sampleDeviceName.equalsIgnoreCase(actualDeviceName)) continue;
                itSample.remove();
                itActual.remove();
                if (sampleDeviceName.equals(actualDeviceName)) continue block0;
                replacements.put(sampleDeviceName, actualDeviceName);
                continue block0;
            }
        }
        block2: for (String specialDeviceName : specialDeviceNames) {
            Iterator itSample2 = sampleDeviceNames.iterator();
            while (itSample2.hasNext()) {
                String sampleDeviceName = (String)itSample2.next();
                if (!sampleDeviceName.toLowerCase(Locale.ENGLISH).contains(specialDeviceName)) continue;
                Iterator itActual = actualDeviceNames.iterator();
                while (itActual.hasNext()) {
                    String actualDeviceName = (String)itActual.next();
                    if (!actualDeviceName.toLowerCase(Locale.ENGLISH).contains(specialDeviceName)) continue;
                    itSample2.remove();
                    itActual.remove();
                    replacements.put(sampleDeviceName, actualDeviceName);
                    continue block2;
                }
                break block3;
            }
        }
        while (!sampleDeviceNames.isEmpty() && !actualDeviceNames.isEmpty()) {
            String sampleDeviceName = (String)sampleDeviceNames.remove(0);
            String actualDeviceName = (String)actualDeviceNames.remove(0);
            replacements.put(sampleDeviceName, actualDeviceName);
        }
        return replacements;
    }

    private static String replaceDeviceNameInBlocks(HardwareType hardwareType, String blkContent, String sampleDeviceName, String actualDeviceName) {
        String[] fieldNames;
        String newIdentifier;
        String oldIdentifier;
        if (hardwareType == HardwareType.WEBCAM_NAME) {
            oldIdentifier = sampleDeviceName;
            newIdentifier = actualDeviceName;
            fieldNames = new String[]{"WEBCAM_NAME"};
        } else {
            oldIdentifier = hardwareType.makeIdentifier(sampleDeviceName);
            newIdentifier = hardwareType.makeIdentifier(actualDeviceName);
            fieldNames = hardwareType == HardwareType.DC_MOTOR ? new String[]{"IDENTIFIER", "IDENTIFIER1", "IDENTIFIER2"} : new String[]{"IDENTIFIER"};
        }
        for (String fieldName : fieldNames) {
            String oldElement = "<field name=\"" + fieldName + "\">" + oldIdentifier + "</field>";
            String newElement = "<field name=\"" + fieldName + "\">" + newIdentifier + "</field>";
            blkContent = blkContent.replace(oldElement, newElement);
            oldElement = "\"" + fieldName + "\":\"" + sampleDeviceName + "\"";
            newElement = "\"" + fieldName + "\":\"" + actualDeviceName + "\"";
            blkContent = blkContent.replace(oldElement, newElement);
        }
        return blkContent;
    }

    public static void saveProject(final String projectName, final String blkFileContent, final String jsFileContent) throws IOException {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
                File blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk");
                File jsFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".js");
                ReadWriteFile.updateFileRequiringCommit((File)blkFile, (String)blkFileContent);
                ReadWriteFile.updateFileRequiringCommit((File)jsFile, (String)jsFileContent);
                return null;
            }
        });
    }

    public static void renameProject(final String oldProjectName, final String newProjectName) throws IOException {
        if (!ProjectsUtil.isValidProjectName(oldProjectName) || !ProjectsUtil.isValidProjectName(newProjectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
                File oldBlk = new File(AppUtil.BLOCK_OPMODES_DIR, oldProjectName + ".blk");
                File newBlk = new File(AppUtil.BLOCK_OPMODES_DIR, newProjectName + ".blk");
                if (oldBlk.renameTo(newBlk)) {
                    File oldJs = new File(AppUtil.BLOCK_OPMODES_DIR, oldProjectName + ".js");
                    File newJs = new File(AppUtil.BLOCK_OPMODES_DIR, newProjectName + ".js");
                    oldJs.renameTo(newJs);
                }
                return null;
            }
        });
    }

    public static void copyProject(final String oldProjectName, final String newProjectName) throws IOException {
        if (!ProjectsUtil.isValidProjectName(oldProjectName) || !ProjectsUtil.isValidProjectName(newProjectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
                File oldBlk = new File(AppUtil.BLOCK_OPMODES_DIR, oldProjectName + ".blk");
                File newBlk = new File(AppUtil.BLOCK_OPMODES_DIR, newProjectName + ".blk");
                FileUtil.copyFile(oldBlk, newBlk);
                try {
                    File oldJs = new File(AppUtil.BLOCK_OPMODES_DIR, oldProjectName + ".js");
                    File newJs = new File(AppUtil.BLOCK_OPMODES_DIR, newProjectName + ".js");
                    FileUtil.copyFile(oldJs, newJs);
                }
                catch (IOException e) {
                    throw new IOExceptionWithUserVisibleMessage("The Blocks OpMode was successfully copied, but the new OpMode cannot be run until it is saved in the Blocks editor.");
                }
                return null;
            }
        });
    }

    public static void enableProject(final String projectName, final boolean enable) throws IOException {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsUtil.ensureChangesAreCommitted(projectName);
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                File blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk");
                String blkFileContent = FileUtil.readFile(blkFile);
                int iXmlEndTag = blkFileContent.indexOf(ProjectsUtil.XML_END_TAG);
                if (iXmlEndTag == -1) {
                    throw new CorruptFileException("File " + blkFile.getName() + " is empty or corrupt.");
                }
                String blocksContent = blkFileContent.substring(0, iXmlEndTag + ProjectsUtil.XML_END_TAG.length());
                String extraXml = blkFileContent.substring(iXmlEndTag + ProjectsUtil.XML_END_TAG.length());
                OpModeMeta opModeMeta = ProjectsUtil.createOpModeMeta(projectName, extraXml);
                String newBlkFileContent = blocksContent + ProjectsUtil.formatExtraXml(opModeMeta.flavor, opModeMeta.group, opModeMeta.autoTransition, enable);
                ReadWriteFile.updateFileRequiringCommit((File)blkFile, (String)newBlkFileContent);
                return null;
            }
        });
    }

    public static Boolean deleteProjects(final String[] projectNames) {
        return ProjectsLockManager.lockProjectsWhile(new Supplier<Boolean>(){

            public Boolean get() {
                for (String projectName : projectNames) {
                    if (ProjectsUtil.isValidProjectName(projectName)) continue;
                    throw new IllegalArgumentException();
                }
                boolean success = true;
                for (String projectName : projectNames) {
                    File blkFile;
                    File jsFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".js");
                    if (jsFile.exists() && !jsFile.delete()) {
                        success = false;
                    }
                    if (!success || !(blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk")).exists() || blkFile.delete()) continue;
                    success = false;
                }
                return success;
            }
        });
    }

    public static String getBlocksJavaClassName(String projectName) {
        StringBuilder className = new StringBuilder();
        char ch = projectName.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            className.append(ch);
        } else if (Character.isJavaIdentifierPart(ch)) {
            className.append('_').append(ch);
        }
        int length = projectName.length();
        for (int i = 1; i < length; ++i) {
            ch = projectName.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            className.append(ch);
        }
        File dir = new File(OnBotJavaHelper.srcDir, "org/firstinspires/ftc/teamcode");
        String base = className.toString();
        File file = new File(dir, base + ".java");
        if (file.exists()) {
            int i = 1;
            while ((file = new File(dir, base + ++i + ".java")).exists()) {
            }
            className.append(i);
        }
        return className.toString();
    }

    public static void saveBlocksJava(final String relativeFileName, final String javaContent) throws IOException {
        ProjectsLockManager.lockProjectsWhile(new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                AppUtil.getInstance().ensureDirectoryExists(AppUtil.BLOCK_OPMODES_DIR, false);
                int lastSlash = relativeFileName.lastIndexOf("/");
                String relativeDir = relativeFileName.substring(0, lastSlash + 1);
                String filename = relativeFileName.substring(lastSlash + 1);
                File dir = new File(AppUtil.BLOCK_OPMODES_DIR, "../java/src/" + relativeDir);
                dir.mkdirs();
                File javaFile = new File(dir, filename);
                ReadWriteFile.updateFileRequiringCommit((File)javaFile, (String)javaContent);
                return null;
            }
        });
    }

    private static String formatExtraXml(OpModeMeta.Flavor flavor, String group, String autoTransition, boolean enabled) throws IOException {
        XmlSerializer serializer = Xml.newSerializer();
        StringWriter writer = new StringWriter();
        serializer.setOutput((Writer)writer);
        serializer.startDocument("UTF-8", Boolean.valueOf(true));
        serializer.startTag("", XML_TAG_EXTRA);
        serializer.startTag("", XML_TAG_OP_MODE_META);
        serializer.attribute("", XML_ATTRIBUTE_FLAVOR, flavor.toString());
        serializer.attribute("", XML_ATTRIBUTE_GROUP, group);
        if (autoTransition != null) {
            serializer.attribute("", XML_ATTRIBUTE_AUTO_TRANSITION, autoTransition);
        }
        serializer.endTag("", XML_TAG_OP_MODE_META);
        serializer.startTag("", XML_TAG_ENABLED);
        serializer.attribute("", XML_ATTRIBUTE_VALUE, Boolean.toString(enabled));
        serializer.endTag("", XML_TAG_ENABLED);
        serializer.endTag("", XML_TAG_EXTRA);
        serializer.endDocument();
        return writer.toString();
    }

    private static OpModeMeta createOpModeMeta(String projectName, String extraXml) {
        OpModeMeta.Flavor flavor = DEFAULT_FLAVOR;
        String group = "";
        String autoTransition = null;
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)new StringReader(ProjectsUtil.removeNewLines(extraXml)));
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && parser.getName().equals(XML_TAG_OP_MODE_META)) {
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String name = parser.getAttributeName(i);
                        String value = parser.getAttributeValue(i);
                        if (name.equals(XML_ATTRIBUTE_FLAVOR)) {
                            flavor = OpModeMeta.Flavor.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                            continue;
                        }
                        if (name.equals(XML_ATTRIBUTE_GROUP)) {
                            if (value.isEmpty() || value.equals("$$$$$$$")) continue;
                            group = value;
                            continue;
                        }
                        if (!name.equals(XML_ATTRIBUTE_AUTO_TRANSITION) || value.isEmpty()) continue;
                        autoTransition = value;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            RobotLog.e((String)("ProjectsUtil.createOpmodeMeta(\"" + projectName + "\", ...) - failed to parse xml."));
            RobotLog.logStackTrace((Throwable)e);
        }
        OpModeMeta.Builder builder = new OpModeMeta.Builder().setName(projectName).setFlavor(flavor).setGroup(group).setSource(OpModeMeta.Source.BLOCKLY);
        if (autoTransition != null) {
            builder.setTransitionTarget(autoTransition);
        }
        return builder.build();
    }

    private static boolean isProjectEnabled(String projectName) throws IOException {
        if (!ProjectsUtil.isValidProjectName(projectName)) {
            throw new IllegalArgumentException();
        }
        ProjectsUtil.ensureChangesAreCommitted(projectName);
        File blkFile = new File(AppUtil.BLOCK_OPMODES_DIR, projectName + ".blk");
        String blkFileContent = FileUtil.readFile(blkFile);
        int iXmlEndTag = blkFileContent.indexOf(XML_END_TAG);
        if (iXmlEndTag == -1) {
            throw new CorruptFileException("File " + blkFile.getName() + " is empty or corrupt.");
        }
        String extraXml = blkFileContent.substring(iXmlEndTag + XML_END_TAG.length());
        return ProjectsUtil.isProjectEnabled(projectName, extraXml);
    }

    private static boolean isProjectEnabled(String projectName, String extraXml) {
        boolean enabled = true;
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)new StringReader(ProjectsUtil.removeNewLines(extraXml)));
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && parser.getName().equals(XML_TAG_ENABLED)) {
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String name = parser.getAttributeName(i);
                        String value = parser.getAttributeValue(i);
                        if (!name.equals(XML_ATTRIBUTE_VALUE)) continue;
                        enabled = Boolean.parseBoolean(value);
                    }
                }
                eventType = parser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            RobotLog.e((String)("ProjectsUtil.isProjectEnabled(\"" + projectName + "\", ...) - failed to parse xml."));
            RobotLog.logStackTrace((Throwable)e);
        }
        return enabled;
    }

    private static String removeNewLines(String text) {
        return text.replace("\n", "");
    }

    static class BlocksProjectFilenameFilter
    implements FilenameFilter {
        BlocksProjectFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            if (filename.endsWith(".blk")) {
                String projectName = filename.substring(0, filename.length() - ".blk".length());
                return ProjectsUtil.isValidProjectName(projectName);
            }
            return false;
        }
    }
}

