/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.RobotConfigResFilter;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationTypeManager;
import java.util.Collection;
import org.firstinspires.ftc.ftccommon.internal.AnnotatedHooksClassFilter;
import org.firstinspires.ftc.robotcore.external.Supplier;
import org.firstinspires.ftc.robotcore.internal.opmode.AnnotatedOpModeClassFilter;
import org.firstinspires.ftc.robotcore.internal.opmode.BlocksClassFilter;
import org.firstinspires.ftc.robotcore.internal.opmode.ClassFilter;
import org.firstinspires.ftc.robotcore.internal.opmode.ClassManager;

public class ClassManagerFactory {
    private static RobotConfigResFilter idResFilter;
    private static RobotConfigResFilter idTemplateResFilter;

    public static void registerFilters() {
        ClassManagerFactory.registerResourceFilters();
        ClassManager classManager = ClassManager.getInstance();
        classManager.registerFilter((ClassFilter)AnnotatedHooksClassFilter.getInstance());
        classManager.registerFilter((ClassFilter)AnnotatedOpModeClassFilter.getInstance());
        classManager.registerFilter((ClassFilter)BlocksClassFilter.getInstance());
        classManager.registerFilter((ClassFilter)ConfigurationTypeManager.getInstance());
    }

    public static void registerResourceFilters() {
        ClassManager classManager = ClassManager.getInstance();
        if (idResFilter == null) {
            idResFilter = new RobotConfigResFilter(RobotConfigFileManager.getRobotConfigTypeAttribute());
            RobotConfigFileManager.setXmlResourceIdSupplier(new Supplier<Collection<Integer>>(){

                public Collection<Integer> get() {
                    return idResFilter.getXmlIds();
                }
            });
        }
        if (idTemplateResFilter == null) {
            idTemplateResFilter = new RobotConfigResFilter(RobotConfigFileManager.getRobotConfigTemplateAttribute());
            RobotConfigFileManager.setXmlResourceTemplateIdSupplier(new Supplier<Collection<Integer>>(){

                public Collection<Integer> get() {
                    return idTemplateResFilter.getXmlIds();
                }
            });
        }
        classManager.registerFilter((ClassFilter)idResFilter);
        classManager.registerFilter((ClassFilter)idTemplateResFilter);
    }

    public static void processAllClasses() {
        ClassManager.getInstance().processAllClasses();
    }
}

