/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.widget.FrameLayout;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.wifi.NetworkType;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.PreferencesHelper;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.inspection.R;

public class FtcAdvancedRCSettingsActivity
extends ThemedActivity {
    public static final String TAG = "FtcAdvancedRCSettingsActivity";
    protected static final String CLIENT_CONNECTED = "CLIENT_CONNECTED";

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_generic_settings);
        DeviceNameManagerFactory.getInstance().initializeDeviceNameIfNecessary();
        SettingsFragment settingsFragment = new SettingsFragment();
        Bundle arguments = new Bundle();
        arguments.putBoolean(CLIENT_CONNECTED, new PreferencesHelper(TAG, (Context)this).readBoolean(this.getString(R.string.pref_rc_connected), false));
        settingsFragment.setArguments(arguments);
        this.getFragmentManager().beginTransaction().replace(R.id.container, (Fragment)settingsFragment).commit();
    }

    public static class SettingsFragment
    extends PreferenceFragment {
        protected boolean clientConnected = false;
        protected boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
        protected boolean controlHubConnectionMode = NetworkConnectionHandler.getNetworkType((Context)AppUtil.getDefContext()) == NetworkType.WIRELESSAP;
        protected PreferencesHelper preferencesHelper = new PreferencesHelper("FtcAdvancedRCSettingsActivity");

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.clientConnected = this.getArguments().getBoolean(FtcAdvancedRCSettingsActivity.CLIENT_CONNECTED);
            this.addPreferencesFromResource(R.xml.advanced_rc_settings);
            Preference prefEditClearRememberedGroups = this.findPreference(this.getString(R.string.pref_launch_wifi_remembered_groups_edit));
            Preference prefChangeChannel = this.findPreference(this.getString(R.string.pref_launch_wifi_channel_edit));
            Preference prefLynxFirmwareUpdateMode = this.findPreference(this.getString(R.string.pref_launch_lynx_firmware_update));
            if (LynxConstants.isRevControlHub() || this.controlHubConnectionMode) {
                prefLynxFirmwareUpdateMode.setSummary(R.string.summaryLynxFirmwareUpdateCH);
            }
            if (!this.clientConnected) {
                for (int i = 0; i < this.getPreferenceScreen().getPreferenceCount(); ++i) {
                    this.getPreferenceScreen().getPreference(i).setEnabled(false);
                }
            }
            boolean changingControlHubSettings = this.remoteConfigure && LynxConstants.isRevControlHub() || this.clientConnected && !this.preferencesHelper.readBoolean(this.getString(R.string.pref_wifip2p_remote_channel_change_works), false);
            prefChangeChannel.setEnabled(!changingControlHubSettings);
            prefEditClearRememberedGroups.setEnabled(!changingControlHubSettings);
            RobotLog.vv((String)FtcAdvancedRCSettingsActivity.TAG, (String)"clientConnected=%s", (Object[])new Object[]{this.clientConnected});
        }
    }
}

