/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.Activity;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import com.qualcomm.ftccommon.FtcEventLoopBase;
import com.qualcomm.ftccommon.UpdateUI;
import com.qualcomm.ftccommon.UsbModuleAttachmentHandler;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.RobotConfigMap;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.hardware.HardwareFactory;
import com.qualcomm.hardware.bosch.BHI260IMU;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleWarningManager;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.hardware.lynx.commands.core.LynxFirmwareVersionManager;
import com.qualcomm.robotcore.eventloop.EventLoopManager;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.eventloop.opmode.OpModeRegister;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.Gamepad;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.LynxModuleImuType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationTypeManager;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.Utility;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import com.qualcomm.robotcore.hardware.usb.RobotUsbModule;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.robocol.TelemetryMessage;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlOpMode;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.internal.camera.CameraManagerInternal;
import org.firstinspires.ftc.robotcore.internal.ftdi.FtDevice;
import org.firstinspires.ftc.robotcore.internal.ftdi.FtDeviceManager;
import org.firstinspires.ftc.robotcore.internal.hardware.CachedLynxModulesInfo;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.xmlpull.v1.XmlPullParserException;

public class FtcEventLoop
extends FtcEventLoopBase {
    private static volatile boolean hasInitBeenCalled = false;
    protected final Utility utility;
    protected final OpModeManagerImpl opModeManager;
    protected UsbModuleAttachmentHandler usbModuleAttachmentHandler;
    protected final Map<String, Long> recentlyAttachedUsbDevices;
    protected final AtomicReference<OpMode> opModeStopRequested;

    public FtcEventLoop(HardwareFactory hardwareFactory, OpModeRegister userOpmodeRegister, UpdateUI.Callback callback, Activity activityContext) {
        super(hardwareFactory, userOpmodeRegister, callback, activityContext);
        this.opModeManager = FtcEventLoop.createOpModeManager(activityContext);
        this.usbModuleAttachmentHandler = new DefaultUsbModuleAttachmentHandler();
        this.recentlyAttachedUsbDevices = new ConcurrentHashMap<String, Long>();
        this.opModeStopRequested = new AtomicReference();
        this.utility = new Utility(activityContext);
    }

    protected static OpModeManagerImpl createOpModeManager(Activity activityContext) {
        return new OpModeManagerImpl(activityContext, new HardwareMap((Context)activityContext, null));
    }

    public OpModeManagerImpl getOpModeManager() {
        return this.opModeManager;
    }

    public UsbModuleAttachmentHandler getUsbModuleAttachmentHandler() {
        return this.usbModuleAttachmentHandler;
    }

    public void setUsbModuleAttachmentHandler(UsbModuleAttachmentHandler handler) {
        this.usbModuleAttachmentHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(EventLoopManager eventLoopManager) throws RobotCoreException, InterruptedException {
        boolean appJustLaunched = !hasInitBeenCalled;
        hasInitBeenCalled = true;
        RobotLog.ii((String)"FtcEventLoop", (String)"======= INIT START =======");
        super.init(eventLoopManager);
        this.opModeManager.init(eventLoopManager);
        this.registeredOpModes.registerAllOpModes(this.userOpmodeRegister);
        this.sendActiveConfig();
        ConfigurationTypeManager.getInstance().sendUserDeviceTypes();
        this.sendOpModeList();
        ManualControlOpMode.setEventLoopManager(eventLoopManager);
        this.ftcEventLoopHandler.init(eventLoopManager);
        try (LynxUsbDevice temporaryEmbeddedLynxUsb = null;){
            if (LynxConstants.isRevControlHub()) {
                try {
                    temporaryEmbeddedLynxUsb = this.ensureEmbeddedControlHubModuleIsSetUp();
                    int chAddress = 173;
                    AtomicReference imuTypeRef = new AtomicReference();
                    temporaryEmbeddedLynxUsb.performSystemOperationOnParentModule(173, module -> {
                        LynxModuleImuType imuType = module.getImuType();
                        imuTypeRef.set(imuType);
                        EmbeddedControlHubModule.setImuType((LynxModuleImuType)imuType);
                    }, 200, TimeUnit.MILLISECONDS);
                    if (appJustLaunched && imuTypeRef.get() == LynxModuleImuType.BHI260) {
                        try {
                            temporaryEmbeddedLynxUsb.performSystemOperationOnParentModule(173, module -> {
                                try (LynxI2cDeviceSynch tempImuI2cClient = LynxFirmwareVersionManager.createLynxI2cDeviceSynch((Context)AppUtil.getDefContext(), (LynxModule)module, (int)0);){
                                    BHI260IMU.flashFirmwareIfNecessary((I2cDeviceSynchSimple)tempImuI2cClient);
                                }
                            }, 60, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException e) {
                            RobotLog.ee((String)"FtcEventLoop", (Throwable)e, (String)"Timeout expired while flashing BHI260AP IMU firmware");
                        }
                    }
                }
                catch (RobotCoreException | TimeoutException e) {
                    RobotLog.ee((String)"FtcEventLoop", (Throwable)e, (String)"Error communicating with internal Control Hub LynxModule");
                }
            }
            HardwareMap hardwareMap = this.ftcEventLoopHandler.getHardwareMap((OpModeManagerNotifier)this.opModeManager);
            this.opModeManager.setHardwareMap(hardwareMap);
            hardwareMap.logDevices();
            CachedLynxModulesInfo.setLynxModulesInfo(this.compileLynxModulesInfo(hardwareMap));
            LynxModuleWarningManager.getInstance().init(this.opModeManager, hardwareMap);
            I2cWarningManager.clearI2cWarnings();
        }
        RobotLog.ii((String)"FtcEventLoop", (String)"======= INIT FINISH =======");
    }

    @Override
    public void loop() {
        super.loop();
        OpMode opModeToStop = this.opModeStopRequested.getAndSet(null);
        if (opModeToStop != null) {
            this.processOpModeStopRequest(opModeToStop);
        }
        this.checkForChangedOpModes();
        this.ftcEventLoopHandler.displayGamePadInfo(this.opModeManager.getActiveOpModeName());
        Gamepad[] opModeGamepads = this.ftcEventLoopHandler.getOpModeGamepads();
        Gamepad latestGamepad1Data = this.ftcEventLoopHandler.getLatestGamepad1Data();
        Gamepad latestGamepad2Data = this.ftcEventLoopHandler.getLatestGamepad2Data();
        this.ftcEventLoopHandler.gamepadEffects();
        this.opModeManager.runActiveOpMode(opModeGamepads, latestGamepad1Data, latestGamepad2Data);
    }

    public void refreshUserTelemetry(TelemetryMessage telemetry, double sInterval) {
        this.ftcEventLoopHandler.refreshUserTelemetry(telemetry, sInterval);
    }

    @Override
    public void teardown() throws RobotCoreException, InterruptedException {
        RobotLog.ii((String)"FtcEventLoop", (String)"======= TEARDOWN =======");
        this.opModeManager.stopActiveOpMode();
        this.opModeManager.teardown();
        super.teardown();
        RobotLog.ii((String)"FtcEventLoop", (String)"======= TEARDOWN COMPLETE =======");
    }

    @Override
    public CallbackResult processCommand(Command command) throws InterruptedException, RobotCoreException {
        this.ftcEventLoopHandler.sendBatteryInfo();
        CallbackResult result = super.processCommand(command);
        if (!result.stopDispatch()) {
            CallbackResult localResult = CallbackResult.HANDLED;
            String name = command.getName();
            String extra = command.getExtra();
            if (name.equals("CMD_INIT_OP_MODE")) {
                this.handleCommandInitOpMode(extra);
            } else if (name.equals("CMD_RUN_OP_MODE")) {
                this.handleCommandRunOpMode(extra);
            } else if (name.equals("CMD_SET_MATCH_NUMBER")) {
                this.handleCommandSetMatchNumber(extra);
            } else {
                localResult = CallbackResult.NOT_HANDLED;
            }
            if (localResult == CallbackResult.HANDLED) {
                result = localResult;
            }
        }
        return result;
    }

    @Override
    protected void sendOpModeList() {
        super.sendOpModeList();
        EventLoopManager manager = this.ftcEventLoopHandler.getEventLoopManager();
        if (manager != null) {
            manager.refreshSystemTelemetryNow();
        }
    }

    protected void handleCommandSetMatchNumber(String extra) {
        try {
            this.opModeManager.setMatchNumber(Integer.parseInt(extra));
        }
        catch (NumberFormatException e) {
            RobotLog.logStackTrace((Throwable)e);
        }
    }

    protected void handleCommandInitOpMode(String extra) {
        String newOpMode = this.ftcEventLoopHandler.getOpMode(extra);
        this.opModeManager.initOpMode(newOpMode);
    }

    protected void handleCommandRunOpMode(String extra) {
        String newOpMode = this.ftcEventLoopHandler.getOpMode(extra);
        if (!this.opModeManager.getActiveOpModeName().equals(newOpMode)) {
            this.opModeManager.initOpMode(newOpMode);
        }
        this.opModeManager.startActiveOpMode();
    }

    public void requestOpModeStop(OpMode opModeToStopIfActive) {
        this.opModeStopRequested.set(opModeToStopIfActive);
    }

    private void processOpModeStopRequest(OpMode opModeToStop) {
        if (opModeToStop != null && this.opModeManager.getActiveOpMode() == opModeToStop) {
            RobotLog.ii((String)"FtcEventLoop", (String)"auto-stopping OpMode '%s'", (Object[])new Object[]{this.opModeManager.getActiveOpModeName()});
            this.opModeManager.stopActiveOpMode();
        }
    }

    public void onUsbDeviceAttached(UsbDevice usbDevice) {
        SerialNumber serialNumber = this.getSerialNumberOfUsbDevice(usbDevice);
        if (serialNumber != null) {
            this.pendUsbDeviceAttachment(serialNumber, 0L, TimeUnit.MILLISECONDS);
        } else {
            RobotLog.ee((String)"FtcEventLoop", (String)"ignoring: unable get serial number of attached UsbDevice vendor=0x%04x, product=0x%04x device=0x%04x name=%s", (Object[])new Object[]{usbDevice.getVendorId(), usbDevice.getProductId(), usbDevice.getDeviceId(), usbDevice.getDeviceName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerialNumber getSerialNumberOfUsbDevice(UsbDevice usbDevice) {
        SerialNumber serialNumber = null;
        serialNumber = SerialNumber.fromStringOrNull((String)usbDevice.getSerialNumber());
        if (serialNumber == null) {
            try (FtDevice ftDevice = null;){
                FtDeviceManager manager = FtDeviceManager.getInstance();
                ftDevice = manager.openByUsbDevice(usbDevice);
                if (ftDevice != null) {
                    serialNumber = SerialNumber.fromStringOrNull((String)ftDevice.getDeviceInfo().serialNumber);
                }
            }
        }
        if (serialNumber == null) {
            try {
                CameraManagerInternal cameraManagerInternal = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
                serialNumber = cameraManagerInternal.getRealOrVendorProductSerialNumber(usbDevice);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return serialNumber;
    }

    public void pendUsbDeviceAttachment(SerialNumber serialNumber, long time, TimeUnit unit) {
        long nsDeadline = time == 0L ? 0L : System.nanoTime() + unit.toNanos(time);
        this.recentlyAttachedUsbDevices.put(serialNumber.getString(), nsDeadline);
    }

    public void processedRecentlyAttachedUsbDevices() throws RobotCoreException, InterruptedException {
        HashSet<String> serialNumbersToProcess = new HashSet<String>();
        long now = System.nanoTime();
        for (Map.Entry<String, Long> pair : this.recentlyAttachedUsbDevices.entrySet()) {
            if (pair.getValue() > now) continue;
            serialNumbersToProcess.add(pair.getKey());
            this.recentlyAttachedUsbDevices.remove(pair.getKey());
        }
        if (this.usbModuleAttachmentHandler != null && !serialNumbersToProcess.isEmpty()) {
            List modules = this.ftcEventLoopHandler.getHardwareMap((OpModeManagerNotifier)this.opModeManager).getAll(RobotUsbModule.class);
            for (String serialNumberString : new ArrayList(serialNumbersToProcess)) {
                SerialNumber serialNumberAttached = SerialNumber.fromString((String)serialNumberString);
                boolean found = false;
                for (RobotUsbModule module : modules) {
                    if (!serialNumberAttached.matches((Object)module.getSerialNumber()) || module.getArmingState() == RobotArmingStateNotifier.ARMINGSTATE.ARMED) continue;
                    serialNumbersToProcess.remove(serialNumberString);
                    this.handleUsbModuleAttach(module);
                    found = true;
                    break;
                }
                if (found) continue;
                RobotLog.vv((String)"FtcEventLoop", (String)"processedRecentlyAttachedUsbDevices(): %s not in hwmap; ignoring", (Object[])new Object[]{serialNumberAttached});
            }
        }
    }

    public void handleUsbModuleDetach(RobotUsbModule module) throws RobotCoreException, InterruptedException {
        UsbModuleAttachmentHandler handler = this.usbModuleAttachmentHandler;
        if (handler != null) {
            handler.handleUsbModuleDetach(module);
        }
    }

    public void handleUsbModuleAttach(RobotUsbModule module) throws RobotCoreException, InterruptedException {
        UsbModuleAttachmentHandler handler = this.usbModuleAttachmentHandler;
        if (handler != null) {
            handler.handleUsbModuleAttach(module);
        }
    }

    private LynxUsbDevice ensureEmbeddedControlHubModuleIsSetUp() throws RobotCoreException, InterruptedException {
        RobotLog.vv((String)"FtcEventLoop", (String)"Ensuring that the embedded Control Hub module is set up correctly");
        LynxUsbDevice embeddedLynxUsb = (LynxUsbDevice)USBScanManager.getInstance().getDeviceManager().createLynxUsbDevice(SerialNumber.createEmbedded(), null);
        boolean justChangedControlHubAddress = embeddedLynxUsb.setupControlHubEmbeddedModule();
        if (justChangedControlHubAddress) {
            this.updateEditableConfigFilesWithNewControlHubAddress();
            embeddedLynxUsb.close();
            embeddedLynxUsb = (LynxUsbDevice)USBScanManager.getInstance().getDeviceManager().createLynxUsbDevice(SerialNumber.createEmbedded(), null);
        }
        return embeddedLynxUsb;
    }

    private void updateEditableConfigFilesWithNewControlHubAddress() throws RobotCoreException {
        RobotLog.vv((String)"FtcEventLoop", (String)"We just auto-changed the Control Hub's address. Now auto-updating configuration files.");
        ReadXMLFileHandler xmlReader = new ReadXMLFileHandler(USBScanManager.getInstance().getDeviceManager());
        RobotConfigFileManager configFileManager = new RobotConfigFileManager();
        for (RobotConfigFile configFile : configFileManager.getXMLFiles()) {
            if (configFile.isReadOnly()) continue;
            RobotLog.vv((String)"FtcEventLoop", (String)"Updating \"%s\" config file", (Object[])new Object[]{configFile.getName()});
            try {
                RobotConfigMap deserializedConfig = new RobotConfigMap(xmlReader.parse(configFile.getXml()));
                String reserializedConfig = configFileManager.toXml(deserializedConfig);
                configFileManager.writeToFile(configFile, false, reserializedConfig);
            }
            catch (IOException | RuntimeException | XmlPullParserException e) {
                RobotLog.ee((String)"FtcEventLoop", (Throwable)e, (String)String.format(Locale.ENGLISH, "Failed to auto-update config file %s after automatically changing embedded Control Hub module address. This is OK.", configFile.getName()));
            }
        }
    }

    private List<CachedLynxModulesInfo.LynxModuleInfo> compileLynxModulesInfo(HardwareMap hardwareMap) {
        ArrayList<CachedLynxModulesInfo.LynxModuleInfo> result = new ArrayList<CachedLynxModulesInfo.LynxModuleInfo>();
        List lynxModules = hardwareMap.getAll(LynxModule.class);
        for (LynxModule module : lynxModules) {
            String moduleName;
            try {
                moduleName = (String)hardwareMap.getNamesOf((HardwareDevice)module).iterator().next();
            }
            catch (RuntimeException e) {
                moduleName = module.getRevProductNumber() == 3215698 ? "Expansion Hub " + module.getModuleAddress() : (module.getRevProductNumber() == 0x111855 ? "Servo Hub " + module.getModuleAddress() : "Unknown Device " + module.getModuleAddress());
            }
            String rawFirmwareVersionString = module.getNullableFirmwareVersionString();
            LynxModuleImuType imuType = module.getImuType();
            result.add(new CachedLynxModulesInfo.LynxModuleInfo(moduleName, rawFirmwareVersionString, module.getSerialNumber().toString(), module.getModuleAddress(), imuType, module.getRevProductNumber()));
        }
        Collections.sort(result, new Comparator<CachedLynxModulesInfo.LynxModuleInfo>(){

            @Override
            public int compare(CachedLynxModulesInfo.LynxModuleInfo o1, CachedLynxModulesInfo.LynxModuleInfo o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return Collections.unmodifiableList(result);
    }

    public class DefaultUsbModuleAttachmentHandler
    implements UsbModuleAttachmentHandler {
        @Override
        public void handleUsbModuleAttach(RobotUsbModule module) throws RobotCoreException, InterruptedException {
            String id2 = this.nameOfUsbModule(module);
            RobotLog.ii((String)"FtcEventLoop", (String)"vv===== MODULE ATTACH: disarm %s=====vv", (Object[])new Object[]{id2});
            module.disarm();
            RobotLog.ii((String)"FtcEventLoop", (String)"======= MODULE ATTACH: arm or pretend %s=======", (Object[])new Object[]{id2});
            module.armOrPretend();
            RobotLog.ii((String)"FtcEventLoop", (String)"^^===== MODULE ATTACH: complete %s=====^^", (Object[])new Object[]{id2});
        }

        @Override
        public void handleUsbModuleDetach(RobotUsbModule module) throws RobotCoreException, InterruptedException {
            String id2 = this.nameOfUsbModule(module);
            RobotLog.ii((String)"FtcEventLoop", (String)"vv===== MODULE DETACH RECOVERY: disarm %s=====vv", (Object[])new Object[]{id2});
            module.disarm();
            RobotLog.ii((String)"FtcEventLoop", (String)"======= MODULE DETACH RECOVERY: pretend %s=======", (Object[])new Object[]{id2});
            module.pretend();
            RobotLog.ii((String)"FtcEventLoop", (String)"^^===== MODULE DETACH RECOVERY: complete %s=====^^", (Object[])new Object[]{id2});
        }

        String nameOfUsbModule(RobotUsbModule module) {
            return HardwareFactory.getDeviceDisplayName((Context)FtcEventLoop.this.activityContext, (SerialNumber)module.getSerialNumber());
        }
    }
}

