/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.CallSuper;
import com.qualcomm.ftccommon.CommandList;
import com.qualcomm.ftccommon.FtcAboutActivity;
import com.qualcomm.ftccommon.FtcEventLoopHandler;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.SoundPlayer;
import com.qualcomm.ftccommon.UpdateUI;
import com.qualcomm.ftccommon.VisualIdentificationManager;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.hardware.HardwareFactory;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.robotcore.eventloop.EventLoop;
import com.qualcomm.robotcore.eventloop.EventLoopManager;
import com.qualcomm.robotcore.eventloop.opmode.OpModeRegister;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.Blinker;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.LynxModuleMeta;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.USBAccessibleLynxModule;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationTypeManager;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.WriteXMLFileHandler;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.WebServer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.firstinspires.ftc.robotcore.external.Consumer;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamServer;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.PreferenceRemoterRC;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectAgent;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectGroupName;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectPersistentGroupManager;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaBuildLocker;
import org.firstinspires.ftc.robotcore.internal.opmode.RegisteredOpModes;
import org.firstinspires.ftc.robotcore.internal.system.AppAliveNotifier;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.firstinspires.ftc.robotcore.internal.ui.ProgressParameters;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.inspection.InspectionState;
import org.xmlpull.v1.XmlPullParserException;

public abstract class FtcEventLoopBase
implements EventLoop {
    public static final String TAG = "FtcEventLoop";
    protected NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected Activity activityContext;
    protected RobotConfigFileManager robotCfgFileMgr;
    protected FtcEventLoopHandler ftcEventLoopHandler;
    protected boolean runningOnDriverStation = false;
    protected final USBScanManager usbScanManager = USBScanManager.getInstance();
    protected final OpModeRegister userOpmodeRegister;
    protected final RegisteredOpModes registeredOpModes;

    protected FtcEventLoopBase(HardwareFactory hardwareFactory, OpModeRegister userOpmodeRegister, UpdateUI.Callback callback, Activity activityContext) {
        this.userOpmodeRegister = userOpmodeRegister;
        this.registeredOpModes = RegisteredOpModes.getInstance();
        this.activityContext = activityContext;
        this.robotCfgFileMgr = new RobotConfigFileManager(activityContext);
        this.ftcEventLoopHandler = new FtcEventLoopHandler(hardwareFactory, callback, (Context)activityContext);
    }

    public void teardown() throws RobotCoreException, InterruptedException {
        this.ftcEventLoopHandler.close();
    }

    public CallbackResult processCommand(Command command) throws InterruptedException, RobotCoreException {
        CallbackResult result = CallbackResult.HANDLED;
        String name = command.getName();
        String extra = command.getExtra();
        if (name.equals("CMD_RESTART_ROBOT")) {
            this.handleCommandRestartRobot();
        } else if (name.equals("CMD_REQUEST_CONFIGURATIONS")) {
            this.handleCommandRequestConfigurations();
        } else if (name.equals("CMD_REQUEST_REMEMBERED_GROUPS")) {
            this.handleCommandRequestRememberedGroups();
        } else if (name.equals("CMD_CLEAR_REMEMBERED_GROUPS")) {
            this.handleCommandClearRememberedGroups();
        } else if (name.equals("CMD_SCAN")) {
            this.handleCommandScan(extra);
        } else if (name.equals("CMD_DISCOVER_LYNX_MODULES")) {
            this.handleCommandDiscoverLynxModules(extra);
        } else if (name.equals("CMD_LYNX_FIRMWARE_UPDATE")) {
            this.handleCommandLynxFirmwareUpdate(command);
        } else if (name.equals("CMD_GET_USB_ACCESSIBLE_LYNX_MODULES")) {
            this.handleCommandGetUSBAccessibleLynxModules(command);
        } else if (name.equals("CMD_LYNX_ADDRESS_CHANGE")) {
            this.handleCommandLynxChangeModuleAddresses(command);
        } else if (name.equals("CMD_GET_CANDIDATE_LYNX_FIRMWARE_IMAGES")) {
            this.handleCommandGetCandidateLynxFirmwareImages(command);
        } else if (name.equals("CMD_REQUEST_INSPECTION_REPORT")) {
            this.handleCommandRequestInspectionReport();
        } else if (name.equals("CMD_DISABLE_BLUETOOTH")) {
            this.handleCommandDisableBluetooth();
        } else if (name.equals("CMD_REQUEST_ABOUT_INFO")) {
            this.handleCommandRequestAboutInfo(command);
        } else if (name.equals("CMD_DISCONNECT_FROM_WIFI_DIRECT")) {
            this.handleCommandDisconnectWifiDirect();
        } else if (name.equals("CMD_REQUEST_CONFIGURATION_TEMPLATES")) {
            this.handleCommandRequestConfigurationTemplates();
        } else if (name.equals("CMD_REQUEST_PARTICULAR_CONFIGURATION")) {
            this.handleCommandRequestParticularConfiguration(extra);
        } else if (name.equals("CMD_ACTIVATE_CONFIGURATION")) {
            this.handleCommandActivateConfiguration(extra);
        } else if (name.equals("CMD_REQUEST_USER_DEVICE_TYPES")) {
            ConfigurationTypeManager.getInstance().sendUserDeviceTypes();
        } else if (name.equals("CMD_REQUEST_ACTIVE_CONFIG")) {
            this.sendActiveConfig();
        } else if (name.equals("CMD_REQUEST_OP_MODE_LIST")) {
            this.sendOpModeList();
        } else if (name.equals("CMD_SAVE_CONFIGURATION")) {
            this.handleCommandSaveConfiguration(extra);
        } else if (name.equals("CMD_DELETE_CONFIGURATION")) {
            this.handleCommandDeleteConfiguration(extra);
        } else if (name.equals("CMD_START_DS_PROGRAM_AND_MANAGE")) {
            this.handleCommandStartDriverStationProgramAndManage();
        } else if (name.equals("CMD_SHOW_TOAST")) {
            this.handleCommandShowToast(command);
        } else if (name.equals("CMD_SHOW_DIALOG")) {
            this.handleCommandShowDialog(command);
        } else if (name.equals("CMD_DISMISS_DIALOG")) {
            this.handleCommandDismissDialog(command);
        } else if (name.equals("CMD_DISMISS_ALL_DIALOGS")) {
            this.handleCommandDismissAllDialogs(command);
        } else if (name.equals("CMD_SHOW_PROGRESS")) {
            this.handleCommandShowProgress(command);
        } else if (name.equals("CMD_DISMISS_PROGRESS")) {
            this.handleCommandDismissProgress(command);
        } else {
            result = name.equals("CMD_ROBOT_CONTROLLER_PREFERENCE") ? PreferenceRemoterRC.getInstance().handleCommandRobotControllerPreference(extra) : (name.equals("CMD_PLAY_SOUND") ? SoundPlayer.getInstance().handleCommandPlaySound(extra) : (name.equals("CMD_REQUEST_SOUND") ? SoundPlayer.getInstance().handleCommandRequestSound(command) : (name.equals("CMD_STOP_PLAYING_SOUNDS") ? SoundPlayer.getInstance().handleCommandStopPlayingSounds(command) : (name.equals("CMD_REQUEST_FRAME") ? CameraStreamServer.getInstance().handleRequestFrame() : (name.equals("CMD_VISUALLY_IDENTIFY") ? this.handleCommandVisuallyIdentify(command) : (name.equals("CMD_VISUALLY_CONFIRM_WIFI_RESET") ? this.handleCommandVisuallyConfirmWifiReset() : (name.equals("CMD_VISUALLY_CONFIRM_WIFI_BAND_SWITCH") ? this.handleCommandVisuallyConfirmWifiBandSwitch(command) : CallbackResult.NOT_HANDLED)))))));
        }
        return result;
    }

    protected void handleCommandActivateConfiguration(String data) {
        RobotConfigFile cfgFile = this.robotCfgFileMgr.getConfigFromString(data);
        this.robotCfgFileMgr.setActiveConfigAndUpdateUI(this.runningOnDriverStation, cfgFile);
    }

    protected void sendActiveConfig() {
        RobotConfigFile configFile = this.robotCfgFileMgr.getActiveConfig();
        String serialized = configFile.toString();
        this.networkConnectionHandler.sendCommand(new Command("CMD_NOTIFY_ACTIVE_CONFIGURATION", serialized));
    }

    protected void sendOpModeList() {
        this.registeredOpModes.waitOpModesRegistered();
        String opModeList = SimpleGson.getInstance().toJson((Object)this.registeredOpModes.getOpModes());
        this.networkConnectionHandler.sendCommand(new Command("CMD_NOTIFY_OP_MODE_LIST", opModeList));
    }

    protected void checkForChangedOpModes() {
        boolean needToSendUIState = false;
        if (this.registeredOpModes.getOnBotJavaChanged()) {
            OnBotJavaBuildLocker.lockBuildExclusiveWhile((Runnable)new Runnable(){

                @Override
                public void run() {
                    FtcEventLoopBase.this.registeredOpModes.clearOnBotJavaChanged();
                    FtcEventLoopBase.this.registeredOpModes.registerOnBotJavaOpModes();
                }
            });
            needToSendUIState = true;
        }
        if (this.registeredOpModes.getExternalLibrariesChanged()) {
            this.registeredOpModes.clearExternalLibrariesChanged();
            this.registeredOpModes.registerExternalLibrariesOpModes();
            needToSendUIState = true;
        }
        if (this.registeredOpModes.getBlocksOpModesChanged()) {
            this.registeredOpModes.clearBlocksOpModesChanged();
            this.registeredOpModes.registerInstanceOpModes();
            needToSendUIState = true;
        }
        if (needToSendUIState) {
            this.sendOpModeList();
            ConfigurationTypeManager.getInstance().sendUserDeviceTypes();
        }
    }

    @CallSuper
    public void init(EventLoopManager eventLoopManager) throws RobotCoreException, InterruptedException {
    }

    @CallSuper
    public void loop() {
        AppAliveNotifier.getInstance().notifyAppAlive();
    }

    protected void handleCommandRestartRobot() {
        this.ftcEventLoopHandler.restartRobot();
    }

    protected void handleCommandRequestParticularConfiguration(String data) {
        RobotConfigFile file = this.robotCfgFileMgr.getConfigFromString(data);
        ReadXMLFileHandler parser = new ReadXMLFileHandler();
        if (file.isNoConfig()) {
            return;
        }
        try {
            WriteXMLFileHandler writeXMLFileHandler = new WriteXMLFileHandler();
            ArrayList deviceList = (ArrayList)parser.parse(file.getXml());
            String xmlData = writeXMLFileHandler.toXml((Collection)deviceList, true);
            RobotLog.vv((String)"FtcConfigTag", (String)("FtcEventLoop: handleCommandRequestParticularConfigFile, data: " + xmlData));
            this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_PARTICULAR_CONFIGURATION_RESP", xmlData));
        }
        catch (RobotCoreException | FileNotFoundException | XmlPullParserException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to get and/or parse the requested configuration file");
        }
    }

    protected void handleCommandDeleteConfiguration(String fileInfo) {
        RobotConfigFile cfgFile = this.robotCfgFileMgr.getConfigFromString(fileInfo);
        File file = RobotConfigFileManager.getFullPath(cfgFile.getName());
        if (!file.delete()) {
            RobotLog.ee((String)TAG, (String)("Tried to delete a file that does not exist: " + cfgFile.getName()));
        }
    }

    protected void handleCommandSaveConfiguration(String fileInfo) {
        String[] fileInfoArray = fileInfo.split(";");
        try {
            RobotConfigFile cfgFile = this.robotCfgFileMgr.getConfigFromString(fileInfoArray[0]);
            this.robotCfgFileMgr.writeToFile(cfgFile, false, fileInfoArray[1]);
            this.robotCfgFileMgr.setActiveConfigAndUpdateUI(false, cfgFile);
        }
        catch (RobotCoreException | IOException | RuntimeException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to save configuration file");
        }
    }

    protected void handleCommandRequestConfigurations() {
        ArrayList<RobotConfigFile> fileList = this.robotCfgFileMgr.getXMLFiles();
        String objsSerialized = RobotConfigFileManager.serializeXMLConfigList(fileList);
        this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_CONFIGURATIONS_RESP", objsSerialized));
    }

    protected void handleCommandRequestRememberedGroups() {
        WifiDirectPersistentGroupManager manager = new WifiDirectPersistentGroupManager(WifiDirectAgent.getInstance());
        String serialized = WifiDirectGroupName.serializeNames((Collection)manager.getPersistentGroups());
        this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_REMEMBERED_GROUPS_RESP", serialized));
    }

    protected void handleCommandClearRememberedGroups() {
        WifiDirectPersistentGroupManager manager = new WifiDirectPersistentGroupManager(WifiDirectAgent.getInstance());
        manager.deleteAllPersistentGroups();
        AppUtil.getInstance().showToast(UILocation.BOTH, AppUtil.getDefContext().getString(R.string.toastWifiP2pRememberedGroupsCleared));
    }

    protected void handleCommandScan(String extra) throws RobotCoreException, InterruptedException {
        RobotLog.vv((String)"FtcConfigTag", (String)"handling command SCAN");
        final ThreadPool.SingletonResult<ScannedDevices> future = this.usbScanManager.startDeviceScanIfNecessary();
        ThreadPool.getDefault().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ScannedDevices scannedDevices = (ScannedDevices)future.await();
                    if (scannedDevices == null) {
                        scannedDevices = new ScannedDevices();
                    }
                    String data = FtcEventLoopBase.this.usbScanManager.packageCommandResponse(scannedDevices);
                    RobotLog.vv((String)"FtcConfigTag", (String)"handleCommandScan data='%s'", (Object[])new Object[]{data});
                    FtcEventLoopBase.this.networkConnectionHandler.sendCommand(new Command("CMD_SCAN_RESP", data));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    protected void handleCommandDiscoverLynxModules(String extra) throws RobotCoreException {
        RobotLog.vv((String)"FtcConfigTag", (String)"handling command DiscoverLynxModules");
        final SerialNumber serialNumber = SerialNumber.fromString((String)extra);
        final ThreadPool.SingletonResult<LynxModuleMetaList> future = this.usbScanManager.startLynxModuleEnumerationIfNecessary(serialNumber);
        ThreadPool.getDefault().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LynxModuleMetaList lynxModules = (LynxModuleMetaList)future.await();
                    if (lynxModules == null) {
                        lynxModules = new LynxModuleMetaList(serialNumber);
                    }
                    String data = FtcEventLoopBase.this.usbScanManager.packageCommandResponse(lynxModules);
                    RobotLog.vv((String)"FtcConfigTag", (String)"DiscoverLynxModules data='%s'", (Object[])new Object[]{data});
                    FtcEventLoopBase.this.networkConnectionHandler.sendCommand(new Command("CMD_DISCOVER_LYNX_MODULES_RESP", data));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    protected void handleCommandLynxFirmwareUpdate(final Command commandRequest) {
        RobotLog.vv((String)TAG, (String)"handleCommandLynxFirmwareUpdate received");
        final RobotCoreCommandList.LynxFirmwareUpdate params = RobotCoreCommandList.LynxFirmwareUpdate.deserialize((String)commandRequest.getExtra());
        ThreadPool.getDefault().submit(new Runnable(){

            @Override
            public void run() {
                RobotCoreCommandList.LynxFirmwareUpdateResp result = FtcEventLoopBase.this.updateLynxFirmware(params.serialNumber, params.firmwareImageFile, params.originatorId);
                FtcEventLoopBase.this.networkConnectionHandler.sendReply(commandRequest, new Command("CMD_LYNX_FIRMWARE_UPDATE_RESP", result.serialize()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RobotCoreCommandList.LynxFirmwareUpdateResp updateLynxFirmware(final SerialNumber serialNumber, final RobotCoreCommandList.FWImage image, String requestId) {
        RobotCoreCommandList.LynxFirmwareUpdateResp result;
        block7: {
            result = new RobotCoreCommandList.LynxFirmwareUpdateResp();
            result.success = false;
            result.originatorId = requestId;
            final boolean updatingControlHub = serialNumber.isEmbedded();
            Consumer<ProgressParameters> progressConsumer = new Consumer<ProgressParameters>(){
                Double prevPercentComplete = null;

                public void accept(ProgressParameters parameters) {
                    double percentComplete = Math.round(parameters.fractionComplete() * 100.0);
                    if (this.prevPercentComplete == null || this.prevPercentComplete != percentComplete) {
                        this.prevPercentComplete = percentComplete;
                        String message = updatingControlHub ? String.format(FtcEventLoopBase.this.activityContext.getString(R.string.controlHubFirmwareUpdateMessage), image.getName()) : String.format(FtcEventLoopBase.this.activityContext.getString(R.string.expansionHubFirmwareUpdateMessage), serialNumber, image.getName());
                        AppUtil.getInstance().showProgress(UILocation.BOTH, message, parameters.fractionComplete(), 100);
                    }
                }
            };
            try {
                progressConsumer.accept((Object)new ProgressParameters(0, 1));
                LynxUsbDevice lynxUsbDevice = this.getLynxUsbDeviceForFirmwareUpdate(serialNumber);
                if (lynxUsbDevice != null) {
                    try {
                        result = lynxUsbDevice.updateFirmware(image, requestId, (Consumer)progressConsumer);
                        break block7;
                    }
                    finally {
                        lynxUsbDevice.close();
                    }
                }
                RobotLog.ee((String)TAG, (String)"unable to obtain lynx usb device for fw update: %s", (Object[])new Object[]{serialNumber});
            }
            finally {
                AppUtil.getInstance().dismissProgress(UILocation.BOTH);
            }
        }
        RobotLog.vv((String)TAG, (String)"updateLynxFirmware(%s, %s): result=%s", (Object[])new Object[]{serialNumber, image.getName(), result.serialize()});
        return result;
    }

    protected void handleCommandGetUSBAccessibleLynxModules(final Command commandRequest) {
        ThreadPool.getDefault().execute(new Runnable(){

            @Override
            public void run() {
                RobotCoreCommandList.USBAccessibleLynxModulesRequest request = RobotCoreCommandList.USBAccessibleLynxModulesRequest.deserialize((String)commandRequest.getExtra());
                ArrayList<USBAccessibleLynxModule> modules = new ArrayList<USBAccessibleLynxModule>();
                try {
                    modules.addAll(FtcEventLoopBase.this.getUSBAccessibleLynxDevices(request.forFirmwareUpdate));
                }
                catch (RobotCoreException robotCoreException) {
                    // empty catch block
                }
                Collections.sort(modules, new Comparator<USBAccessibleLynxModule>(){

                    @Override
                    public int compare(USBAccessibleLynxModule lhs, USBAccessibleLynxModule rhs) {
                        return lhs.getSerialNumber().getString().compareTo(rhs.getSerialNumber().getString());
                    }
                });
                RobotCoreCommandList.USBAccessibleLynxModulesResp resp = new RobotCoreCommandList.USBAccessibleLynxModulesResp();
                resp.modules = modules;
                FtcEventLoopBase.this.networkConnectionHandler.sendReply(commandRequest, new Command("CMD_GET_USB_ACCESSIBLE_LYNX_MODULES_RESP", resp.serialize()));
            }
        });
    }

    protected LynxUsbDevice getLynxUsbDeviceForFirmwareUpdate(SerialNumber serialNumber) {
        try {
            return (LynxUsbDevice)this.usbScanManager.getDeviceManager().createLynxUsbDevice(serialNumber, null);
        }
        catch (RobotCoreException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"getLynxUsbDeviceForFirmwareUpdate(): exception opening lynx usb device: %s", (Object[])new Object[]{serialNumber});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RobotLog.ee((String)TAG, (String)"Thread interrupted in getLynxUsbDeviceForFirmwareUpdate");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<USBAccessibleLynxModule> getUSBAccessibleLynxDevices(boolean forFirmwareUpdate) throws RobotCoreException {
        RobotLog.vv((String)TAG, (String)"getUSBAccessibleLynxDevices(includeModuleAddresses=%s)...", (Object[])new Object[]{forFirmwareUpdate});
        USBScanManager scanManager = USBScanManager.getInstance();
        ThreadPool.SingletonResult<ScannedDevices> future = scanManager.startDeviceScanIfNecessary();
        try {
            ScannedDevices scannedDevices = (ScannedDevices)future.await();
            ArrayList<USBAccessibleLynxModule> result = new ArrayList<USBAccessibleLynxModule>();
            for (Object entry : scannedDevices.entrySet()) {
                if (entry.getValue() != DeviceManager.UsbDeviceType.LYNX_USB_DEVICE) continue;
                SerialNumber serialNumber = (SerialNumber)entry.getKey();
                result.add(new USBAccessibleLynxModule(serialNumber));
            }
            if (LynxConstants.isRevControlHub()) {
                boolean found = false;
                for (USBAccessibleLynxModule module : result) {
                    if (!module.getSerialNumber().equals((Object)LynxConstants.SERIAL_NUMBER_EMBEDDED)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result.add(new USBAccessibleLynxModule(LynxConstants.SERIAL_NUMBER_EMBEDDED));
                }
            }
            for (USBAccessibleLynxModule module : result) {
                RobotLog.vv((String)TAG, (String)"getUSBAccessibleLynxDevices: found serial=%s", (Object[])new Object[]{module.getSerialNumber()});
            }
            if (forFirmwareUpdate) {
                RobotLog.vv((String)TAG, (String)"finding module addresses and current firmware versions");
                int i = 0;
                while (i < result.size()) {
                    USBAccessibleLynxModule usbModule = (USBAccessibleLynxModule)result.get(i);
                    RobotLog.vv((String)TAG, (String)"getUSBAccessibleLynxDevices: finding module address for usbModule %s", (Object[])new Object[]{usbModule.getSerialNumber()});
                    LynxUsbDevice lynxUsbDevice = (LynxUsbDevice)scanManager.getDeviceManager().createLynxUsbDevice(usbModule.getSerialNumber(), null);
                    try {
                        LynxModuleMetaList lynxModuleMetas = lynxUsbDevice.discoverModules(false);
                        boolean foundParent = false;
                        usbModule.setModuleAddress(0);
                        for (LynxModuleMeta meta : lynxModuleMetas) {
                            RobotLog.vv((String)TAG, (String)"assessing %s", (Object[])new Object[]{meta});
                            if (meta.getModuleAddress() == 0) {
                                RobotLog.vv((String)TAG, (String)"ignoring module with address zero");
                                continue;
                            }
                            if (!meta.isParent()) continue;
                            foundParent = true;
                            usbModule.setModuleAddress(meta.getModuleAddress());
                        }
                        boolean okToUpdateFirmware = true;
                        usbModule.setFirmwareVersionString("");
                        if (okToUpdateFirmware && foundParent) {
                            try {
                                lynxUsbDevice.performSystemOperationOnParentModule(usbModule.getModuleAddress(), lynxModule -> {
                                    String fw = lynxModule.getNullableFirmwareVersionString();
                                    if (fw != null) {
                                        usbModule.setFirmwareVersionString(fw);
                                    } else {
                                        RobotLog.ee((String)TAG, (String)"getUSBAccessibleLynxDevices(): fw returned null");
                                    }
                                }, 250, TimeUnit.MILLISECONDS);
                            }
                            catch (RobotCoreException | TimeoutException e) {
                                RobotLog.ee((String)TAG, (Throwable)e, (String)"exception retrieving fw version; ignoring");
                            }
                        }
                        if (okToUpdateFirmware) {
                            ++i;
                            continue;
                        }
                        RobotLog.vv((String)TAG, (String)"getUSBAccessibleLynxDevices: culled serial=%s", (Object[])new Object[]{usbModule.getSerialNumber()});
                        result.remove(i);
                    }
                    finally {
                        if (lynxUsbDevice == null) continue;
                        lynxUsbDevice.close();
                    }
                }
            }
            RobotLog.vv((String)TAG, (String)"getUSBAccessibleLynxDevices(): %d modules found", (Object[])new Object[]{result.size()});
            ArrayList<USBAccessibleLynxModule> arrayList = result;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ArrayList<USBAccessibleLynxModule> arrayList = new ArrayList<USBAccessibleLynxModule>();
            return arrayList;
        }
        finally {
            RobotLog.vv((String)TAG, (String)"...getUSBAccessibleLynxDevices()");
        }
    }

    protected void handleCommandLynxChangeModuleAddresses(final Command commandRequest) {
        ThreadPool.getDefault().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean success = true;
                    try {
                        CommandList.LynxAddressChangeRequest changeRequest = CommandList.LynxAddressChangeRequest.deserialize(commandRequest.getExtra());
                        DeviceManager deviceManager = FtcEventLoopBase.this.usbScanManager.getDeviceManager();
                        for (CommandList.LynxAddressChangeRequest.AddressChange addressChange : changeRequest.modulesToChange) {
                            RobotLog.vv((String)FtcEventLoopBase.TAG, (String)"lynx module connected to portal %s (parent address %d): change address %d -> %d", (Object[])new Object[]{addressChange.serialNumber, addressChange.parentAddress, addressChange.oldAddress, addressChange.newAddress});
                            LynxUsbDevice lynxUsbDevice = (LynxUsbDevice)deviceManager.createLynxUsbDevice(addressChange.serialNumber, null);
                            try {
                                lynxUsbDevice.performSystemOperationOnConnectedModule(addressChange.oldAddress, addressChange.parentAddress, lynxModule -> lynxModule.setNewModuleAddress(addressChange.newAddress), 250, TimeUnit.MILLISECONDS);
                            }
                            catch (RobotCoreException | TimeoutException e) {
                                RobotLog.ee((String)FtcEventLoopBase.TAG, (Throwable)e, (String)"failure during module address change");
                                AppUtil.getInstance().showToast(UILocation.BOTH, FtcEventLoopBase.this.activityContext.getString(R.string.toastLynxAddressChangeFailed, new Object[]{addressChange.serialNumber}));
                                success = false;
                                if (e instanceof RobotCoreException) {
                                    throw (RobotCoreException)e;
                                }
                                throw new RobotCoreException("Failed to change module address", e);
                            }
                            finally {
                                if (lynxUsbDevice == null) continue;
                                lynxUsbDevice.close();
                            }
                        }
                    }
                    catch (RobotCoreException robotCoreException) {
                    }
                    finally {
                        FtcEventLoopBase.this.networkConnectionHandler.sendReply(commandRequest, new Command("CMD_LYNX_ADDRESS_CHANGE_FINISHED"));
                        if (success) {
                            AppUtil.getInstance().showToast(UILocation.BOTH, FtcEventLoopBase.this.activityContext.getString(R.string.toastLynxAddressChangeComplete));
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    protected void handleCommandGetCandidateLynxFirmwareImages(Command commandRequest) {
        final Pattern pattern = Pattern.compile("(?i).*\\.bin");
        File firmwareDir = AppUtil.LYNX_FIRMWARE_UPDATE_DIR;
        File[] candidateFiles = firmwareDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                Assert.assertTrue((boolean)pathname.isAbsolute());
                return pattern.matcher(pathname.getName()).matches();
            }
        });
        RobotCoreCommandList.LynxFirmwareImagesResp respParams = new RobotCoreCommandList.LynxFirmwareImagesResp();
        respParams.firstFolder = AppUtil.FIRST_FOLDER;
        for (File candidate : candidateFiles) {
            respParams.firmwareImages.add(new RobotCoreCommandList.FWImage(candidate, false));
        }
        try {
            String[] firmwareAssets;
            File fromBase = new File(firmwareDir.getParentFile().getName(), firmwareDir.getName());
            for (String firmwareAsset : firmwareAssets = this.activityContext.getAssets().list(fromBase.getPath())) {
                if (!pattern.matcher(firmwareAsset).matches()) continue;
                File file = new File(fromBase, firmwareAsset);
                Assert.assertTrue((!file.isAbsolute() ? 1 : 0) != 0);
                respParams.firmwareImages.add(new RobotCoreCommandList.FWImage(file, true));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.networkConnectionHandler.sendReply(commandRequest, new Command("CMD_GET_CANDIDATE_LYNX_FIRMWARE_IMAGES_RESP", respParams.serialize()));
    }

    protected void handleCommandRequestConfigurationTemplates() {
        ArrayList<RobotConfigFile> fileList = this.robotCfgFileMgr.getXMLTemplates();
        String objsSerialized = RobotConfigFileManager.serializeXMLConfigList(fileList);
        this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_CONFIGURATION_TEMPLATES_RESP", objsSerialized));
    }

    protected void handleCommandStartDriverStationProgramAndManage() {
        EventLoopManager eventLoopManager = this.ftcEventLoopHandler.getEventLoopManager();
        if (eventLoopManager != null) {
            WebServer webServer = eventLoopManager.getWebServer();
            String extra = webServer.getConnectionInformation().toJson();
            RobotLog.vv((String)TAG, (String)"sending p&m resp: %s", (Object[])new Object[]{extra});
            this.networkConnectionHandler.sendCommand(new Command("CMD_START_DS_PROGRAM_AND_MANAGE_RESP", extra));
        } else {
            RobotLog.vv((String)TAG, (String)"handleCommandStartDriverStationProgramAndManage() with null EventLoopManager; ignored");
        }
    }

    protected void handleCommandShowDialog(Command command) {
        RobotCoreCommandList.ShowDialog showDialog = RobotCoreCommandList.ShowDialog.deserialize((String)command.getExtra());
        AppUtil.DialogParams params = new AppUtil.DialogParams(UILocation.ONLY_LOCAL, showDialog.title, showDialog.message);
        params.uuidString = showDialog.uuidString;
        AppUtil.getInstance().showDialog(params);
    }

    protected void handleCommandDismissDialog(Command command) {
        AppUtil.getInstance().dismissDialog(UILocation.ONLY_LOCAL, RobotCoreCommandList.DismissDialog.deserialize((String)command.getExtra()));
    }

    protected void handleCommandDismissAllDialogs(Command command) {
        AppUtil.getInstance().dismissAllDialogs(UILocation.ONLY_LOCAL);
    }

    protected void handleCommandShowProgress(Command command) {
        RobotCoreCommandList.ShowProgress showProgress = RobotCoreCommandList.ShowProgress.deserialize((String)command.getExtra());
        AppUtil.getInstance().showProgress(UILocation.ONLY_LOCAL, showProgress.message, (ProgressParameters)showProgress);
    }

    protected void handleCommandDismissProgress(Command command) {
        AppUtil.getInstance().dismissProgress(UILocation.ONLY_LOCAL);
    }

    protected void handleCommandShowToast(Command command) {
        RobotCoreCommandList.ShowToast showToast = RobotCoreCommandList.ShowToast.deserialize((String)command.getExtra());
        AppUtil.getInstance().showToast(UILocation.ONLY_LOCAL, showToast.message, showToast.duration);
    }

    protected void handleCommandRequestInspectionReport() {
        InspectionState inspectionState = new InspectionState();
        inspectionState.initializeLocal();
        String serialized = inspectionState.serialize();
        this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_INSPECTION_REPORT_RESP", serialized));
    }

    protected void handleCommandDisableBluetooth() {
        AppUtil.getInstance().setBluetoothEnabled(false);
    }

    protected void handleCommandRequestAboutInfo(Command command) {
        RobotCoreCommandList.AboutInfo aboutInfo = FtcAboutActivity.getLocalAboutInfo();
        String serialized = aboutInfo.serialize();
        this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_ABOUT_INFO_RESP", serialized));
    }

    protected void handleCommandDisconnectWifiDirect() {
        if (WifiDirectAgent.getInstance().disconnectFromWifiDirect()) {
            AppUtil.getInstance().showToast(UILocation.BOTH, AppUtil.getDefContext().getString(R.string.toastDisconnectedFromWifiDirect));
        } else {
            AppUtil.getInstance().showToast(UILocation.BOTH, AppUtil.getDefContext().getString(R.string.toastErrorDisconnectingFromWifiDirect));
        }
    }

    protected CallbackResult handleCommandVisuallyIdentify(Command command) {
        CommandList.CmdVisuallyIdentify cmdVisuallyIdentify = CommandList.CmdVisuallyIdentify.deserialize(command.getExtra());
        ThreadPool.getDefaultSerial().execute(() -> VisualIdentificationManager.getInstance().handleCommandVisuallyIdentify(cmdVisuallyIdentify));
        return CallbackResult.HANDLED;
    }

    protected CallbackResult handleCommandVisuallyConfirmWifiReset() {
        if (!LynxConstants.isRevControlHub()) {
            return CallbackResult.HANDLED;
        }
        ThreadPool.getDefaultSerial().execute(new Runnable(){

            @Override
            public void run() {
                LynxModule embeddedModule = (LynxModule)EmbeddedControlHubModule.get();
                if (embeddedModule != null) {
                    ArrayList<Blinker.Step> confirmButtonPressPattern = new ArrayList<Blinker.Step>();
                    confirmButtonPressPattern.add(new Blinker.Step(-65281, 100L, TimeUnit.MILLISECONDS));
                    confirmButtonPressPattern.add(new Blinker.Step(-256, 100L, TimeUnit.MILLISECONDS));
                    confirmButtonPressPattern.add(new Blinker.Step(-16711681, 100L, TimeUnit.MILLISECONDS));
                    confirmButtonPressPattern.add(new Blinker.Step(-65536, 100L, TimeUnit.MILLISECONDS));
                    embeddedModule.pushPattern(confirmButtonPressPattern);
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e) {
                        RobotLog.ee((String)FtcEventLoopBase.TAG, (Throwable)e, (String)"Thread interrupted while visually confirming Wi-Fi reset");
                        Thread.currentThread().interrupt();
                    }
                    embeddedModule.popPattern();
                }
            }
        });
        return CallbackResult.HANDLED;
    }

    protected CallbackResult handleCommandVisuallyConfirmWifiBandSwitch(Command command) {
        if (!LynxConstants.isRevControlHub()) {
            return CallbackResult.HANDLED;
        }
        final int newBand = Integer.parseInt(command.getExtra());
        ThreadPool.getDefaultSerial().execute(new Runnable(){

            @Override
            public void run() {
                LynxModule embeddedModule = (LynxModule)EmbeddedControlHubModule.get();
                if (embeddedModule != null) {
                    int bandColor = newBand == 1 ? -65281 : -256;
                    ArrayList<Blinker.Step> confirmBandSwitchPattern = new ArrayList<Blinker.Step>();
                    confirmBandSwitchPattern.add(new Blinker.Step(bandColor, 200L, TimeUnit.MILLISECONDS));
                    confirmBandSwitchPattern.add(new Blinker.Step(-16777216, 100L, TimeUnit.MILLISECONDS));
                    embeddedModule.pushPattern(confirmBandSwitchPattern);
                    try {
                        Thread.sleep(6000L);
                    }
                    catch (InterruptedException e) {
                        RobotLog.ee((String)FtcEventLoopBase.TAG, (Throwable)e, (String)"Thread interrupted while visually confirming Wi-Fi band switch");
                        Thread.currentThread().interrupt();
                    }
                    embeddedModule.popPattern();
                }
            }
        });
        return CallbackResult.HANDLED;
    }
}

