/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.USBAccessibleLynxModule;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.collections.MutableReference;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.stellaris.FlashLoaderManager;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Deadline;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.inspection.R;

public class FtcLynxFirmwareUpdateActivity
extends ThemedActivity {
    public static final String TAG = "FtcLynxFirmwareUpdateActivity";
    protected NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected final String originatorId = UUID.randomUUID().toString();
    protected RecvLoopRunnable.RecvLoopCallback recvLoopCallback = new ReceiveLoopCallback(this.originatorId);
    protected boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
    protected int msResponseWait = 5000;
    protected Map<View, RobotCoreCommandList.FWImage> firmwareImagesMap = new HashMap<View, RobotCoreCommandList.FWImage>();
    protected RobotCoreCommandList.FWImage firmwareImageFile = new RobotCoreCommandList.FWImage(new File(""), false);
    protected List<USBAccessibleLynxModule> modulesToUpdate = new ArrayList<USBAccessibleLynxModule>();
    protected boolean enableUpdateButton = true;
    protected boolean cancelUpdate = false;
    protected BlockingQueue<RobotCoreCommandList.LynxFirmwareImagesResp> availableLynxImages = new ArrayBlockingQueue<RobotCoreCommandList.LynxFirmwareImagesResp>(1);
    protected BlockingQueue<RobotCoreCommandList.USBAccessibleLynxModulesResp> availableLynxModules = new ArrayBlockingQueue<RobotCoreCommandList.USBAccessibleLynxModulesResp>(1);
    protected BlockingQueue<RobotCoreCommandList.LynxFirmwareUpdateResp> availableFWUpdateResps = new ArrayBlockingQueue<RobotCoreCommandList.LynxFirmwareUpdateResp>(1);
    protected View.OnClickListener updateFileClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            FtcLynxFirmwareUpdateActivity.this.firmwareImageFile = FtcLynxFirmwareUpdateActivity.this.firmwareImagesMap.get(v);
        }
    };

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    public static void initializeDirectories() {
        AppUtil.getInstance().ensureDirectoryExists(AppUtil.LYNX_FIRMWARE_UPDATE_DIR);
        String message = AppUtil.getDefContext().getString(R.string.lynxFirmwareUpdateReadme);
        ReadWriteFile.writeFile((File)AppUtil.LYNX_FIRMWARE_UPDATE_DIR, (String)"readme.txt", (String)message);
        message = AppUtil.getDefContext().getString(R.string.robotControllerAppUpdateReadme);
        ReadWriteFile.writeFile((File)AppUtil.RC_APP_UPDATE_DIR, (String)"readme.txt", (String)message);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ftc_lynx_fw_update);
        this.networkConnectionHandler.pushReceiveLoopCallback(this.recvLoopCallback);
    }

    protected void onStart() {
        super.onStart();
        TextView fwFilesHeader = (TextView)this.findViewById(R.id.lynxFirmwareFilesHeader);
        RadioGroup fwFilesGroup = (RadioGroup)this.findViewById(R.id.lynxFirmwareAvailableFilesGroup);
        TextView modulesHeader = (TextView)this.findViewById(R.id.lynxFirmwareHubsHeader);
        LinearLayout modulesLayout = (LinearLayout)this.findViewById(R.id.lynxFirmwareModuleList);
        TextView instructionsPost = (TextView)this.findViewById(R.id.lynxFirmwareInstructionsPost);
        Button button = (Button)this.findViewById(R.id.lynxFirmwareUpdateButton);
        RobotCoreCommandList.LynxFirmwareImagesResp candidateImages = this.getCandidateLynxFirmwareImages();
        if (candidateImages.firmwareImages.isEmpty()) {
            File relativePath = AppUtil.getInstance().getRelativePath(candidateImages.firstFolder.getParentFile(), AppUtil.LYNX_FIRMWARE_UPDATE_DIR);
            modulesHeader.setText((CharSequence)this.getString(R.string.lynx_fw_instructions_no_binary, new Object[]{relativePath}));
            fwFilesHeader.setVisibility(8);
            fwFilesGroup.setVisibility(8);
            modulesLayout.setVisibility(8);
            instructionsPost.setVisibility(8);
            button.setEnabled(false);
        } else {
            Collections.sort(candidateImages.firmwareImages, new Comparator<RobotCoreCommandList.FWImage>(){

                @Override
                public int compare(RobotCoreCommandList.FWImage lhs, RobotCoreCommandList.FWImage rhs) {
                    return -lhs.getName().compareTo(rhs.getName());
                }
            });
            fwFilesGroup.removeAllViews();
            this.firmwareImagesMap.clear();
            boolean isFirstImage = true;
            for (RobotCoreCommandList.FWImage image : candidateImages.firmwareImages) {
                RadioButton imageButton = new RadioButton((Context)this);
                String imageName = image.getName();
                if (image.isAsset) {
                    imageName = imageName + " (bundled)";
                }
                imageButton.setText((CharSequence)imageName);
                imageButton.setOnClickListener(this.updateFileClickListener);
                fwFilesGroup.addView((View)imageButton);
                this.firmwareImagesMap.put((View)imageButton, image);
                if (!isFirstImage) continue;
                isFirstImage = false;
                this.firmwareImageFile = image;
                imageButton.toggle();
            }
            this.modulesToUpdate = this.getLynxModulesForFirmwareUpdate();
            if (this.modulesToUpdate.isEmpty()) {
                modulesHeader.setText(R.string.lynx_fw_instructions_no_devices);
                modulesLayout.setVisibility(8);
                instructionsPost.setVisibility(8);
                button.setEnabled(false);
            } else {
                modulesHeader.setText(R.string.lynx_fw_instructions_update);
                int moduleLayout = 17367044;
                for (USBAccessibleLynxModule module : this.modulesToUpdate) {
                    String title = module.getSerialNumber().isEmbedded() ? AppUtil.getDefContext().getString(R.string.lynx_fw_instructions_controlhub_item_title) : AppUtil.getDefContext().getString(R.string.lynx_fw_instructions_exhub_item_title);
                    String serialNumber = this.getString(R.string.lynx_fw_instructions_serial, new Object[]{module.getSerialNumber()});
                    String moduleAddress = module.getModuleAddress() == 0 ? this.getString(R.string.lynx_fw_instructions_module_address_unavailable) : this.getString(R.string.lynx_fw_instructions_module_address, new Object[]{module.getModuleAddress()});
                    String firmware = this.getString(R.string.lynx_fw_instructions_firmware_version, new Object[]{module.getFinishedFirmwareVersionString()});
                    String description = module.getSerialNumber().isEmbedded() ? serialNumber + "\n" + firmware : (serialNumber = serialNumber + "\n" + moduleAddress + "\n" + firmware);
                    View itemView = LayoutInflater.from((Context)this).inflate(17367044, null);
                    TextView topLine = (TextView)itemView.findViewById(16908308);
                    TextView bottomLine = (TextView)itemView.findViewById(16908309);
                    topLine.setText((CharSequence)title);
                    topLine.setTextSize(18.0f);
                    bottomLine.setText((CharSequence)description);
                    modulesLayout.addView(itemView);
                }
                button.setEnabled(this.enableUpdateButton);
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.networkConnectionHandler.removeReceiveLoopCallback(this.recvLoopCallback);
    }

    public void onUpdateLynxFirmwareClicked(View view) {
        this.enableUpdateButton = false;
        view.setEnabled(this.enableUpdateButton);
        ThreadPool.getDefault().execute(new Runnable(){

            @Override
            public void run() {
                for (USBAccessibleLynxModule module : FtcLynxFirmwareUpdateActivity.this.modulesToUpdate) {
                    String errorMessage;
                    String message;
                    if (FtcLynxFirmwareUpdateActivity.this.cancelUpdate) break;
                    FtcLynxFirmwareUpdateActivity.this.availableFWUpdateResps.clear();
                    RobotLog.vv((String)FtcLynxFirmwareUpdateActivity.TAG, (String)"updating %s with %s", (Object[])new Object[]{module.getSerialNumber(), FtcLynxFirmwareUpdateActivity.this.firmwareImageFile.getName()});
                    RobotCoreCommandList.LynxFirmwareUpdate params = new RobotCoreCommandList.LynxFirmwareUpdate();
                    params.serialNumber = module.getSerialNumber();
                    params.firmwareImageFile = FtcLynxFirmwareUpdateActivity.this.firmwareImageFile;
                    params.originatorId = FtcLynxFirmwareUpdateActivity.this.originatorId;
                    FtcLynxFirmwareUpdateActivity.this.sendOrInject(new Command("CMD_LYNX_FIRMWARE_UPDATE", SimpleGson.getInstance().toJson((Object)params)));
                    MutableReference status = new MutableReference((Object)FwResponseStatus.Succeeded);
                    RobotCoreCommandList.LynxFirmwareUpdateResp respParams = FtcLynxFirmwareUpdateActivity.this.awaitResponse(FtcLynxFirmwareUpdateActivity.this.availableFWUpdateResps, null, FlashLoaderManager.secondsFirmwareUpdateTimeout, TimeUnit.SECONDS, (MutableReference<FwResponseStatus>)status);
                    String deviceString = module.getSerialNumber().isEmbedded() ? AppUtil.getDefContext().getString(R.string.controlHubDisplayName) : AppUtil.getDefContext().getString(R.string.expansionHubDisplayName) + " " + module.getSerialNumber();
                    if (respParams != null && respParams.success) {
                        message = FtcLynxFirmwareUpdateActivity.this.getString(R.string.toastLynxFirmwareUpdateSuccessful, new Object[]{deviceString});
                        RobotLog.vv((String)FtcLynxFirmwareUpdateActivity.TAG, (String)"%s", (Object[])new Object[]{message});
                        AppUtil.getInstance().showToast(UILocation.BOTH, message);
                        continue;
                    }
                    if (status.getValue() == FwResponseStatus.Cancelled) continue;
                    message = respParams == null ? FtcLynxFirmwareUpdateActivity.this.getString(R.string.alertLynxFirmwareUpdateTimedout, new Object[]{deviceString}) : ((errorMessage = respParams.errorMessage) != null && !errorMessage.isEmpty() ? FtcLynxFirmwareUpdateActivity.this.getString(R.string.alertLynxFirmwareUpdateFailedWithReason, new Object[]{deviceString, errorMessage}) : FtcLynxFirmwareUpdateActivity.this.getString(R.string.alertLynxFirmwareUpdateFailed, new Object[]{deviceString}));
                    RobotLog.ee((String)FtcLynxFirmwareUpdateActivity.TAG, (String)"%s", (Object[])new Object[]{message});
                    AppUtil.DialogContext alertDialogContext = AppUtil.getInstance().showAlertDialog(UILocation.BOTH, FtcLynxFirmwareUpdateActivity.this.getString(R.string.alertLynxFirmwareUpdateFailedTitle), message);
                    try {
                        alertDialogContext.dismissed.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
                FtcLynxFirmwareUpdateActivity.this.finish();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        this.cancelUpdate = true;
    }

    protected void onStop() {
        super.onStop();
        AppUtil.getInstance().dismissProgress(UILocation.BOTH);
    }

    protected RobotCoreCommandList.LynxFirmwareImagesResp getCandidateLynxFirmwareImages() {
        RobotCoreCommandList.LynxFirmwareImagesResp result = new RobotCoreCommandList.LynxFirmwareImagesResp();
        this.availableLynxImages.clear();
        this.sendOrInject(new Command("CMD_GET_CANDIDATE_LYNX_FIRMWARE_IMAGES"));
        result = this.awaitResponse(this.availableLynxImages, result);
        RobotLog.vv((String)TAG, (String)"found %d lynx firmware images", (Object[])new Object[]{result.firmwareImages.size()});
        return result;
    }

    protected List<USBAccessibleLynxModule> getLynxModulesForFirmwareUpdate() {
        RobotCoreCommandList.USBAccessibleLynxModulesRequest request = new RobotCoreCommandList.USBAccessibleLynxModulesRequest();
        RobotCoreCommandList.USBAccessibleLynxModulesResp result = new RobotCoreCommandList.USBAccessibleLynxModulesResp();
        this.availableLynxModules.clear();
        request.forFirmwareUpdate = true;
        this.sendOrInject(new Command("CMD_GET_USB_ACCESSIBLE_LYNX_MODULES", request.serialize()));
        result = this.awaitResponse(this.availableLynxModules, result);
        RobotLog.vv((String)TAG, (String)"found %d lynx modules", (Object[])new Object[]{result.modules.size()});
        return result.modules;
    }

    protected void sendOrInject(Command cmd) {
        if (this.remoteConfigure) {
            NetworkConnectionHandler.getInstance().sendCommand(cmd);
        } else {
            NetworkConnectionHandler.getInstance().injectReceivedCommand(cmd);
        }
    }

    protected <T> T awaitResponse(BlockingQueue<T> queue, T defaultResponse) {
        return this.awaitResponse(queue, defaultResponse, this.msResponseWait, TimeUnit.MILLISECONDS, (MutableReference<FwResponseStatus>)new MutableReference((Object)FwResponseStatus.Succeeded));
    }

    protected <T> T awaitResponse(BlockingQueue<T> queue, T defaultResponse, long time, TimeUnit timeUnit, MutableReference<FwResponseStatus> status) {
        try {
            Deadline deadline = new Deadline(time, timeUnit);
            status.setValue((Object)FwResponseStatus.TimedOut);
            while (!deadline.hasExpired()) {
                T cur = queue.poll(100L, TimeUnit.MILLISECONDS);
                if (cur != null) {
                    status.setValue((Object)FwResponseStatus.Succeeded);
                    return cur;
                }
                if (!this.cancelUpdate) continue;
                status.setValue((Object)FwResponseStatus.Cancelled);
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return defaultResponse;
    }

    protected class ReceiveLoopCallback
    extends RecvLoopRunnable.DegenerateCallback {
        final String originatorId;

        public ReceiveLoopCallback(String originatorId) {
            this.originatorId = originatorId;
        }

        public CallbackResult commandEvent(Command command) throws RobotCoreException {
            switch (command.getName()) {
                case "CMD_GET_USB_ACCESSIBLE_LYNX_MODULES_RESP": {
                    RobotCoreCommandList.USBAccessibleLynxModulesResp serialNumbers = RobotCoreCommandList.USBAccessibleLynxModulesResp.deserialize((String)command.getExtra());
                    FtcLynxFirmwareUpdateActivity.this.availableLynxModules.offer(serialNumbers);
                    return CallbackResult.HANDLED_CONTINUE;
                }
                case "CMD_GET_CANDIDATE_LYNX_FIRMWARE_IMAGES_RESP": {
                    RobotCoreCommandList.LynxFirmwareImagesResp candidates = RobotCoreCommandList.LynxFirmwareImagesResp.deserialize((String)command.getExtra());
                    FtcLynxFirmwareUpdateActivity.this.availableLynxImages.offer(candidates);
                    return CallbackResult.HANDLED;
                }
                case "CMD_LYNX_FIRMWARE_UPDATE_RESP": {
                    RobotCoreCommandList.LynxFirmwareUpdateResp params = RobotCoreCommandList.LynxFirmwareUpdateResp.deserialize((String)command.getExtra());
                    if (params.originatorId != null && !params.originatorId.equals(this.originatorId)) break;
                    FtcLynxFirmwareUpdateActivity.this.availableFWUpdateResps.offer(params);
                    return CallbackResult.HANDLED;
                }
            }
            return super.commandEvent(command);
        }
    }

    protected static enum FwResponseStatus {
        Succeeded,
        TimedOut,
        Cancelled;

    }
}

