/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.net.Uri;
import android.preference.PreferenceManager;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import com.qualcomm.ftccommon.CommandList;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.TypeConversion;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.internal.android.SoundPoolIntf;
import org.firstinspires.ftc.robotcore.internal.collections.MutableReference;
import org.firstinspires.ftc.robotcore.internal.network.CallbackLooper;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Deadline;
import org.firstinspires.ftc.robotcore.internal.system.LockingRunner;
import org.firstinspires.ftc.robotcore.internal.system.Misc;
import org.firstinspires.ftc.robotcore.internal.system.RefCounted;
import org.firstinspires.ftc.robotcore.internal.system.Tracer;

public class SoundPlayer
implements SoundPool.OnLoadCompleteListener,
SoundPoolIntf {
    public static final String TAG = "SoundPlayer";
    public static boolean TRACE = true;
    protected Tracer tracer = Tracer.create((String)"SoundPlayer", (boolean)TRACE);
    public static final int msSoundTransmissionFreshness = 400;
    protected final Object lock = new Object();
    protected final LockingRunner cacheLock = new LockingRunner();
    protected final boolean isRobotController = AppUtil.getInstance().isRobotController();
    protected SoundPool soundPool;
    protected CountDownLatch currentlyLoadingLatch = null;
    protected SoundInfo currentlyLoadingInfo = null;
    protected LoadedSoundCache loadedSounds;
    protected ExecutorService threadPool;
    protected ScheduledExecutorService scheduledThreadPool;
    protected SharedPreferences sharedPreferences;
    protected float soundOnVolume = 1.0f;
    protected float soundOffVolume = 0.0f;
    protected float masterVolume = 1.0f;
    protected MediaPlayer mediaSizer = new MediaPlayer();
    protected Set<CurrentlyPlaying> currentlyPlayingSounds;

    public static SoundPlayer getInstance() {
        return InstanceHolder.theInstance;
    }

    public SoundPlayer(int simultaneousStreams, int cacheSize) {
        AudioAttributes.Builder audioAttributesBuilder = new AudioAttributes.Builder();
        audioAttributesBuilder.setUsage(1);
        audioAttributesBuilder.setContentType(4);
        AudioAttributes audioAttributes = audioAttributesBuilder.build();
        SoundPool.Builder soundPoolBuilder = new SoundPool.Builder();
        soundPoolBuilder.setAudioAttributes(audioAttributes);
        soundPoolBuilder.setMaxStreams(simultaneousStreams);
        this.soundPool = soundPoolBuilder.build();
        this.mediaSizer.setAudioAttributes(audioAttributes);
        AudioManager audioManager = (AudioManager)AppUtil.getDefContext().getSystemService("audio");
        int audioSessionId = audioManager.generateAudioSessionId();
        this.mediaSizer.setAudioSessionId(audioSessionId);
        this.loadedSounds = new LoadedSoundCache(cacheSize);
        this.currentlyPlayingSounds = new HashSet<CurrentlyPlaying>();
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)AppUtil.getDefContext());
        final CountDownLatch interlock = new CountDownLatch(1);
        this.threadPool = ThreadPool.newFixedThreadPool((int)1, (String)TAG);
        this.scheduledThreadPool = ThreadPool.newScheduledExecutor((int)1, (String)"SoundPlayerScheduler");
        CallbackLooper.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SoundPlayer.this.soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)SoundPlayer.this);
                interlock.countDown();
            }
        });
        try {
            interlock.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void close() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
            ThreadPool.awaitTerminationOrExitApplication((ExecutorService)this.threadPool, (long)5L, (TimeUnit)TimeUnit.SECONDS, (String)"SoundPool", (String)"internal error");
            this.threadPool = null;
        }
        if (this.scheduledThreadPool != null) {
            this.scheduledThreadPool.shutdownNow();
            ThreadPool.awaitTerminationOrExitApplication((ExecutorService)this.scheduledThreadPool, (long)3L, (TimeUnit)TimeUnit.SECONDS, (String)"SoundPool", (String)"internal error");
        }
        if (this.mediaSizer != null) {
            this.mediaSizer.release();
        }
    }

    public void prefillSoundCache(int ... resourceIds) {
        for (final int resId : resourceIds) {
            this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    SoundPlayer.this.ensureCached((Context)AppUtil.getDefContext(), resId);
                }
            });
        }
    }

    public void startPlaying(Context context, @RawRes int resId) {
        this.startPlaying(context, resId, new PlaySoundParams(true), null, null);
    }

    public void startPlaying(Context context, File file) {
        this.startPlaying(context, file, new PlaySoundParams(true), null, null);
    }

    public void startPlaying(final Context context, final @RawRes int resId, final PlaySoundParams params, final @Nullable Consumer<Integer> runWhenStarted, final @Nullable Runnable runWhenFinished) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                SoundPlayer.this.loadAndStartPlaying(context, resId, params, (Consumer<Integer>)runWhenStarted, runWhenFinished);
            }
        });
    }

    public void startPlaying(final Context context, final File file, final PlaySoundParams params, final @Nullable Consumer<Integer> runWhenStarted, final @Nullable Runnable runWhenFinished) {
        if (file == null) {
            return;
        }
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                SoundPlayer.this.loadAndStartPlaying(context, file, params, (Consumer<Integer>)runWhenStarted, runWhenFinished);
            }
        });
    }

    public void stopPlayingAll() {
        this.internalStopPlaying(StopWhat.All);
    }

    public void stopPlayingLoops() {
        this.internalStopPlaying(StopWhat.Loops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStopPlaying(StopWhat stopWhat) {
        Object object = this.lock;
        synchronized (object) {
            for (CurrentlyPlaying currentlyPlaying : this.currentlyPlayingSounds) {
                if (stopWhat != StopWhat.All && (!currentlyPlaying.isLooping() || stopWhat != StopWhat.Loops)) continue;
                currentlyPlaying.msFinish = Long.MIN_VALUE;
            }
            this.checkForFinishedSounds();
            if (this.isRobotController) {
                CommandList.CmdStopPlayingSounds cmdStopPlayingSounds = new CommandList.CmdStopPlayingSounds(stopWhat);
                Command command = new Command("CMD_PLAY_SOUND", cmdStopPlayingSounds.serialize());
                NetworkConnectionHandler.getInstance().sendCommand(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preload(Context context, @RawRes int resourceId) {
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            SoundInfo soundInfo = this.ensureLoaded(context, resourceId);
            if (soundInfo != null) {
                result = true;
                SoundPlayer.releaseRef(soundInfo);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preload(Context context, File file) {
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            SoundInfo soundInfo = this.ensureLoaded(context, file);
            if (soundInfo != null) {
                result = true;
                SoundPlayer.releaseRef(soundInfo);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterVolume(float masterVolume) {
        Object object = this.lock;
        synchronized (object) {
            this.masterVolume = masterVolume;
        }
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    @Deprecated
    public void play(Context context, @RawRes int resId) {
        this.startPlaying(context, resId);
    }

    @Deprecated
    public void play(Context context, @RawRes int resId, boolean waitForCompletion) {
        this.startPlaying(context, resId, new PlaySoundParams(waitForCompletion), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAndStartPlaying(Context context, @RawRes int resourceId, PlaySoundParams params, @Nullable Consumer<Integer> runWhenStarted, @Nullable Runnable runWhenFinished) {
        Object object = this.lock;
        synchronized (object) {
            SoundInfo soundInfo = this.ensureLoaded(context, resourceId);
            if (soundInfo != null) {
                this.startPlayingLoadedSound(soundInfo, params, runWhenStarted, runWhenFinished);
                SoundPlayer.releaseRef(soundInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAndStartPlaying(Context context, File file, PlaySoundParams params, @Nullable Consumer<Integer> runWhenStarted, @Nullable Runnable runWhenFinished) {
        Object object = this.lock;
        synchronized (object) {
            SoundInfo soundInfo = this.ensureLoaded(context, file);
            if (soundInfo != null) {
                this.startPlayingLoadedSound(soundInfo, params, runWhenStarted, runWhenFinished);
                SoundPlayer.releaseRef(soundInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SoundInfo ensureLoaded(Context context, @RawRes int resourceId) {
        Object object = this.lock;
        synchronized (object) {
            SoundInfo result = this.loadedSounds.getResource(resourceId);
            if (result == null) {
                int msDuration = this.getMsDuration(context, resourceId);
                this.currentlyLoadingLatch = new CountDownLatch(1);
                this.currentlyLoadingInfo = result = new SoundInfo(context, resourceId, msDuration);
                int sampleId = this.soundPool.load(context, resourceId, 1);
                if (sampleId != 0) {
                    result.initialize(sampleId);
                    this.loadedSounds.putResource(resourceId, result);
                    this.waitForLoadCompletion();
                } else {
                    this.tracer.traceError("unable to load sound resource 0x%08x", new Object[]{resourceId});
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SoundInfo ensureLoaded(Context context, File file) {
        Object object = this.lock;
        synchronized (object) {
            SoundInfo result = this.loadedSounds.getFile(file);
            if (result == null) {
                int msDuration = this.getMsDuration(context, file);
                this.currentlyLoadingLatch = new CountDownLatch(1);
                this.currentlyLoadingInfo = result = new SoundInfo(file, msDuration);
                int sampleId = this.soundPool.load(file.getAbsolutePath(), 1);
                if (sampleId != 0) {
                    result.initialize(sampleId);
                    this.loadedSounds.putFile(file, result);
                    this.waitForLoadCompletion();
                } else {
                    this.tracer.traceError("unable to load sound %s", new Object[]{file});
                }
            }
            return result;
        }
    }

    public boolean isLocalSoundOn() {
        return this.sharedPreferences.getBoolean(AppUtil.getDefContext().getString(R.string.pref_sound_on_off), true) && this.sharedPreferences.getBoolean(AppUtil.getDefContext().getString(R.string.pref_has_speaker), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForFinishedSounds() {
        Object object = this.lock;
        synchronized (object) {
            long msNow = this.getMsNow();
            for (CurrentlyPlaying currentlyPlaying : new ArrayList<CurrentlyPlaying>(this.currentlyPlayingSounds)) {
                if (currentlyPlaying.msFinish > msNow) continue;
                this.soundPool.stop(currentlyPlaying.streamId);
                if (currentlyPlaying.runWhenFinished != null) {
                    this.threadPool.execute(currentlyPlaying.runWhenFinished);
                }
                this.currentlyPlayingSounds.remove(currentlyPlaying);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPlayingLoadedSound(final SoundInfo soundInfo, @Nullable PlaySoundParams paramsIn, final @Nullable Consumer<Integer> runWhenStarted, final @Nullable Runnable runWhenFinished) {
        final PlaySoundParams params = paramsIn == null ? new PlaySoundParams() : new PlaySoundParams(paramsIn);
        params.volume *= this.masterVolume;
        if (soundInfo != null) {
            Object object = this.lock;
            synchronized (object) {
                SoundPlayer.addRef(soundInfo);
                this.loadedSounds.noteSoundUsage(soundInfo);
                boolean soundOn = this.isLocalSoundOn();
                final float volume = (soundOn ? this.soundOnVolume : this.soundOffVolume) * params.volume;
                this.checkForFinishedSounds();
                long msNow = this.getMsNow();
                long msFinishNonLoopers = Long.MIN_VALUE;
                for (CurrentlyPlaying currentlyPlaying : this.currentlyPlayingSounds) {
                    if (currentlyPlaying.isLooping()) continue;
                    msFinishNonLoopers = Math.max(msFinishNonLoopers, currentlyPlaying.msFinish);
                }
                final long msPresentation = params.waitForNonLoopingSoundsToFinish ? Math.max(msNow, msFinishNonLoopers) : msNow;
                long msDelay = msPresentation - msNow;
                Runnable playSound = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SoundPlayer.this.lock;
                        synchronized (object) {
                            boolean result;
                            long msStart = SoundPlayer.this.getMsNow();
                            final int streamId = SoundPlayer.this.soundPool.play(soundInfo.sampleId, volume, volume, 1, params.loopControl, params.rate);
                            boolean bl = result = 0 != streamId;
                            if (result) {
                                long msDuration = soundInfo.msDuration * (long)(params.isLooping() ? 1 : params.loopControl + 1);
                                CurrentlyPlaying currentlyPlaying = new CurrentlyPlaying();
                                currentlyPlaying.streamId = streamId;
                                currentlyPlaying.loopControl = params.loopControl;
                                currentlyPlaying.msFinish = params.isLooping() ? Long.MAX_VALUE : msStart + msDuration;
                                currentlyPlaying.runWhenFinished = runWhenFinished;
                                SoundPlayer.this.currentlyPlayingSounds.add(currentlyPlaying);
                                if (runWhenFinished != null && !params.isLooping()) {
                                    SoundPlayer.this.scheduledThreadPool.schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            SoundPlayer.this.checkForFinishedSounds();
                                        }
                                    }, msDuration + (long)(5 * (params.loopControl + 1)), TimeUnit.MILLISECONDS);
                                }
                                SoundPlayer.this.tracer.trace("playing volume=%f %s", new Object[]{Float.valueOf(volume), soundInfo});
                                soundInfo.msLastPlay = msStart;
                            } else {
                                SoundPlayer.this.tracer.traceError("unable to play %s", new Object[]{soundInfo});
                            }
                            SoundPlayer.releaseRef(soundInfo);
                            if (runWhenStarted != null) {
                                SoundPlayer.this.threadPool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        runWhenStarted.accept((Object)streamId);
                                    }
                                });
                            }
                        }
                        if (SoundPlayer.this.isRobotController) {
                            CommandList.CmdPlaySound cmdPlaySound = new CommandList.CmdPlaySound(msPresentation, soundInfo.hashString, params);
                            Command command = new Command("CMD_PLAY_SOUND", cmdPlaySound.serialize());
                            command.setTransmissionDeadline(new Deadline(400L, TimeUnit.MILLISECONDS));
                            NetworkConnectionHandler.getInstance().sendCommand(command);
                        }
                    }
                };
                if (msDelay > 0L) {
                    this.scheduledThreadPool.schedule(playSound, msDelay, TimeUnit.MILLISECONDS);
                } else {
                    playSound.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMsDuration(Context context, @RawRes int resourceId) {
        int msDuration = 0;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.mediaSizer.reset();
                AssetFileDescriptor afd = context.getResources().openRawResourceFd(resourceId);
                this.mediaSizer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                afd.close();
                this.mediaSizer.prepare();
                msDuration = this.mediaSizer.getDuration();
            }
            catch (IOException e) {
                this.tracer.traceError((Throwable)e, "exception preparing media sizer; media duration taken to be zero", new Object[0]);
            }
        }
        return msDuration < 0 ? 0 : msDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMsDuration(Context context, File file) {
        Uri uri = Uri.fromFile((File)file);
        int msDuration = 0;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.mediaSizer.reset();
                this.mediaSizer.setDataSource(context, uri);
                this.mediaSizer.prepare();
                msDuration = this.mediaSizer.getDuration();
            }
            catch (IOException e) {
                this.tracer.traceError((Throwable)e, "exception preparing media sizer; media duration taken to be zero", new Object[0]);
            }
        }
        return msDuration < 0 ? 0 : msDuration;
    }

    protected void waitForLoadCompletion() {
        try {
            this.currentlyLoadingLatch.await();
            this.currentlyLoadingLatch = null;
            this.currentlyLoadingInfo = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
        this.tracer.trace("onLoadComplete(%s, samp=%d)=%d", new Object[]{this.currentlyLoadingInfo, sampleId, status});
        this.currentlyLoadingLatch.countDown();
    }

    protected long getMsNow() {
        return AppUtil.getInstance().getWallClockTime();
    }

    @CheckResult
    protected SoundInfo ensureLoaded(String hashString, SoundFromFile ifAbsent) {
        SoundInfo soundInfo = this.loadedSounds.getHash(hashString);
        if (soundInfo != null) {
            return soundInfo;
        }
        return this.ensureCached(hashString, ifAbsent);
    }

    protected void ensureCached(Context context, @RawRes int resId) {
        String hashString;
        SoundInfo cachedSoundInfo;
        final SoundInfo soundInfo = this.ensureLoaded(context, resId);
        if (soundInfo != null && (cachedSoundInfo = this.ensureCached(hashString = soundInfo.hashString, new SoundFromFile(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoundInfo apply(File file) {
                InputStream inputStream = soundInfo.getInputStream();
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(file);
                    SoundPlayer.copy(inputStream, outputStream, soundInfo.cbSize);
                }
                catch (IOException e) {
                    SoundPlayer.this.tracer.traceError((Throwable)e, "exception caching file: %s", new Object[]{file});
                }
                finally {
                    SoundPlayer.this.safeClose(outputStream);
                    SoundPlayer.this.safeClose(inputStream);
                }
                return null;
            }
        })) != null) {
            SoundPlayer.releaseRef(cachedSoundInfo);
        }
    }

    @CheckResult
    protected SoundInfo ensureCached(final String hashString, final SoundFromFile ifAbsent) {
        final MutableReference result = new MutableReference(null);
        AppUtil.getInstance().ensureDirectoryExists(AppUtil.SOUNDS_CACHE, false);
        try {
            this.cacheLock.lockWhile(new Runnable(){

                @Override
                public void run() {
                    SoundInfo soundInfo;
                    boolean success = false;
                    File file = new File(AppUtil.SOUNDS_CACHE, hashString + ".sound");
                    if (file.exists() && (soundInfo = SoundPlayer.this.ensureLoaded((Context)AppUtil.getDefContext(), file)) != null) {
                        result.setValue((Object)soundInfo);
                        success = true;
                    }
                    if (!success) {
                        result.setValue((Object)ifAbsent.apply(file));
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (SoundInfo)((Object)result.getValue());
    }

    public CallbackResult handleCommandPlaySound(String extra) {
        CallbackResult callbackResult = CallbackResult.HANDLED;
        final CommandList.CmdPlaySound cmdPlaySound = CommandList.CmdPlaySound.deserialize(extra);
        SoundInfo soundInfo = this.ensureLoaded(cmdPlaySound.hashString, new SoundFromFile(){

            @Override
            public SoundInfo apply(File file) {
                return SoundPlayer.this.requestRemoteSound(file, cmdPlaySound.hashString);
            }
        });
        if (soundInfo != null) {
            long msPresentation = RobotLog.getLocalTime((long)cmdPlaySound.msPresentationTime);
            long msNow = this.getMsNow();
            long msDelay = msPresentation - msNow;
            this.startPlayingLoadedSound(soundInfo, cmdPlaySound.getParams(), null, null);
            SoundPlayer.releaseRef(soundInfo);
        }
        return callbackResult;
    }

    public CallbackResult handleCommandStopPlayingSounds(Command stopPlayingSoundsCommand) {
        String extra = stopPlayingSoundsCommand.getExtra();
        CallbackResult callbackResult = CallbackResult.HANDLED;
        CommandList.CmdStopPlayingSounds cmdStopPlayingSounds = CommandList.CmdStopPlayingSounds.deserialize(extra);
        this.tracer.trace("handleCommandStopPlayingSounds(): what=%s", new Object[]{cmdStopPlayingSounds.stopWhat});
        this.internalStopPlaying(cmdStopPlayingSounds.stopWhat);
        return callbackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SoundInfo requestRemoteSound(File file, String hashString) {
        SoundInfo result;
        block13: {
            result = null;
            FileOutputStream outputStream = null;
            ServerSocket serverSocket = null;
            Socket clientSocket = null;
            InputStream inputStream = null;
            boolean deleteFile = true;
            try {
                block12: {
                    outputStream = new FileOutputStream(file);
                    serverSocket = new ServerSocket(0);
                    CommandList.CmdRequestSound cmdRequestSound = new CommandList.CmdRequestSound(hashString, serverSocket.getLocalPort());
                    this.tracer.trace("handleCommandPlaySound(): requesting: port=%d hash=%s", new Object[]{cmdRequestSound.port, cmdRequestSound.hashString});
                    NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_REQUEST_SOUND", cmdRequestSound.serialize()));
                    int msTimeout = 1000;
                    serverSocket.setSoTimeout(1000);
                    try {
                        clientSocket = serverSocket.accept();
                        clientSocket.setSoTimeout(1000);
                        inputStream = clientSocket.getInputStream();
                        byte[] buffer = new byte[4];
                        if (buffer.length == inputStream.read(buffer)) {
                            int cbToRead = TypeConversion.byteArrayToInt((byte[])buffer);
                            if (cbToRead > 0) {
                                SoundPlayer.copy(inputStream, outputStream, cbToRead);
                                this.safeClose(outputStream);
                                outputStream = null;
                                deleteFile = false;
                                this.tracer.trace("handleCommandPlaySound(): received: hash=%s", new Object[]{hashString});
                                result = this.ensureLoaded((Context)AppUtil.getDefContext(), file);
                            } else {
                                this.tracer.traceError("handleCommandPlaySound(): client couldn't send sound", new Object[0]);
                            }
                            break block12;
                        }
                        throw new IOException("framing error");
                    }
                    catch (SocketTimeoutException e) {
                        this.tracer.traceError("timed out awaiting sound file", new Object[0]);
                    }
                }
                this.safeClose(inputStream);
            }
            catch (IOException | RuntimeException e) {
                this.tracer.traceError((Throwable)e, "handleCommandPlaySound(): exception thrown", new Object[0]);
                break block13;
            }
            finally {
                this.safeClose(inputStream);
                this.safeClose(clientSocket);
                this.safeClose(serverSocket);
                this.safeClose(outputStream);
                if (deleteFile) {
                    file.delete();
                }
            }
            this.safeClose(clientSocket);
            this.safeClose(serverSocket);
            this.safeClose(outputStream);
            if (deleteFile) {
                file.delete();
            }
        }
        return result;
    }

    protected static void copy(InputStream inputStream, OutputStream outputStream, int cbToCopy) throws IOException {
        block2: {
            int cbRead;
            if (cbToCopy <= 0) break block2;
            byte[] buffer = new byte[256];
            do {
                if ((cbRead = inputStream.read(buffer)) < 0) {
                    throw new IOException("insufficient data");
                }
                outputStream.write(buffer, 0, cbRead);
            } while ((cbToCopy -= cbRead) > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallbackResult handleCommandRequestSound(Command requestSoundCommand) {
        String extra = requestSoundCommand.getExtra();
        CallbackResult callbackResult = CallbackResult.HANDLED;
        CommandList.CmdRequestSound cmdRequestSound = CommandList.CmdRequestSound.deserialize(extra);
        this.tracer.trace("handleCommandRequestSound(): hash=%s", new Object[]{cmdRequestSound.hashString});
        Socket socket = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            socket = new Socket(requestSoundCommand.getSender().getAddress(), cmdRequestSound.port);
            outputStream = socket.getOutputStream();
            SoundInfo soundInfo = this.loadedSounds.getHash(cmdRequestSound.hashString);
            if (soundInfo != null) {
                inputStream = soundInfo.getInputStream();
            } else {
                this.tracer.traceError("handleCommandRequestSound(): can't find hash=%s", new Object[]{cmdRequestSound.hashString});
            }
            if (inputStream != null) {
                int cbRead;
                outputStream.write(TypeConversion.intToByteArray((int)soundInfo.cbSize));
                byte[] buffer = new byte[256];
                int cbWritten = 0;
                while ((cbRead = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, cbRead);
                    cbWritten += cbRead;
                }
                this.tracer.trace("handleCommandRequestSound(): finished: %s cbSize=%d cbWritten=%d", new Object[]{soundInfo, soundInfo.cbSize, cbWritten});
            } else {
                outputStream.write(TypeConversion.intToByteArray((int)0));
            }
            SoundPlayer.releaseRef(soundInfo);
        }
        catch (IOException | RuntimeException e) {
            try {
                this.tracer.traceError((Throwable)e, "handleCommandRequestSound(): exception thrown", new Object[0]);
                this.safeClose(inputStream);
                this.safeClose(outputStream);
                this.safeClose(socket);
            }
            catch (Throwable throwable) {
                this.safeClose(inputStream);
                this.safeClose(outputStream);
                this.safeClose(socket);
                throw throwable;
            }
        }
        this.safeClose(inputStream);
        this.safeClose(outputStream);
        this.safeClose(socket);
        return callbackResult;
    }

    protected void safeClose(Object closeable) {
        if (closeable != null) {
            try {
                if (closeable instanceof Flushable) {
                    try {
                        ((Flushable)closeable).flush();
                    }
                    catch (IOException e) {
                        this.tracer.traceError((Throwable)e, "exception while flushing", new Object[0]);
                    }
                }
                if (!(closeable instanceof Closeable)) {
                    throw new IllegalArgumentException("Unknown object to close");
                }
                ((Closeable)closeable).close();
            }
            catch (IOException e) {
                this.tracer.traceError((Throwable)e, "exception while closing", new Object[0]);
            }
        }
    }

    public static SoundInfo addRef(SoundInfo soundInfo) {
        if (soundInfo != null) {
            soundInfo.addRef();
        }
        return soundInfo;
    }

    public static void releaseRef(SoundInfo soundInfo) {
        if (soundInfo != null) {
            soundInfo.releaseRef();
        }
    }

    public void play(Context context, @RawRes int resourceId, float volume, int loop, float rate) {
        PlaySoundParams params = new PlaySoundParams(false);
        params.volume = volume;
        params.loopControl = loop;
        params.rate = rate;
        this.startPlaying(context, resourceId, params, null, null);
    }

    public void play(Context context, File file, float volume, int loop, float rate) {
        PlaySoundParams params = new PlaySoundParams(false);
        params.volume = volume;
        params.loopControl = loop;
        params.rate = rate;
        this.startPlaying(context, file, params, null, null);
    }

    protected class LoadedSoundCache {
        private final Object lock = new Object();
        private final int capacity;
        private boolean unloadOnRemove;
        private final Map<Object, SoundInfo> keyMap;
        private final Map<String, SoundInfo> hashMap;

        LoadedSoundCache(int capacity) {
            this.keyMap = new SoundInfoMap<Object>(capacity);
            this.hashMap = new SoundInfoMap<String>(capacity);
            this.capacity = capacity;
            this.unloadOnRemove = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckResult
        public SoundInfo getResource(@RawRes int resourceId) {
            Object object = this.lock;
            synchronized (object) {
                return SoundPlayer.addRef(this.keyMap.get(resourceId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckResult
        public SoundInfo getFile(File file) {
            Object object = this.lock;
            synchronized (object) {
                return SoundPlayer.addRef(this.keyMap.get(file.getAbsoluteFile()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckResult
        public SoundInfo getHash(String hashString) {
            Object object = this.lock;
            synchronized (object) {
                return SoundPlayer.addRef(this.hashMap.get(hashString));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putResource(@RawRes int resourceId, SoundInfo info) {
            Object object = this.lock;
            synchronized (object) {
                this.keyMap.put(resourceId, SoundPlayer.addRef(info));
                this.hashMap.put(info.hashString, SoundPlayer.addRef(info));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putFile(File file, SoundInfo info) {
            Object object = this.lock;
            synchronized (object) {
                this.keyMap.put(file.getAbsoluteFile(), SoundPlayer.addRef(info));
                this.hashMap.put(info.hashString, SoundPlayer.addRef(info));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noteSoundUsage(SoundInfo info) {
            Object object = this.lock;
            synchronized (object) {
                this.unloadOnRemove = false;
                try {
                    Object key = info.getKey();
                    this.keyMap.remove(key);
                    this.keyMap.put(key, info);
                    this.hashMap.remove(info.hashString);
                    this.hashMap.put(info.hashString, info);
                }
                finally {
                    this.unloadOnRemove = true;
                }
            }
        }

        class SoundInfoMap<K>
        extends LinkedHashMap<K, SoundInfo> {
            private static final float loadFactor = 0.75f;

            public SoundInfoMap(int capacity) {
                super((int)Math.ceil((float)capacity / 0.75f) + 1, 0.75f, true);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, SoundInfo> eldest) {
                return this.size() > LoadedSoundCache.this.capacity;
            }

            @Override
            public SoundInfo remove(Object key) {
                SoundInfo removed = (SoundInfo)((Object)super.remove(key));
                if (LoadedSoundCache.this.unloadOnRemove && removed != null) {
                    SoundPlayer.releaseRef(removed);
                }
                return removed;
            }
        }
    }

    protected class SoundInfo
    extends RefCounted {
        public final Context context;
        @RawRes
        public final int resourceId;
        public final File file;
        public final long msDuration;
        public int sampleId;
        public String hashString;
        public int cbSize;
        public long msLastPlay = 0L;

        public String toString() {
            return Misc.formatInvariant((String)"samp=%d|ms=%d", (Object[])new Object[]{this.sampleId, this.msDuration});
        }

        public SoundInfo(@RawRes Context context, int resourceId, int msDuration) {
            this.context = context;
            this.resourceId = resourceId;
            this.file = null;
            this.msDuration = msDuration;
            this.hashString = this.computeHash();
        }

        public SoundInfo(File file, int msDuration) {
            this.context = null;
            this.resourceId = 0;
            this.file = file;
            this.msDuration = msDuration;
            this.hashString = this.computeHash();
        }

        public void initialize(int sampleId) {
            this.sampleId = sampleId;
            this.hashString = this.computeHash();
        }

        protected void destructor() {
            SoundPlayer.this.tracer.trace("unloading sound %s", new Object[]{this});
            SoundPlayer.this.soundPool.unload(this.sampleId);
            super.destructor();
        }

        @Nullable
        public InputStream getInputStream() {
            try {
                if (this.resourceId != 0) {
                    return this.context.getResources().openRawResource(this.resourceId);
                }
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String computeHash() {
            InputStream inputStream = this.getInputStream();
            if (inputStream != null) {
                try {
                    int cbRead;
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    byte[] buffer = new byte[256];
                    this.cbSize = 0;
                    while ((cbRead = inputStream.read(buffer)) >= 0) {
                        this.cbSize += cbRead;
                        digest.update(buffer, 0, cbRead);
                    }
                    byte[] hash = digest.digest();
                    StringBuilder result = new StringBuilder();
                    for (int ib = 0; ib < hash.length; ++ib) {
                        result.append(String.format(Locale.ROOT, "%02x", hash[ib]));
                    }
                    String string2 = result.toString();
                    return string2;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    SoundPlayer.this.tracer.traceError((Throwable)e, "exception computing hash", new Object[0]);
                }
                finally {
                    SoundPlayer.this.safeClose(inputStream);
                }
            }
            throw Misc.illegalStateException((String)"internal error: unable to compute hash of %s", (Object[])new Object[]{this});
        }

        public Object getKey() {
            return this.resourceId == 0 ? this.file : Integer.valueOf(this.resourceId);
        }
    }

    protected static interface SoundFromFile {
        public SoundInfo apply(File var1);
    }

    public static class PlaySoundParams {
        public float volume = 1.0f;
        public boolean waitForNonLoopingSoundsToFinish = true;
        public int loopControl = 0;
        public float rate = 1.0f;

        public PlaySoundParams() {
        }

        public PlaySoundParams(boolean wait) {
            this.waitForNonLoopingSoundsToFinish = wait;
        }

        public PlaySoundParams(PlaySoundParams them) {
            this.volume = them.volume;
            this.waitForNonLoopingSoundsToFinish = them.waitForNonLoopingSoundsToFinish;
            this.loopControl = them.loopControl;
            this.rate = them.rate;
        }

        public boolean isLooping() {
            return this.loopControl == -1;
        }
    }

    protected static enum StopWhat {
        All,
        Loops;

    }

    protected static class CurrentlyPlaying {
        protected long msFinish = Long.MAX_VALUE;
        protected int streamId = 0;
        protected int loopControl = 0;
        @Nullable
        protected Runnable runWhenFinished = null;

        protected CurrentlyPlaying() {
        }

        protected boolean isLooping() {
            return this.loopControl == -1;
        }
    }

    protected static class InstanceHolder {
        public static SoundPlayer theInstance = new SoundPlayer(3, 8);

        protected InstanceHolder() {
        }
    }
}

