/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;

public class StackTraceActivity
extends Activity {
    public static final String KEY_STACK_TRACE = "KEY_STACK_TRACE";
    WebView webView;

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.activity_stacktrace);
        TextView headerErrorMessage = (TextView)this.findViewById(R.id.header_error_message);
        String stackTrace = this.getIntent().getExtras().getString(KEY_STACK_TRACE);
        headerErrorMessage.setText((CharSequence)stackTrace.substring(0, stackTrace.indexOf("\n")));
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setDisplayZoomControls(false);
        this.webView.setBackgroundColor(this.getResources().getColor(R.color.logviewer_bgcolor));
        String html = String.format("<span style='white-space: nowrap;'><font face='monospace' color='white'><pre>%s</pre></font></span>", stackTrace.replace("\n", "<br>").replace("\t", "    "));
        this.webView.loadData(html, "text/html", "UTF-8");
    }

    public void onAccept(View v) {
        this.finish();
    }

    public void onZoomIn(View v) {
        this.webView.zoomIn();
    }

    public void onZoomOut(View v) {
        this.webView.zoomOut();
    }
}

