/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.ConfigurationTypeArrayAdapter;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.RobotConfigMap;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.configuration.BuiltInConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationUtility;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.Utility;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;

public abstract class EditActivity
extends ThemedActivity {
    public static final String TAG = "EditActivity";
    protected Context context;
    protected AppUtil appUtil = AppUtil.getInstance();
    protected boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
    protected Utility utility;
    protected ConfigurationUtility configurationUtility;
    protected RobotConfigFileManager robotConfigFileManager;
    protected RobotConfigFile currentCfgFile;
    @IdRes
    protected int idAddButton = R.id.addButton;
    @IdRes
    protected int idFixButton = R.id.fixButton;
    @IdRes
    protected int idSwapButton = R.id.swapButton;
    protected ControllerConfiguration controllerConfiguration;
    protected RobotConfigMap robotConfigMap = new RobotConfigMap();
    protected boolean haveRobotConfigMapParameter = false;
    @NonNull
    protected ScannedDevices scannedDevices = new ScannedDevices();
    protected List<RobotConfigFile> extantRobotConfigurations = new LinkedList<RobotConfigFile>();
    protected AdapterView.OnItemSelectedListener spinnerListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView<?> parent, View spinnerItem, int pos, long l) {
            ConfigurationTypeAndDisplayName selected = (ConfigurationTypeAndDisplayName)parent.getItemAtPosition(pos);
            View itemView = this.itemViewFromSpinnerItem(spinnerItem);
            if (selected.configurationType == BuiltInConfigurationType.NOTHING) {
                EditActivity.this.clearDevice(itemView);
            } else {
                EditActivity.this.changeDevice(itemView, selected.configurationType);
            }
        }

        protected View itemViewFromSpinnerItem(View spinnerItem) {
            ViewParent spinner = spinnerItem.getParent();
            ViewParent spinnerParent = spinner.getParent();
            ViewParent spinnerParentParent = spinnerParent.getParent();
            View itemView = (View)spinnerParentParent;
            return itemView;
        }

        public void onNothingSelected(AdapterView<?> adapterView) {
        }
    };

    public String getTag() {
        return TAG;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        PreferenceManager.setDefaultValues((Context)this, (int)R.xml.app_settings, (boolean)false);
        this.utility = new Utility((Activity)this);
        this.configurationUtility = new ConfigurationUtility();
        this.robotConfigFileManager = new RobotConfigFileManager((Activity)this);
        this.currentCfgFile = this.robotConfigFileManager.getActiveConfig();
    }

    protected void onStart() {
        super.onStart();
        this.robotConfigFileManager.updateActiveConfigHeader(this.currentCfgFile);
    }

    protected void deserialize(EditParameters parameters) {
        this.scannedDevices = parameters.getScannedDevices();
        this.extantRobotConfigurations = parameters.getExtantRobotConfigurations();
        ControllerConfiguration controllerConfiguration = this.controllerConfiguration = parameters.getConfiguration() instanceof ControllerConfiguration ? (ControllerConfiguration)parameters.getConfiguration() : null;
        if (parameters.getCurrentCfgFile() != null) {
            this.currentCfgFile = parameters.getCurrentCfgFile();
        }
        this.deserializeConfigMap(parameters);
    }

    protected void deserializeConfigMap(EditParameters parameters) {
        this.robotConfigMap = new RobotConfigMap(parameters.getRobotConfigMap());
        this.haveRobotConfigMapParameter = parameters.haveRobotConfigMapParameter();
        if (this.robotConfigMap != null && this.controllerConfiguration != null && this.robotConfigMap.contains(this.controllerConfiguration.getSerialNumber())) {
            this.controllerConfiguration = this.robotConfigMap.get(this.controllerConfiguration.getSerialNumber());
        }
    }

    protected RobotConfigMap getRobotConfigMap() {
        return this.robotConfigMap == null ? new RobotConfigMap() : this.robotConfigMap;
    }

    protected void handleLaunchEdit(RequestCode requestCode, Class launchClass, List<DeviceConfiguration> currentItems) {
        this.handleLaunchEdit(requestCode, launchClass, new EditParameters<DeviceConfiguration>(this, DeviceConfiguration.class, currentItems));
    }

    protected void handleLaunchEdit(RequestCode requestCode, Class launchClass, DeviceConfiguration config) {
        this.handleLaunchEdit(requestCode, launchClass, new EditParameters(this, config));
    }

    protected void handleLaunchEdit(RequestCode requestCode, Class launchClass, EditParameters parameters) {
        this.handleLaunchEdit(requestCode, launchClass, parameters.toBundle());
    }

    private void handleLaunchEdit(RequestCode requestCode, Class launchClass, Bundle bundle) {
        Intent editIntent = new Intent(this.context, launchClass);
        editIntent.putExtras(bundle);
        this.setResult(-1, editIntent);
        RobotLog.v((String)"%s: starting activity %s code=%d", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), editIntent.getComponent().getShortClassName(), requestCode.value});
        this.startActivityForResult(editIntent, requestCode.value);
    }

    public static String formatSerialNumber(Context context, ControllerConfiguration controllerConfiguration) {
        String result = controllerConfiguration.getSerialNumber().toString();
        if (controllerConfiguration.getSerialNumber().isFake()) {
            return result;
        }
        if (!controllerConfiguration.isKnownToBeAttached()) {
            result = result + context.getString(R.string.serialNumberNotAttached);
        }
        return result;
    }

    protected void finishCancel() {
        RobotLog.v((String)"%s: cancelling", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        this.setResult(0, new Intent());
        this.finish();
    }

    protected void finishOk(EditParameters parameters) {
        RobotLog.v((String)"%s: OK", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        Intent returnIntent = new Intent();
        parameters.putIntent(returnIntent);
        this.finishOk(returnIntent);
    }

    protected void finishOk() {
        this.finishOk(new Intent());
    }

    protected void finishOk(Intent intent) {
        this.setResult(-1, intent);
        this.finish();
    }

    public void onBackPressed() {
        this.logBackPressed();
        this.finishOk();
    }

    protected void logActivityResult(int requestCodeValue, int resultCode, Intent data) {
        RobotLog.v((String)"%s: activity result: code=%d result=%d", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), requestCodeValue, resultCode});
    }

    protected void logBackPressed() {
        RobotLog.v((String)"%s: backPressed received", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
    }

    protected void clearNameIfNecessary(EditText nameText, DeviceConfiguration device) {
        if (!device.isEnabled()) {
            nameText.setText((CharSequence)"");
            device.setName("");
        } else {
            nameText.setText((CharSequence)device.getName());
        }
    }

    public String disabledDeviceName() {
        return this.getString(R.string.noDeviceAttached);
    }

    public String nameOf(DeviceConfiguration config) {
        return this.nameOf(config.getName());
    }

    public String nameOf(String name) {
        if (name.equals("NO$DEVICE$ATTACHED")) {
            name = this.getString(R.string.noDeviceAttached);
        }
        return name;
    }

    protected void localizeConfigTypeSpinnerTypes(Spinner spinner, SortedSet<ConfigurationType> types) {
        ConfigurationTypeAndDisplayName[] pairs = new ConfigurationTypeAndDisplayName[types.size()];
        int i = 0;
        for (ConfigurationType type : types) {
            pairs[i++] = new ConfigurationTypeAndDisplayName(type);
        }
        ConfigurationTypeArrayAdapter newAdapter = new ConfigurationTypeArrayAdapter((Context)this, pairs);
        spinner.setAdapter((SpinnerAdapter)newAdapter);
    }

    protected int findPosition(Spinner spinner, ConfigurationType type) {
        ArrayAdapter adapter = (ArrayAdapter)spinner.getAdapter();
        for (int i = 0; i < adapter.getCount(); ++i) {
            if (((ConfigurationTypeAndDisplayName)adapter.getItem((int)i)).configurationType != type) continue;
            return i;
        }
        return -1;
    }

    protected int findPosition(Spinner spinner, ConfigurationType typeA, ConfigurationType typeB) {
        int result = this.findPosition(spinner, typeA);
        if (result < 0) {
            result = this.findPosition(spinner, typeB);
        }
        return result;
    }

    protected void handleSpinner(View view, int spinnerId, DeviceConfiguration deviceConfiguration) {
        this.handleSpinner(view, spinnerId, deviceConfiguration, false);
    }

    protected void handleSpinner(View view, int spinnerId, DeviceConfiguration deviceConfiguration, boolean forceFind) {
        Spinner choiceSpinner = (Spinner)view.findViewById(spinnerId);
        if (forceFind || deviceConfiguration.isEnabled()) {
            int spinnerPosition = this.findPosition(choiceSpinner, deviceConfiguration.getSpinnerChoiceType(), this.getDefaultEnabledSelection());
            choiceSpinner.setSelection(spinnerPosition);
        } else {
            choiceSpinner.setSelection(this.findPosition(choiceSpinner, (ConfigurationType)BuiltInConfigurationType.NOTHING));
        }
        choiceSpinner.setOnItemSelectedListener(this.spinnerListener);
    }

    protected ConfigurationType getDefaultEnabledSelection() {
        return BuiltInConfigurationType.NOTHING;
    }

    protected void clearDevice(View itemView) {
    }

    protected void changeDevice(View itemView, ConfigurationType type) {
    }

    protected void sendOrInject(Command cmd) {
        if (this.remoteConfigure) {
            NetworkConnectionHandler.getInstance().sendCommand(cmd);
        } else {
            NetworkConnectionHandler.getInstance().injectReceivedCommand(cmd);
        }
    }

    protected CallbackResult handleCommandNotifyActiveConfig(String extra) {
        RobotLog.vv((String)TAG, (String)"%s.handleCommandRequestActiveConfigResp(%s)", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), extra});
        RobotConfigFile configFile = this.robotConfigFileManager.getConfigFromString(extra);
        this.robotConfigFileManager.setActiveConfigAndUpdateUI(configFile);
        return CallbackResult.HANDLED_CONTINUE;
    }

    protected static class ConfigurationTypeAndDisplayName {
        public final ConfigurationType configurationType;
        public final String displayName;

        public ConfigurationTypeAndDisplayName(ConfigurationType configurationType) {
            this.configurationType = configurationType;
            this.displayName = configurationType.getName();
        }

        public String toString() {
            return this.displayName;
        }
    }

    protected static class DisplayNameAndRequestCode
    implements Comparable<DisplayNameAndRequestCode> {
        public final String displayName;
        public final RequestCode requestCode;

        public DisplayNameAndRequestCode(String combined) {
            String[] parts = combined.split("\\|");
            this.displayName = parts[0];
            this.requestCode = RequestCode.fromString(parts[1]);
        }

        public DisplayNameAndRequestCode(String displayName, RequestCode requestCode) {
            this.displayName = displayName;
            this.requestCode = requestCode;
        }

        public static DisplayNameAndRequestCode[] fromArray(String[] strings) {
            DisplayNameAndRequestCode[] result = new DisplayNameAndRequestCode[strings.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new DisplayNameAndRequestCode(strings[i]);
            }
            return result;
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(DisplayNameAndRequestCode another) {
            return this.displayName.compareTo(another.displayName);
        }
    }

    protected static class DisplayNameAndInteger
    implements Comparable<DisplayNameAndInteger> {
        public final String displayName;
        public final int value;

        public DisplayNameAndInteger(String displayName, int value) {
            this.displayName = displayName;
            this.value = value;
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(DisplayNameAndInteger another) {
            return this.displayName.compareTo(another.displayName);
        }
    }

    protected class SetNameTextWatcher
    implements TextWatcher {
        private final DeviceConfiguration deviceConfiguration;

        protected SetNameTextWatcher(DeviceConfiguration deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            String text = editable.toString();
            this.deviceConfiguration.setName(text);
        }
    }
}

