/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditUSBDeviceActivity;
import com.qualcomm.robotcore.hardware.configuration.BuiltInConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class EditPortListActivity<ITEM_T extends DeviceConfiguration>
extends EditUSBDeviceActivity {
    public static final String TAG = "EditPortListActivity";
    protected int layoutMain;
    protected int layoutControllerNameBanner = 0;
    protected int idListParentLayout;
    protected int layoutItem;
    protected int idItemRowPort;
    protected int idItemPortNumber;
    protected int idItemEditTextResult;
    protected ArrayList<View> itemViews = new ArrayList();
    protected List<ITEM_T> itemList = new ArrayList<ITEM_T>();
    protected Class<ITEM_T> itemClass;
    protected int initialPortNumber;
    protected int idBannerParent = R.id.bannerParent;
    protected int idControllerName = R.id.controller_name;
    protected int idControllerSerialNumber = R.id.serialNumber;
    protected EditText editTextBannerControllerName;
    protected TextView textViewSerialNumber;

    protected EditPortListActivity() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.layoutMain);
        Intent intent = this.getIntent();
        EditParameters parameters = EditParameters.fromIntent(this, intent);
        this.deserialize(parameters);
        this.initialPortNumber = parameters.getInitialPortNumber();
        this.showButton(this.idAddButton, parameters.isGrowable());
        if (this.layoutControllerNameBanner != 0) {
            LinearLayout parent = (LinearLayout)this.findViewById(this.idBannerParent);
            View banner = this.getLayoutInflater().inflate(this.layoutControllerNameBanner, (ViewGroup)parent, false);
            parent.addView(banner);
            this.editTextBannerControllerName = (EditText)banner.findViewById(this.idControllerName);
            this.textViewSerialNumber = (TextView)banner.findViewById(this.idControllerSerialNumber);
            this.editTextBannerControllerName.setText((CharSequence)this.controllerConfiguration.getName());
            this.showFixSwapButtons();
        }
        this.createListViews(parameters);
        this.addViewListeners();
    }

    @Override
    protected void refreshSerialNumber() {
        String serialNum = EditPortListActivity.formatSerialNumber((Context)this, this.controllerConfiguration);
        this.textViewSerialNumber.setText((CharSequence)serialNum);
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    protected void createListViews(EditParameters<ITEM_T> parameters) {
        if (parameters != null) {
            this.itemList = parameters.getCurrentItems();
            this.itemClass = parameters.getItemClass();
            Collections.sort(this.itemList);
            for (int index = 0; index < this.itemList.size(); ++index) {
                View itemView = this.createItemViewForPort(this.findConfigByIndex(index).getPort());
                this.itemViews.add(itemView);
            }
        }
    }

    protected void addViewListeners() {
        for (int index = 0; index < this.itemList.size(); ++index) {
            this.addViewListenersOnIndex(index);
        }
    }

    protected abstract void addViewListenersOnIndex(int var1);

    protected View createItemViewForPort(int portNumber) {
        LinearLayout parent = (LinearLayout)this.findViewById(this.idListParentLayout);
        View child = this.getLayoutInflater().inflate(this.layoutItem, (ViewGroup)parent, false);
        parent.addView(child);
        View result = child.findViewById(this.idItemRowPort);
        TextView port = (TextView)result.findViewById(this.idItemPortNumber);
        if (port != null) {
            port.setText((CharSequence)String.format(Locale.getDefault(), "%d", portNumber));
        }
        return result;
    }

    protected void addNameTextChangeWatcherOnIndex(int index) {
        View itemView = this.findViewByIndex(index);
        EditText name = (EditText)itemView.findViewById(this.idItemEditTextResult);
        name.addTextChangedListener((TextWatcher)new EditActivity.SetNameTextWatcher(this.findConfigByIndex(index)));
    }

    public void onAddButtonPressed(View v) {
        this.addNewItem();
    }

    protected void addNewItem() {
        try {
            int portNumber = this.itemList.isEmpty() ? this.initialPortNumber : ((DeviceConfiguration)this.itemList.get(this.itemList.size() - 1)).getPort() + 1;
            int index = this.itemList.size();
            DeviceConfiguration deviceConfiguration = (DeviceConfiguration)this.itemClass.newInstance();
            deviceConfiguration.setPort(portNumber);
            deviceConfiguration.setConfigurationType((ConfigurationType)BuiltInConfigurationType.NOTHING);
            this.itemList.add(deviceConfiguration);
            this.itemViews.add(this.createItemViewForPort(portNumber));
            this.addViewListenersOnIndex(index);
        }
        catch (IllegalAccessException | InstantiationException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"exception thrown during addNewItem(); ignoring add");
        }
    }

    public void onFixButtonPressed(View v) {
        this.fixConfiguration();
    }

    public void onSwapButtonPressed(View view) {
        this.swapConfiguration();
    }

    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        if (resultCode == -1) {
            this.completeSwapConfiguration(requestCodeValue, resultCode, data);
            this.currentCfgFile.markDirty();
            this.robotConfigFileManager.updateActiveConfigHeader(this.currentCfgFile);
        }
    }

    protected View findViewByIndex(int index) {
        return this.itemViews.get(index);
    }

    protected DeviceConfiguration findConfigByIndex(int index) {
        return (DeviceConfiguration)this.itemList.get(index);
    }

    protected DeviceConfiguration findConfigByPort(int port) {
        for (DeviceConfiguration config : this.itemList) {
            if (config.getPort() != port) continue;
            return config;
        }
        return null;
    }

    public void onDoneButtonPressed(View v) {
        this.finishOk();
    }

    public void onCancelButtonPressed(View v) {
        this.finishCancel();
    }

    @Override
    protected void finishOk() {
        if (this.controllerConfiguration != null) {
            this.controllerConfiguration.setName(this.editTextBannerControllerName.getText().toString());
            this.finishOk(new EditParameters((EditActivity)this, (DeviceConfiguration)this.controllerConfiguration, this.getRobotConfigMap()));
        } else {
            this.finishOk(new EditParameters<ITEM_T>((EditActivity)this, this.itemClass, this.itemList));
        }
    }
}

