/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.view.View;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditPortListActivity;
import com.qualcomm.robotcore.hardware.ControlSystem;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationTypeManager;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import java.util.SortedSet;

public abstract class EditPortListSpinnerActivity<ITEM_T extends DeviceConfiguration>
extends EditPortListActivity<ITEM_T> {
    protected int idItemSpinner;
    protected ControlSystem controlSystem;
    protected boolean configuringControlHubParent;

    protected abstract ConfigurationType.DeviceFlavor getDeviceFlavorBeingConfigured();

    protected EditPortListSpinnerActivity() {
    }

    @Override
    protected void deserialize(EditParameters parameters) {
        super.deserialize(parameters);
        this.controlSystem = parameters.getControlSystem();
        this.configuringControlHubParent = parameters.configuringControlHubParent();
    }

    @Override
    protected View createItemViewForPort(int portNumber) {
        View itemView = super.createItemViewForPort(portNumber);
        this.localizeSpinner(itemView);
        return itemView;
    }

    protected void localizeSpinner(View itemView) {
        Spinner spinner = (Spinner)itemView.findViewById(this.idItemSpinner);
        SortedSet deviceTypes = ConfigurationTypeManager.getInstance().getApplicableConfigTypes(this.getDeviceFlavorBeingConfigured(), this.controlSystem, this.configuringControlHubParent);
        this.localizeConfigTypeSpinnerTypes(spinner, deviceTypes);
    }

    @Override
    protected void addViewListenersOnIndex(int index) {
        View itemView = this.findViewByIndex(index);
        DeviceConfiguration config = this.findConfigByIndex(index);
        this.addNameTextChangeWatcherOnIndex(index);
        this.handleDisabledDevice(itemView, config);
        this.handleSpinner(itemView, this.idItemSpinner, config);
    }

    private void handleDisabledDevice(View itemView, DeviceConfiguration deviceConfiguration) {
        EditText name = (EditText)itemView.findViewById(this.idItemEditTextResult);
        if (deviceConfiguration.isEnabled()) {
            name.setText((CharSequence)deviceConfiguration.getName());
            name.setEnabled(true);
        } else {
            name.setText((CharSequence)this.disabledDeviceName());
            name.setEnabled(false);
        }
    }

    @Override
    protected void clearDevice(View itemView) {
        TextView textViewPortNumber = (TextView)itemView.findViewById(this.idItemPortNumber);
        int portNumber = Integer.parseInt(textViewPortNumber.getText().toString());
        EditText nameText = (EditText)itemView.findViewById(this.idItemEditTextResult);
        nameText.setEnabled(false);
        nameText.setText((CharSequence)this.disabledDeviceName());
        DeviceConfiguration config = this.findConfigByPort(portNumber);
        config.setEnabled(false);
    }

    @Override
    protected void changeDevice(View itemView, ConfigurationType type) {
        TextView textViewPortNumber = (TextView)itemView.findViewById(this.idItemPortNumber);
        int portNumber = Integer.parseInt(textViewPortNumber.getText().toString());
        EditText nameText = (EditText)itemView.findViewById(this.idItemEditTextResult);
        nameText.setEnabled(true);
        DeviceConfiguration config = this.findConfigByPort(portNumber);
        this.clearNameIfNecessary(nameText, config);
        config.setConfigurationType(type);
        config.setEnabled(true);
    }
}

