/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditSwapUsbDevices;
import com.qualcomm.ftccommon.configuration.EditUSBDeviceActivity;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.WebcamConfiguration;

public class EditWebcamActivity
extends EditUSBDeviceActivity {
    public static final RequestCode requestCode = RequestCode.EDIT_USB_CAMERA;
    private WebcamConfiguration webcamConfiguration;
    private EditText textCameraName;

    @Override
    public String getTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.webcam_device);
        this.textCameraName = (EditText)this.findViewById(R.id.cameraName);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        this.webcamConfiguration = (WebcamConfiguration)this.controllerConfiguration;
        this.textCameraName.addTextChangedListener((TextWatcher)new EditActivity.SetNameTextWatcher((DeviceConfiguration)this.controllerConfiguration));
        this.textCameraName.setText((CharSequence)this.controllerConfiguration.getName());
        this.showFixSwapButtons();
    }

    @Override
    protected void refreshSerialNumber() {
        TextView serialNumberView = (TextView)this.findViewById(R.id.serialNumber);
        serialNumberView.setText((CharSequence)EditWebcamActivity.formatSerialNumber((Context)this, this.controllerConfiguration));
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        this.logActivityResult(requestCodeValue, resultCode, data);
        if (resultCode == -1) {
            WebcamConfiguration newModule;
            EditParameters parameters = EditParameters.fromIntent(this, data);
            RequestCode requestCode = RequestCode.fromValue(requestCodeValue);
            if (requestCode == EditSwapUsbDevices.requestCode) {
                this.completeSwapConfiguration(requestCodeValue, resultCode, data);
            } else if (requestCode != EditWebcamActivity.requestCode || (newModule = (WebcamConfiguration)parameters.getConfiguration()) != null) {
                // empty if block
            }
            this.currentCfgFile.markDirty();
            this.robotConfigFileManager.setActiveConfig(this.currentCfgFile);
        }
    }

    public void onDoneButtonPressed(View v) {
        this.finishOk();
    }

    @Override
    protected void finishOk() {
        this.controllerConfiguration.setName(this.textCameraName.getText().toString());
        this.finishOk(new EditParameters((EditActivity)this, (DeviceConfiguration)this.controllerConfiguration, this.getRobotConfigMap()));
    }

    public void onCancelButtonPressed(View v) {
        this.finishCancel();
    }

    public void onFixButtonPressed(View v) {
        this.fixConfiguration();
    }

    public void onSwapButtonPressed(View view) {
        this.swapConfiguration();
    }
}

