/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.app.Application;
import android.content.res.Resources;
import androidx.annotation.NonNull;
import androidx.annotation.XmlRes;
import com.google.gson.JsonSyntaxException;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class RobotConfigFile {
    private static final String LOGGER_TAG = "RobotConfigFile";
    private String name;
    @XmlRes
    private int resourceId;
    private FileLocation location;
    private boolean isDirty;

    public static RobotConfigFile noConfig(RobotConfigFileManager configFileManager) {
        return new RobotConfigFile(configFileManager, configFileManager.noConfig);
    }

    public RobotConfigFile(RobotConfigFileManager configFileManager, String name) {
        this.name = RobotConfigFileManager.stripFileNameExtension(name);
        this.resourceId = 0;
        this.location = this.name.equalsIgnoreCase(configFileManager.noConfig) ? FileLocation.NONE : FileLocation.LOCAL_STORAGE;
        this.isDirty = false;
    }

    public RobotConfigFile(String name, @XmlRes int resourceId) {
        this.name = name;
        this.resourceId = resourceId;
        this.location = FileLocation.RESOURCE;
        this.isDirty = false;
    }

    public boolean isReadOnly() {
        return this.location == FileLocation.RESOURCE || this.location == FileLocation.NONE;
    }

    public boolean containedIn(Collection<RobotConfigFile> configFiles) {
        for (RobotConfigFile him : configFiles) {
            if (!him.name.equalsIgnoreCase(this.name)) continue;
            return true;
        }
        return false;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void markClean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String getName() {
        return this.name;
    }

    public File getFullPath() {
        return RobotConfigFileManager.getFullPath(this.getName());
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public FileLocation getLocation() {
        return this.location;
    }

    @NonNull
    public XmlPullParser getXml() throws FileNotFoundException, XmlPullParserException {
        switch (this.location) {
            case LOCAL_STORAGE: {
                return this.getXmlLocalStorage();
            }
            case RESOURCE: {
                return this.getXmlResource();
            }
            case NONE: {
                return this.getXmlNone();
            }
        }
        throw new RuntimeException("Unknown type of configuration location: " + (Object)((Object)this.location));
    }

    protected XmlPullParser getXmlNone() throws XmlPullParserException {
        XmlPullParser result = null;
        String emptyXml = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>\n<Robot type=\"FirstInspires-FTC\">\n</Robot>\n";
        StringReader stringReader = new StringReader(emptyXml);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        result = factory.newPullParser();
        result.setInput((Reader)stringReader);
        return result;
    }

    protected XmlPullParser getXmlLocalStorage() throws XmlPullParserException, FileNotFoundException {
        File fullPath = RobotConfigFileManager.getFullPath(this.getName());
        FileInputStream inputStream = new FileInputStream(fullPath);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput((InputStream)inputStream, null);
        return parser;
    }

    protected XmlPullParser getXmlResource() throws FileNotFoundException {
        Application context = AppUtil.getInstance().getApplication();
        try {
            return context.getResources().getXml(this.resourceId);
        }
        catch (Resources.NotFoundException e) {
            throw new FileNotFoundException("XML resource not found");
        }
    }

    public boolean isNoConfig() {
        return this.location == FileLocation.NONE;
    }

    @NonNull
    public String toString() {
        return SimpleGson.getInstance().toJson((Object)this);
    }

    @NonNull
    public static RobotConfigFile fromString(RobotConfigFileManager configFileManager, String serializedForm) {
        try {
            RobotConfigFile file = (RobotConfigFile)SimpleGson.getInstance().fromJson(serializedForm, RobotConfigFile.class);
            if (file == null) {
                return RobotConfigFile.noConfig(configFileManager);
            }
            return file;
        }
        catch (JsonSyntaxException e) {
            RobotLog.ee((String)LOGGER_TAG, (String)"Could not parse the stored config file data from shared settings");
            return RobotConfigFile.noConfig(configFileManager);
        }
    }

    public static enum FileLocation {
        NONE,
        LOCAL_STORAGE,
        RESOURCE;

    }
}

