/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.configuration.BuiltInConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.robotcore.internal.system.Misc;

public class RobotConfigMap
implements Serializable {
    Map<SerialNumber, ControllerConfiguration> map = new HashMap<SerialNumber, ControllerConfiguration>();

    public RobotConfigMap(Collection<ControllerConfiguration> controllerConfigurations) {
        for (ControllerConfiguration controllerConfiguration : controllerConfigurations) {
            this.put(controllerConfiguration.getSerialNumber(), controllerConfiguration);
        }
    }

    public RobotConfigMap(Map<SerialNumber, ControllerConfiguration> map) {
        this.map = new HashMap<SerialNumber, ControllerConfiguration>(map);
    }

    public RobotConfigMap(RobotConfigMap him) {
        this(him.map);
    }

    public RobotConfigMap() {
    }

    public boolean contains(SerialNumber serialNumber) {
        return this.map.containsKey(serialNumber);
    }

    public ControllerConfiguration get(SerialNumber serialNumber) {
        return this.map.get(serialNumber);
    }

    public void put(SerialNumber serialNumber, ControllerConfiguration controllerConfiguration) {
        this.map.put(serialNumber, controllerConfiguration);
    }

    public boolean remove(SerialNumber serialNumber) {
        return this.map.remove(serialNumber) != null;
    }

    public int size() {
        return this.map.size();
    }

    public Collection<SerialNumber> serialNumbers() {
        return this.map.keySet();
    }

    public Collection<ControllerConfiguration> controllerConfigurations() {
        return this.map.values();
    }

    public void writeToLog(String tag, String message) {
        RobotLog.vv((String)tag, (String)"robotConfigMap: %s", (Object[])new Object[]{message});
        for (ControllerConfiguration controllerConfiguration : this.controllerConfigurations()) {
            RobotLog.vv((String)tag, (String)"   serial=%s id=0x%08x name='%s' ", (Object[])new Object[]{controllerConfiguration.getSerialNumber(), controllerConfiguration.hashCode(), controllerConfiguration.getName()});
        }
    }

    public void writeToLog(String tag, String message, ControllerConfiguration controllerConfiguration) {
        this.writeToLog(tag, message);
        RobotLog.vv((String)tag, (String)"  :serial=%s id=0x%08x name='%s' ", (Object[])new Object[]{controllerConfiguration.getSerialNumber(), controllerConfiguration.hashCode(), controllerConfiguration.getName()});
    }

    boolean allControllersAreBound() {
        for (ControllerConfiguration controllerConfiguration : this.controllerConfigurations()) {
            if (!controllerConfiguration.getSerialNumber().isFake()) continue;
            return false;
        }
        return true;
    }

    public void bindUnboundControllers(ScannedDevices scannedDevices) {
        ScannedDevices extraDevices = new ScannedDevices(scannedDevices);
        for (ControllerConfiguration controllerConfiguration : this.controllerConfigurations()) {
            extraDevices.remove(controllerConfiguration.getSerialNumber());
        }
        HashMap<ConfigurationType, LinkedList<SerialNumber>> extraByType = new HashMap<ConfigurationType, LinkedList<SerialNumber>>();
        for (Map.Entry pair : extraDevices.entrySet()) {
            ConfigurationType configurationType = BuiltInConfigurationType.fromUSBDeviceType((DeviceManager.UsbDeviceType)((DeviceManager.UsbDeviceType)pair.getValue()));
            if (configurationType == BuiltInConfigurationType.UNKNOWN) continue;
            LinkedList<SerialNumber> list = (LinkedList<SerialNumber>)extraByType.get(configurationType);
            if (list == null) {
                list = new LinkedList<SerialNumber>();
                extraByType.put(configurationType, list);
            }
            list.add((SerialNumber)pair.getKey());
        }
        for (ControllerConfiguration controllerConfiguration : this.controllerConfigurations()) {
            List list;
            if (!controllerConfiguration.getSerialNumber().isFake() || (list = (List)extraByType.get(controllerConfiguration.getConfigurationType())) == null || list.isEmpty()) continue;
            SerialNumber newSerialNumber = (SerialNumber)list.remove(0);
            controllerConfiguration.setSerialNumber(newSerialNumber);
        }
        ArrayList<ControllerConfiguration> arrayList = new ArrayList<ControllerConfiguration>(this.controllerConfigurations());
        this.map.clear();
        for (ControllerConfiguration controllerConfiguration : arrayList) {
            this.put(controllerConfiguration.getSerialNumber(), controllerConfiguration);
        }
    }

    public void setSerialNumber(ControllerConfiguration controllerConfiguration, SerialNumber serialNumber) {
        this.remove(controllerConfiguration.getSerialNumber());
        controllerConfiguration.setSerialNumber(serialNumber);
        this.put(serialNumber, controllerConfiguration);
    }

    public void swapSerialNumbers(ControllerConfiguration a, ControllerConfiguration b) {
        SerialNumber aSerialNumber = a.getSerialNumber();
        a.setSerialNumber(b.getSerialNumber());
        b.setSerialNumber(aSerialNumber);
        this.put(a.getSerialNumber(), a);
        this.put(b.getSerialNumber(), b);
        boolean knownToBeAttached = a.isKnownToBeAttached();
        a.setKnownToBeAttached(b.isKnownToBeAttached());
        b.setKnownToBeAttached(knownToBeAttached);
    }

    public boolean isSwappable(ControllerConfiguration target, ScannedDevices scannedDevices, Context context) {
        return !this.getEligibleSwapTargets(target, scannedDevices, context).isEmpty();
    }

    public List<ControllerConfiguration> getEligibleSwapTargets(ControllerConfiguration target, ScannedDevices scannedDevices, Context context) {
        LinkedList<ControllerConfiguration> result = new LinkedList<ControllerConfiguration>();
        return result;
    }

    protected String generateName(Context context, ConfigurationType type, List<ControllerConfiguration> resultSoFar) {
        int i = 1;
        String name;
        while (this.nameExists(name = Misc.formatForUser((String)"%s %d", (Object[])new Object[]{type.getName(), i}), resultSoFar)) {
            ++i;
        }
        return name;
    }

    protected boolean nameExists(String name, List<ControllerConfiguration> resultSoFar) {
        for (ControllerConfiguration controllerConfiguration : resultSoFar) {
            if (!controllerConfiguration.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        for (ControllerConfiguration controllerConfiguration : this.controllerConfigurations()) {
            if (!controllerConfiguration.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsSerialNumber(List<ControllerConfiguration> list, SerialNumber serialNumber) {
        for (ControllerConfiguration controllerConfiguration : list) {
            if (!controllerConfiguration.getSerialNumber().equals((Object)serialNumber)) continue;
            return true;
        }
        return false;
    }
}

