/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.external;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.SoundPlayer;
import com.qualcomm.robotcore.robot.RobotState;
import com.qualcomm.robotcore.robot.RobotStatus;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.concurrent.atomic.AtomicInteger;
import org.firstinspires.ftc.ftccommon.external.RobotStateMonitor;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.internal.network.NetworkStatus;
import org.firstinspires.ftc.robotcore.internal.network.PeerStatus;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class SoundPlayingRobotMonitor
implements RobotStateMonitor {
    public static boolean DEBUG = false;
    protected Context context;
    protected RobotState robotState = RobotState.UNKNOWN;
    protected RobotStatus robotStatus = RobotStatus.UNKNOWN;
    protected NetworkStatus networkStatus = NetworkStatus.UNKNOWN;
    protected PeerStatus peerStatus = PeerStatus.UNKNOWN;
    protected String errorMessage = null;
    protected String warningMessageString = null;
    protected Sound lastSoundPlayed = Sound.None;
    protected AtomicInteger runningsInFlight = new AtomicInteger(0);
    @RawRes
    public static int soundConnect = R.raw.ss_r2d2_up;
    @RawRes
    public static int soundDisconnect = R.raw.ss_bb8_down;
    @RawRes
    public static int soundRunning = R.raw.ss_light_speed;
    @RawRes
    public static int soundWarning = R.raw.ss_mine;
    @RawRes
    public static int soundError = R.raw.ss_mf_fail;

    public SoundPlayingRobotMonitor() {
        this((Context)AppUtil.getInstance().getApplication());
    }

    public SoundPlayingRobotMonitor(Context context) {
        this.context = context;
    }

    public static void prefillSoundCache() {
        SoundPlayer.getInstance().prefillSoundCache(soundConnect, soundDisconnect, soundRunning, soundWarning, soundError);
    }

    protected void playConnect() {
        if (!SoundPlayer.getInstance().isLocalSoundOn() && this.lastSoundPlayed == Sound.Running && this.runningsInFlight.get() == 0) {
            RobotLog.vv((String)"SoundPlayer", (String)"playing running again");
            this.playRunning();
        }
        this.playSound(Sound.Connect, soundConnect);
    }

    protected void playDisconnect() {
        this.playSound(Sound.Disconnect, soundDisconnect);
    }

    protected void playRunning() {
        this.runningsInFlight.getAndIncrement();
        this.playSound(Sound.Running, soundRunning, new Consumer<Integer>(){

            public void accept(Integer nonZeroOnSuccess) {
                SoundPlayingRobotMonitor.this.runningsInFlight.decrementAndGet();
            }
        }, null);
    }

    protected void playWarning() {
        this.playSound(Sound.Warning, soundWarning);
    }

    protected void playError() {
        this.playSound(Sound.Error, soundError);
    }

    @Override
    public synchronized void updateRobotState(@NonNull RobotState robotState) {
        if (robotState != this.robotState) {
            if (DEBUG) {
                RobotLog.vv((String)"SoundPlayer", (String)"updateRobotState(%s)", (Object[])new Object[]{robotState.toString()});
            }
            switch (robotState) {
                case NOT_STARTED: {
                    break;
                }
                case INIT: {
                    break;
                }
                case STOPPED: {
                    break;
                }
                case EMERGENCY_STOP: {
                    break;
                }
                default: {
                    break;
                }
                case RUNNING: {
                    this.playRunning();
                }
            }
        }
        this.robotState = robotState;
    }

    @Override
    public synchronized void updateRobotStatus(@NonNull RobotStatus robotStatus) {
        if (robotStatus != this.robotStatus) {
            if (DEBUG) {
                RobotLog.vv((String)"SoundPlayer", (String)"updateRobotStatus(%s)", (Object[])new Object[]{robotStatus.toString()});
            }
            switch (robotStatus) {
                case NONE: {
                    break;
                }
            }
        }
        this.robotStatus = robotStatus;
    }

    @Override
    public void updatePeerStatus(@NonNull PeerStatus peerStatus) {
        if (peerStatus != this.peerStatus) {
            if (DEBUG) {
                RobotLog.vv((String)"SoundPlayer", (String)"updatePeerStatus(%s)", (Object[])new Object[]{peerStatus.toString()});
            }
            switch (peerStatus) {
                case UNKNOWN: {
                    break;
                }
                case CONNECTED: {
                    if (this.peerStatus == PeerStatus.CONNECTED) break;
                    this.playConnect();
                    break;
                }
                case DISCONNECTED: {
                    if (this.peerStatus == PeerStatus.DISCONNECTED) break;
                    this.playDisconnect();
                    break;
                }
            }
        }
        this.peerStatus = peerStatus;
    }

    @Override
    public synchronized void updateNetworkStatus(@NonNull NetworkStatus networkStatus, @Nullable String extra) {
        if (networkStatus != this.networkStatus) {
            if (DEBUG) {
                RobotLog.vv((String)"SoundPlayer", (String)"updateNetworkStatus(%s)", (Object[])new Object[]{networkStatus.toString()});
            }
            switch (networkStatus) {
                case UNKNOWN: {
                    break;
                }
                case ACTIVE: {
                    break;
                }
                case INACTIVE: {
                    break;
                }
                case ENABLED: {
                    break;
                }
                case ERROR: {
                    break;
                }
                case CREATED_AP_CONNECTION: {
                    break;
                }
            }
        }
        this.networkStatus = networkStatus;
    }

    @Override
    public synchronized void updateErrorMessage(@Nullable String errorMessage) {
        if (errorMessage != null && !errorMessage.equals(this.errorMessage)) {
            if (DEBUG) {
                RobotLog.vv((String)"SoundPlayer", (String)"updateErrorMessage()");
            }
            this.playError();
        }
        this.errorMessage = errorMessage;
    }

    @Override
    public synchronized void updateWarningMessage(@Nullable RobotLog.GlobalWarningMessage warningMessage) {
        if (warningMessage != null && !warningMessage.message.equals(this.warningMessageString)) {
            if (DEBUG) {
                RobotLog.vv((String)"SoundPlayer", (String)"updateWarningMessage()");
            }
            if (warningMessage.deservesWarningSound) {
                this.playWarning();
            }
        }
        this.warningMessageString = warningMessage == null ? null : warningMessage.message;
    }

    protected void playSound(Sound sound, @RawRes int resourceId) {
        this.playSound(sound, resourceId, null, null);
    }

    protected void playSound(Sound sound, @RawRes int resourceId, @Nullable Consumer<Integer> runWhenStarted, @Nullable Runnable runWhenFinished) {
        this.lastSoundPlayed = sound;
        SoundPlayer.getInstance().startPlaying(this.context, resourceId, new SoundPlayer.PlaySoundParams(true), runWhenStarted, runWhenFinished);
    }

    protected static enum Sound {
        None,
        Connect,
        Disconnect,
        Running,
        Warning,
        Error;

    }
}

