/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal;

import android.content.Context;
import android.view.Menu;
import com.qualcomm.ftccommon.FtcEventLoop;
import com.qualcomm.robotcore.util.ClassUtil;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.WebHandlerManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.firstinspires.ftc.ftccommon.external.OnCreate;
import org.firstinspires.ftc.ftccommon.external.OnCreateEventLoop;
import org.firstinspires.ftc.ftccommon.external.OnCreateMenu;
import org.firstinspires.ftc.ftccommon.external.OnDestroy;
import org.firstinspires.ftc.ftccommon.external.WebHandlerRegistrar;
import org.firstinspires.ftc.robotcore.external.Predicate;
import org.firstinspires.ftc.robotcore.internal.opmode.ClassFilter;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaDeterminer;

public class AnnotatedHooksClassFilter
implements ClassFilter {
    private static final String TAG = "AnnotatedHooksClassFilter";
    private static final Predicate<Method> isOnBotJava = new Predicate<Method>(){

        public boolean test(Method method) {
            return OnBotJavaDeterminer.isOnBotJava(method.getDeclaringClass());
        }
    };
    private static final Predicate<Method> isExternalLibraries = new Predicate<Method>(){

        public boolean test(Method method) {
            return OnBotJavaDeterminer.isExternalLibraries(method.getDeclaringClass());
        }
    };
    private final Set<Method> onCreateMethods = new HashSet<Method>();
    private final Set<Method> onCreateEventLoopMethods = new HashSet<Method>();
    private final Set<Method> onCreateMenuMethods = new HashSet<Method>();
    private final Set<Method> onDestroyMethods = new HashSet<Method>();
    private final Set<Method> webHandlerRegistrarMethods = new HashSet<Method>();
    private final List<Set<Method>> allSets = new ArrayList<Set<Method>>();

    public static AnnotatedHooksClassFilter getInstance() {
        return InstanceHolder.theInstance;
    }

    private AnnotatedHooksClassFilter() {
        this.allSets.add(this.onCreateMethods);
        this.allSets.add(this.onCreateEventLoopMethods);
        this.allSets.add(this.onCreateMenuMethods);
        this.allSets.add(this.onDestroyMethods);
        this.allSets.add(this.webHandlerRegistrarMethods);
    }

    public void filterAllClassesStart() {
        this.clear();
    }

    public void filterOnBotJavaClassesStart() {
        this.removeOldMethods(isOnBotJava);
    }

    public void filterExternalLibrariesClassesStart() {
        this.removeOldMethods(isExternalLibraries);
    }

    public void filterClass(Class clazz) {
        this.exploreClass(clazz);
    }

    public void filterOnBotJavaClass(Class clazz) {
        this.exploreClass(clazz);
    }

    public void filterExternalLibrariesClass(Class clazz) {
        this.exploreClass(clazz);
    }

    public void filterAllClassesComplete() {
    }

    public void filterOnBotJavaClassesComplete() {
    }

    public void filterExternalLibrariesClassesComplete() {
    }

    public void callOnCreateMethods(Context context) {
        for (Method method : this.onCreateMethods) {
            try {
                method.invoke(null, context);
            }
            catch (Exception e) {
                RobotLog.e((String)TAG, (Object[])new Object[]{e, "failure while calling OnCreate annotated method " + method.getDeclaringClass() + "." + method.getName()});
            }
        }
    }

    public void callOnCreateEventLoopMethods(Context context, FtcEventLoop ftcEventLoop) {
        for (Method method : this.onCreateEventLoopMethods) {
            try {
                method.invoke(null, context, ftcEventLoop);
            }
            catch (Exception e) {
                RobotLog.e((String)TAG, (Object[])new Object[]{e, "failure while calling OnCreateEventLoop annotated method " + method.getDeclaringClass() + "." + method.getName()});
            }
        }
    }

    public void callOnCreateMenuMethods(Context context, Menu menu) {
        for (Method method : this.onCreateMenuMethods) {
            try {
                method.invoke(null, context, menu);
            }
            catch (Exception e) {
                RobotLog.e((String)TAG, (Object[])new Object[]{e, "failure while calling OnCreateMenu annotated method " + method.getDeclaringClass() + "." + method.getName()});
            }
        }
    }

    public void callOnDestroyMethods(Context context) {
        for (Method method : this.onDestroyMethods) {
            try {
                method.invoke(null, context);
            }
            catch (Exception e) {
                RobotLog.e((String)TAG, (Object[])new Object[]{e, "failure while calling OnDestory annotated method " + method.getDeclaringClass() + "." + method.getName()});
            }
        }
    }

    public void callWebHandlerRegistrarMethods(Context context, WebHandlerManager webHandlerManager) {
        for (Method method : this.webHandlerRegistrarMethods) {
            try {
                method.invoke(null, context, webHandlerManager);
            }
            catch (Exception e) {
                RobotLog.e((String)TAG, (Object[])new Object[]{e, "failure while calling WebHandlerRegistrar annotated method " + method.getDeclaringClass() + "." + method.getName()});
            }
        }
    }

    private void clear() {
        for (Set<Method> set : this.allSets) {
            set.clear();
        }
    }

    private void removeOldMethods(Predicate<Method> predicate) {
        for (Set<Method> set : this.allSets) {
            Iterator<Method> iter = set.iterator();
            while (iter.hasNext()) {
                Method method = iter.next();
                if (!predicate.test((Object)method)) continue;
                iter.remove();
            }
        }
    }

    private void exploreClass(Class<?> clazz) {
        for (Method method : ClassUtil.getLocalDeclaredMethods(clazz)) {
            int requiredModifiers;
            int modifiers = method.getModifiers();
            if ((modifiers & (requiredModifiers = 9)) != requiredModifiers) continue;
            int prohibitedModifiers = 1024;
            if ((method.getModifiers() & prohibitedModifiers) != 0) continue;
            if (method.isAnnotationPresent(OnCreate.class) && method.getParameterTypes().length == 1) {
                this.onCreateMethods.add(method);
            }
            if (method.isAnnotationPresent(OnCreateEventLoop.class) && method.getParameterTypes().length == 2) {
                this.onCreateEventLoopMethods.add(method);
            }
            if (method.isAnnotationPresent(OnCreateMenu.class) && method.getParameterTypes().length == 2) {
                this.onCreateMenuMethods.add(method);
            }
            if (method.isAnnotationPresent(OnDestroy.class) && method.getParameterTypes().length == 1) {
                this.onDestroyMethods.add(method);
            }
            if (!method.isAnnotationPresent(WebHandlerRegistrar.class) || method.getParameterTypes().length != 2) continue;
            this.webHandlerRegistrarMethods.add(method);
        }
    }

    private static class InstanceHolder {
        public static AnnotatedHooksClassFilter theInstance = new AnnotatedHooksClassFilter();

        private InstanceHolder() {
        }
    }
}

