/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.ftccommon.internal.FtcRobotControllerWatchdogService;
import org.firstinspires.ftc.robotcore.internal.hardware.android.AndroidBoard;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.PreferencesHelper;

public class RunOnBoot
extends BroadcastReceiver {
    public static final String TAG = "RunOnBoot";
    protected Context context = null;
    protected PreferencesHelper preferencesHelper = null;

    public void onReceive(Context context, Intent intent) {
        this.context = context;
        if (this.preferencesHelper == null) {
            this.preferencesHelper = new PreferencesHelper(TAG, context);
        }
        String action = intent.getAction();
        RobotLog.vv((String)TAG, (String)"onReceive() action=%s", (Object[])new Object[]{action});
        if (action.equals("android.intent.action.BOOT_COMPLETED")) {
            if (AppUtil.getInstance().isRobotController()) {
                this.onRobotControllerBoot();
            }
        } else if (AppUtil.getInstance().isRobotController()) {
            this.onRobotControllerPostBoot();
        }
    }

    protected void onRobotControllerBoot() {
        this.preferencesHelper.remove(this.context.getString(R.string.pref_autostarted_robot_controller));
        if (this.shouldAutoLaunchRobotController()) {
            this.launchRobotController();
        } else {
            this.noteAndroidBoardPresenceAndExitIfNoRC();
        }
    }

    protected void onRobotControllerPostBoot() {
        this.noteAndroidBoardPresenceAndExitIfNoRC();
    }

    protected void noteAndroidBoardPresenceAndExitIfNoRC() {
        RobotLog.vv((String)TAG, (String)"noteDragonboardPresenceAndExitIfNoRC()");
        if (LynxConstants.isRevControlHub()) {
            AndroidBoard.getInstance().getAndroidBoardIsPresentPin().setState(true);
        }
        if (!this.isRobotControllerRunningInThisProcess()) {
            AppUtil.getInstance().exitApplication();
        }
    }

    protected boolean isRobotControllerRunningInThisProcess() {
        return FtcRobotControllerWatchdogService.isFtcRobotControllerActivity(AppUtil.getInstance().getRootActivity());
    }

    protected boolean shouldAutoLaunchRobotController() {
        boolean result = FtcRobotControllerWatchdogService.shouldAutoLaunchRobotController();
        if (result) {
            result = !this.preferencesHelper.readBoolean(this.context.getString(R.string.pref_autostarted_robot_controller), false);
        }
        RobotLog.vv((String)TAG, (String)"shouldAutoLaunchRobotController() result=%s", (Object[])new Object[]{result});
        return result;
    }

    protected void launchRobotController() {
        RobotLog.vv((String)TAG, (String)"launchRobotController()");
        FtcRobotControllerWatchdogService.launchRobotController(this.context);
        this.preferencesHelper.writeBooleanPrefIfDifferent(this.context.getString(R.string.pref_autostarted_robot_controller), true);
    }
}

