/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol;

import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.commands.standard.LynxNack;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlOpMode;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlWebSocketHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.HubNotRespondingException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidParameterException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.ManualControlNackException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.WebSocketNotAuthorizedForManualControlException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.HandleIdParameters;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;

public abstract class ManualControlDeviceCommandHandler<P extends HandleIdParameters, R>
extends ManualControlCommandHandler<P, R> {
    private final int timeout;
    private final TimeUnit timeoutUnit;

    public ManualControlDeviceCommandHandler(ManualControlWebSocketHandler manualControlWebSocketHandler) {
        this(manualControlWebSocketHandler, 120, TimeUnit.MILLISECONDS);
    }

    public ManualControlDeviceCommandHandler(ManualControlWebSocketHandler manualControlWebSocketHandler, int timeout, TimeUnit timeoutUnit) {
        super(manualControlWebSocketHandler);
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public abstract R performOperationOnDevice(LynxModule var1, P var2) throws LynxNackException, WebSocketCommandException, InterruptedException;

    @Override
    public final R handleManualControlCommand(P parameters) throws WebSocketCommandException, InterruptedException {
        AtomicReference resultRef = new AtomicReference();
        AtomicReference exceptionRef = new AtomicReference();
        try {
            ManualControlOpMode.getInstance().getSystemOperationHandle((HandleIdParameters)parameters).performSystemOperation(module -> {
                if (module.getArmingState() == RobotArmingStateNotifier.ARMINGSTATE.ARMED) {
                    try {
                        resultRef.set(this.performOperationOnDevice((LynxModule)module, parameters));
                    }
                    catch (LynxNackException | InterruptedException | RuntimeException | WebSocketCommandException e) {
                        exceptionRef.set(e);
                    }
                } else {
                    exceptionRef.set(new HubNotRespondingException());
                }
            }, this.timeout, this.timeoutUnit);
        }
        catch (TimeoutException e) {
            throw new HubNotRespondingException();
        }
        catch (RobotCoreException e) {
            throw new RuntimeException(e);
        }
        Exception exception = (Exception)exceptionRef.get();
        if (exception == null) {
            return (R)resultRef.get();
        }
        if (exception instanceof LynxNackException) {
            LynxNack.ReasonCode nackReason = ((LynxNackException)((Object)exception)).getNack().getNackReasonCode();
            if (nackReason.getValue() > 255) {
                if (nackReason instanceof LynxNack.StandardReasonCode) {
                    switch ((LynxNack.StandardReasonCode)nackReason) {
                        case ABANDONED_WAITING_FOR_RESPONSE: 
                        case ABANDONED_WAITING_FOR_ACK: {
                            throw new HubNotRespondingException();
                        }
                        case CANCELLED_FOR_SAFETY: {
                            throw new WebSocketNotAuthorizedForManualControlException();
                        }
                        case UNRECOGNIZED_REASON_CODE: {
                            throw new RuntimeException("Unexpectedly got UNRECOGNIZED_REASON_CODE");
                        }
                    }
                    throw new RuntimeException("Got unrecognized fake NACK " + nackReason);
                }
                throw new RuntimeException("Got unrecognized fake non-standard NACK " + nackReason);
            }
            throw new ManualControlNackException((LynxNackException)((Object)exception));
        }
        if (exception instanceof IllegalArgumentException) {
            throw new InvalidParameterException(exception.getMessage());
        }
        if (exception instanceof InterruptedException) {
            throw new WebSocketNotAuthorizedForManualControlException();
        }
        if (exception instanceof WebSocketCommandException) {
            throw (WebSocketCommandException)((Object)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }
}

