/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.commands.core.LynxReadVersionStringCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxReadVersionStringResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxFailSafeCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxQueryInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxQueryInterfaceResponse;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.LynxModuleMeta;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.WebHandlerManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.firstinspires.ftc.ftccommon.external.WebHandlerRegistrar;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlDeviceCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlOpMode;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.AnalogCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.BulkInputCommand;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.DigitalCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.I2cCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.ImuCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.LedCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.LogCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.MotorCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands.ServoCommands;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.FailedToOpenHubException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidDeviceIdException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidParameterException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.ManualControlLockedException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.OnlyLocalConnectionsAllowedException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.UserOpModeRunningException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.WebSocketNotAuthorizedForManualControlException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.WebSocketNotSubscribedException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.HandleIdParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.OpenHubParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.QueryInterfaceParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.SetHubAddressParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.HubType;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.ManualControlApiVersion;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.ParentHub;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.RhspInterface;
import org.firstinspires.ftc.robotcore.internal.hardware.CachedLynxModulesInfo;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocket;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketNamespaceHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.command.WebSocketCommandHandler;

public class ManualControlWebSocketHandler
extends WebSocketNamespaceHandler {
    public static final String WS_NAMESPACE = "MC";
    private static final ManualControlApiVersion API_VERSION = new ManualControlApiVersion(1, 0);
    @Nullable
    private static volatile ManualControlWebSocketHandler instance;
    private final WebSocketManager webSocketManager;
    private final Object allowedWebSocketLock = new Object();
    @Nullable
    private FtcWebSocket allowedWebSocket = null;
    public static final String HUB_STATUS_CHANGED_NOTIFICATION = "hubStatusChanged";
    public static final String HUB_ADDRESS_CHANGED_NOTIFICATION = "hubAddressChanged";
    public static final String SESSION_ENDED_NOTIFICATION = "sessionEnded";

    @WebHandlerRegistrar
    public static void registerNamespace(Context context, WebHandlerManager webHandlerManager) {
        ManualControlWebSocketHandler newInstance;
        WebSocketManager webSocketManager = webHandlerManager.getWebServer().getWebSocketManager();
        instance = newInstance = new ManualControlWebSocketHandler(webSocketManager);
        webSocketManager.registerNamespaceHandler((WebSocketNamespaceHandler)newInstance);
    }

    @Nullable
    public static ManualControlWebSocketHandler getInstance() {
        return instance;
    }

    public ManualControlWebSocketHandler(WebSocketManager webSocketManager) {
        super(WS_NAMESPACE);
        this.webSocketManager = webSocketManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfWebSocketIsPermittedToControlHardware(FtcWebSocket webSocket) throws WebSocketNotAuthorizedForManualControlException {
        Object object = this.allowedWebSocketLock;
        synchronized (object) {
            if (webSocket != this.allowedWebSocket) {
                throw new WebSocketNotAuthorizedForManualControlException();
            }
        }
    }

    protected void registerMessageTypeHandlers(Map<String, WebSocketMessageTypeHandler> messageTypeHandlerMap) {
        super.registerMessageTypeHandlers(messageTypeHandlerMap);
        messageTypeHandlerMap.put("start", (WebSocketMessageTypeHandler)new StartCommand());
        messageTypeHandlerMap.put("stop", (WebSocketMessageTypeHandler)new StopCommand(this));
        messageTypeHandlerMap.put("scanAndDiscover", (WebSocketMessageTypeHandler)new ScanAndDiscoverCommand(this));
        messageTypeHandlerMap.put("openHub", (WebSocketMessageTypeHandler)new OpenHubCommand(this));
        messageTypeHandlerMap.put("closeHub", (WebSocketMessageTypeHandler)new CloseHubCommand(this));
        messageTypeHandlerMap.put("getHubFwVersionString", (WebSocketMessageTypeHandler)new GetHubFirmwareVersionStringCommand(this));
        messageTypeHandlerMap.put("queryInterface", (WebSocketMessageTypeHandler)new QueryInterfaceCommand(this));
        messageTypeHandlerMap.put("sendFailSafe", (WebSocketMessageTypeHandler)new SendFailSafeCommand(this));
        messageTypeHandlerMap.put("setHubAddress", (WebSocketMessageTypeHandler)new SetHubAddressCommand(this));
        ImuCommands.register(messageTypeHandlerMap, this);
        MotorCommands.register(messageTypeHandlerMap, this);
        ServoCommands.register(messageTypeHandlerMap, this);
        AnalogCommands.register(messageTypeHandlerMap, this);
        DigitalCommands.register(messageTypeHandlerMap, this);
        I2cCommands.register(messageTypeHandlerMap, this);
        BulkInputCommand.register(messageTypeHandlerMap, this);
        LedCommands.register(messageTypeHandlerMap, this);
        LogCommands.register(messageTypeHandlerMap, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnsubscribe(FtcWebSocket webSocket) {
        super.onUnsubscribe(webSocket);
        Object object = this.allowedWebSocketLock;
        synchronized (object) {
            if (webSocket == this.allowedWebSocket) {
                this.stopManualControl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToAllowedWebSocket(FtcWebSocketMessage message) {
        Object object = this.allowedWebSocketLock;
        synchronized (object) {
            if (this.allowedWebSocket != null) {
                this.allowedWebSocket.send(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopManualControl() {
        this.sendMessageToAllowedWebSocket(new FtcWebSocketMessage(WS_NAMESPACE, SESSION_ENDED_NOTIFICATION));
        Object object = this.allowedWebSocketLock;
        synchronized (object) {
            this.allowedWebSocket = null;
        }
        ManualControlOpMode opModeInstance = ManualControlOpMode.getInstance();
        if (opModeInstance != null) {
            opModeInstance.requestOpModeStop();
        }
    }

    private static class SetHubAddressCommand
    extends ManualControlDeviceCommandHandler<SetHubAddressParameters, Void> {
        public SetHubAddressCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<SetHubAddressParameters> getPayloadClass() {
            return SetHubAddressParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, SetHubAddressParameters parameters) throws InvalidParameterException {
            if (module.getSerialNumber().isEmbedded() && module.isParent()) {
                throw new InvalidParameterException("The Control Hub's address cannot be changed");
            }
            module.setNewModuleAddress(parameters.getNewAddress());
            return null;
        }
    }

    private static class SendFailSafeCommand
    extends ManualControlDeviceCommandHandler<HandleIdParameters, Void> {
        public SendFailSafeCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<HandleIdParameters> getPayloadClass() {
            return HandleIdParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, HandleIdParameters parameters) throws LynxNackException, InterruptedException {
            LynxFailSafeCommand command = new LynxFailSafeCommand(module);
            command.send();
            return null;
        }
    }

    private static class QueryInterfaceCommand
    extends ManualControlDeviceCommandHandler<QueryInterfaceParameters, RhspInterface> {
        public QueryInterfaceCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<QueryInterfaceParameters> getPayloadClass() {
            return QueryInterfaceParameters.class;
        }

        @NonNull
        protected Class<RhspInterface> getResultClass() {
            return RhspInterface.class;
        }

        @Override
        public RhspInterface performOperationOnDevice(LynxModule module, QueryInterfaceParameters value) throws LynxNackException, InterruptedException, InvalidParameterException {
            String name = value.getInterfaceName();
            LynxQueryInterfaceCommand command = new LynxQueryInterfaceCommand(module, name);
            LynxQueryInterfaceResponse response = (LynxQueryInterfaceResponse)command.sendReceive();
            return new RhspInterface(name, response.getCommandNumberFirst(), response.getNumberOfCommands());
        }
    }

    private static class GetHubFirmwareVersionStringCommand
    extends ManualControlDeviceCommandHandler<HandleIdParameters, String> {
        public GetHubFirmwareVersionStringCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<HandleIdParameters> getPayloadClass() {
            return HandleIdParameters.class;
        }

        @NonNull
        protected Class<String> getResultClass() {
            return String.class;
        }

        @Override
        public String performOperationOnDevice(LynxModule module, HandleIdParameters parameters) throws LynxNackException, InterruptedException {
            LynxReadVersionStringCommand command = new LynxReadVersionStringCommand((LynxModuleIntf)module);
            String rawString = ((LynxReadVersionStringResponse)command.sendReceive()).getNullableVersionString();
            if (rawString == null) {
                return "unknown";
            }
            return CachedLynxModulesInfo.formatFirmwareVersion((String)rawString);
        }
    }

    private static class CloseHubCommand
    extends ManualControlCommandHandler<HandleIdParameters, Void> {
        public CloseHubCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<HandleIdParameters> getPayloadClass() {
            return HandleIdParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void handleManualControlCommand(HandleIdParameters parameters) throws InvalidParameterException, InvalidDeviceIdException {
            ManualControlOpMode.getInstance().closeSystemOperationHandle(parameters.getHandleId());
            return null;
        }
    }

    private static class OpenHubCommand
    extends ManualControlCommandHandler<OpenHubParameters, Integer> {
        public OpenHubCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<OpenHubParameters> getPayloadClass() {
            return OpenHubParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer handleManualControlCommand(OpenHubParameters parameters) throws InterruptedException, FailedToOpenHubException, InvalidParameterException {
            return ManualControlOpMode.getInstance().openHubAndGetHandleId(parameters);
        }
    }

    private static class ScanAndDiscoverCommand
    extends ManualControlCommandHandler<Void, Map<String, ParentHub>> {
        public ScanAndDiscoverCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @Override
        public Map<String, ParentHub> handleManualControlCommand(Void parameters) throws InterruptedException {
            HashMap<String, ParentHub> result = new HashMap<String, ParentHub>();
            ScannedDevices scannedDevices = (ScannedDevices)USBScanManager.getInstance().startDeviceScanIfNecessary().await();
            if (scannedDevices != null) {
                SerialNumber serialNumber;
                HashMap<SerialNumber, ThreadPool.SingletonResult<LynxModuleMetaList>> pendingDiscoveryResults = new HashMap<SerialNumber, ThreadPool.SingletonResult<LynxModuleMetaList>>();
                for (Map.Entry entry : scannedDevices.entrySet()) {
                    serialNumber = (SerialNumber)entry.getKey();
                    if (entry.getValue() != DeviceManager.UsbDeviceType.LYNX_USB_DEVICE) continue;
                    pendingDiscoveryResults.put(serialNumber, USBScanManager.getInstance().startLynxModuleEnumerationIfNecessary(serialNumber));
                }
                for (Map.Entry entry : pendingDiscoveryResults.entrySet()) {
                    LynxModuleMeta parent;
                    serialNumber = (SerialNumber)entry.getKey();
                    LynxModuleMetaList modules = (LynxModuleMetaList)((ThreadPool.SingletonResult)entry.getValue()).await();
                    if (modules == null || (parent = modules.getParent()) == null) continue;
                    int parentAddress = parent.getModuleAddress();
                    LinkedList<Integer> childAddresses = new LinkedList<Integer>();
                    for (LynxModuleMeta module : modules.modules) {
                        if (module.isParent()) continue;
                        childAddresses.add(module.getModuleAddress());
                    }
                    HubType hubType = serialNumber.isEmbedded() ? HubType.CONTROL_HUB : HubType.EXPANSION_HUB;
                    String serialString = serialNumber.getString();
                    result.put(serialString, new ParentHub(serialString, hubType, parentAddress, childAddresses));
                }
            }
            return result;
        }

        @NonNull
        protected Class<Void> getPayloadClass() {
            return Void.class;
        }

        @NonNull
        protected Class<Map<String, ParentHub>> getResultClass() {
            return Map.class;
        }
    }

    private static class StopCommand
    extends ManualControlCommandHandler<Void, Void> {
        public StopCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<Void> getPayloadClass() {
            return Void.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void handleManualControlCommand(Void value) {
            this.manualControlWebSocketHandler.stopManualControl();
            return null;
        }
    }

    private class StartCommand
    extends WebSocketCommandHandler<Void, ManualControlApiVersion> {
        private StartCommand() {
        }

        @NonNull
        protected Class<Void> getPayloadClass() {
            return Void.class;
        }

        @NonNull
        protected Class<ManualControlApiVersion> getResultClass() {
            return ManualControlApiVersion.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManualControlApiVersion handleCommand(Void value, FtcWebSocket webSocket) throws UserOpModeRunningException, ManualControlLockedException, OnlyLocalConnectionsAllowedException, WebSocketNotSubscribedException {
            if (!webSocket.getRemoteIpAddress().isLoopbackAddress()) {
                throw new OnlyLocalConnectionsAllowedException();
            }
            if (!ManualControlWebSocketHandler.this.webSocketManager.webSocketIsSubscribedToNamespace(ManualControlWebSocketHandler.WS_NAMESPACE, webSocket)) {
                throw new WebSocketNotSubscribedException();
            }
            Object object = ManualControlWebSocketHandler.this.allowedWebSocketLock;
            synchronized (object) {
                if (ManualControlWebSocketHandler.this.allowedWebSocket == null) {
                    ManualControlWebSocketHandler.this.allowedWebSocket = webSocket;
                } else if (ManualControlWebSocketHandler.this.allowedWebSocket != webSocket) {
                    throw new ManualControlLockedException();
                }
            }
            try {
                ManualControlOpMode.startOpModeAndWait();
                return API_VERSION;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

