/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands;

import android.graphics.Color;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleLEDColorCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleLEDColorResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleLEDPatternCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleLEDPatternResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetModuleLEDColorCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetModuleLEDPatternCommand;
import com.qualcomm.robotcore.hardware.Blinker;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlDeviceCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlWebSocketHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidParameterException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.HandleIdParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.LedColorParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.LedPatternParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.LedColorResponse;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.LedPatternResponse;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;

public class LedCommands {
    public static void register(Map<String, WebSocketMessageTypeHandler> handlerMap, ManualControlWebSocketHandler handler) {
        handlerMap.put("setLedColor", (WebSocketMessageTypeHandler)new SetLedColorCommand(handler));
        handlerMap.put("getLedColor", (WebSocketMessageTypeHandler)new GetLedColorCommand(handler));
        handlerMap.put("setLedPattern", (WebSocketMessageTypeHandler)new SetLedPatternCommand(handler));
        handlerMap.put("getLedPattern", (WebSocketMessageTypeHandler)new GetLedPatternCommand(handler));
    }

    private static class GetLedPatternCommand
    extends ManualControlDeviceCommandHandler<HandleIdParameters, LedPatternResponse> {
        public GetLedPatternCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<HandleIdParameters> getPayloadClass() {
            return HandleIdParameters.class;
        }

        @NonNull
        protected Class<LedPatternResponse> getResultClass() {
            return LedPatternResponse.class;
        }

        @Override
        public LedPatternResponse performOperationOnDevice(LynxModule module, HandleIdParameters value) throws LynxNackException, InterruptedException {
            LynxGetModuleLEDPatternCommand command = new LynxGetModuleLEDPatternCommand(module);
            LynxGetModuleLEDPatternResponse response = (LynxGetModuleLEDPatternResponse)command.sendReceive();
            return new LedPatternResponse(this.getValue(response.getStep(0)), this.getValue(response.getStep(1)), this.getValue(response.getStep(2)), this.getValue(response.getStep(3)), this.getValue(response.getStep(4)), this.getValue(response.getStep(5)), this.getValue(response.getStep(6)), this.getValue(response.getStep(7)), this.getValue(response.getStep(8)), this.getValue(response.getStep(9)), this.getValue(response.getStep(10)), this.getValue(response.getStep(11)), this.getValue(response.getStep(12)), this.getValue(response.getStep(13)), this.getValue(response.getStep(14)), this.getValue(response.getStep(15)));
        }

        private int getValue(Blinker.Step step) {
            int t = step.getDurationMs() / 100;
            int color2 = step.getColor();
            int red = Color.red((int)color2);
            int green = Color.green((int)color2);
            int blue = Color.blue((int)color2);
            return t & 0xFF | (blue & 0xFF) << 8 | (green & 0xFF) << 16 | (red & 0xFF) << 24;
        }
    }

    private static class SetLedPatternCommand
    extends ManualControlDeviceCommandHandler<LedPatternParameters, Void> {
        public SetLedPatternCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<LedPatternParameters> getPayloadClass() {
            return LedPatternParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        private Blinker.Step toStep(int value) {
            int r = value >> 24 & 0xFF;
            int g = value >> 16 & 0xFF;
            int b = value >> 8 & 0xFF;
            double t = (double)(value & 0xFF) / 10.0;
            int color2 = Color.rgb((int)r, (int)g, (int)b);
            return new Blinker.Step(color2, (long)(t * 1000.0), TimeUnit.MILLISECONDS);
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, LedPatternParameters value) throws LynxNackException, InterruptedException, InvalidParameterException {
            LynxSetModuleLEDPatternCommand.Steps steps = new LynxSetModuleLEDPatternCommand.Steps();
            steps.add(this.toStep(value.getRgbtPatternStep0()));
            steps.add(this.toStep(value.getRgbtPatternStep1()));
            steps.add(this.toStep(value.getRgbtPatternStep2()));
            steps.add(this.toStep(value.getRgbtPatternStep3()));
            steps.add(this.toStep(value.getRgbtPatternStep4()));
            steps.add(this.toStep(value.getRgbtPatternStep5()));
            steps.add(this.toStep(value.getRgbtPatternStep6()));
            steps.add(this.toStep(value.getRgbtPatternStep7()));
            steps.add(this.toStep(value.getRgbtPatternStep8()));
            steps.add(this.toStep(value.getRgbtPatternStep9()));
            steps.add(this.toStep(value.getRgbtPatternStep10()));
            steps.add(this.toStep(value.getRgbtPatternStep11()));
            steps.add(this.toStep(value.getRgbtPatternStep12()));
            steps.add(this.toStep(value.getRgbtPatternStep13()));
            steps.add(this.toStep(value.getRgbtPatternStep14()));
            steps.add(this.toStep(value.getRgbtPatternStep15()));
            LynxSetModuleLEDPatternCommand command = new LynxSetModuleLEDPatternCommand(module, steps);
            command.send();
            return null;
        }
    }

    private static class GetLedColorCommand
    extends ManualControlDeviceCommandHandler<HandleIdParameters, LedColorResponse> {
        public GetLedColorCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<HandleIdParameters> getPayloadClass() {
            return HandleIdParameters.class;
        }

        @NonNull
        protected Class<LedColorResponse> getResultClass() {
            return LedColorResponse.class;
        }

        @Override
        public LedColorResponse performOperationOnDevice(LynxModule module, HandleIdParameters value) throws LynxNackException, InterruptedException {
            LynxGetModuleLEDColorCommand command = new LynxGetModuleLEDColorCommand(module);
            LynxGetModuleLEDColorResponse response = (LynxGetModuleLEDColorResponse)command.sendReceive();
            return new LedColorResponse(response.getRed(), response.getGreen(), response.getBlue());
        }
    }

    private static class SetLedColorCommand
    extends ManualControlDeviceCommandHandler<LedColorParameters, Void> {
        public SetLedColorCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @NonNull
        protected Class<LedColorParameters> getPayloadClass() {
            return LedColorParameters.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, LedColorParameters value) throws LynxNackException, InterruptedException, InvalidParameterException {
            LynxSetModuleLEDColorCommand command = new LynxSetModuleLEDColorCommand(module, (byte)value.getRed(), (byte)value.getGreen(), (byte)value.getBlue());
            command.send();
            return null;
        }
    }
}

