/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands;

import androidx.annotation.NonNull;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoConfigurationCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoConfigurationResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoEnableResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoPulseWidthCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoPulseWidthResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoConfigurationCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoPulseWidthCommand;
import java.util.Map;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlDeviceCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlWebSocketHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.ServoChannelParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.ServoConfigurationParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.ServoPulseWidthParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.SetServoEnableParameters;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;

public class ServoCommands {
    public static void register(Map<String, WebSocketMessageTypeHandler> handlerMap, ManualControlWebSocketHandler handler) {
        handlerMap.put("getServoConfiguration", (WebSocketMessageTypeHandler)new GetServoConfigurationCommand(handler));
        handlerMap.put("setServoConfiguration", (WebSocketMessageTypeHandler)new SetServoConfigurationCommand(handler));
        handlerMap.put("getServoPulseWidth", (WebSocketMessageTypeHandler)new GetServoPulseWidthCommand(handler));
        handlerMap.put("setServoPulseWidth", (WebSocketMessageTypeHandler)new SetServoPulseWidthCommand(handler));
        handlerMap.put("getServoEnable", (WebSocketMessageTypeHandler)new GetServoEnableCommand(handler));
        handlerMap.put("setServoEnable", (WebSocketMessageTypeHandler)new SetServoEnableCommand(handler));
    }

    private static class SetServoConfigurationCommand
    extends ManualControlDeviceCommandHandler<ServoConfigurationParameters, Void> {
        public SetServoConfigurationCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<ServoConfigurationParameters> getPayloadClass() {
            return ServoConfigurationParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, ServoConfigurationParameters params) throws LynxNackException, InterruptedException, WebSocketCommandException {
            LynxSetServoConfigurationCommand command = new LynxSetServoConfigurationCommand((LynxModuleIntf)module, params.getServoChannel(), params.getFramePeriod());
            command.send();
            return null;
        }
    }

    private static class GetServoEnableCommand
    extends ManualControlDeviceCommandHandler<ServoChannelParameters, Boolean> {
        public GetServoEnableCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<ServoChannelParameters> getPayloadClass() {
            return ServoChannelParameters.class;
        }

        @NonNull
        protected Class<Boolean> getResultClass() {
            return Boolean.class;
        }

        @Override
        public Boolean performOperationOnDevice(LynxModule module, ServoChannelParameters params) throws LynxNackException, InterruptedException, WebSocketCommandException {
            LynxGetServoEnableCommand command = new LynxGetServoEnableCommand((LynxModuleIntf)module, params.getServoChannel());
            return ((LynxGetServoEnableResponse)command.sendReceive()).isEnabled();
        }
    }

    private static class SetServoEnableCommand
    extends ManualControlDeviceCommandHandler<SetServoEnableParameters, Void> {
        public SetServoEnableCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<SetServoEnableParameters> getPayloadClass() {
            return SetServoEnableParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, SetServoEnableParameters params) throws LynxNackException, InterruptedException, WebSocketCommandException {
            LynxSetServoEnableCommand command = new LynxSetServoEnableCommand((LynxModuleIntf)module, params.getServoChannel(), params.getEnable());
            command.send();
            return null;
        }
    }

    private static class GetServoPulseWidthCommand
    extends ManualControlDeviceCommandHandler<ServoChannelParameters, Integer> {
        public GetServoPulseWidthCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<ServoChannelParameters> getPayloadClass() {
            return ServoChannelParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer performOperationOnDevice(LynxModule module, ServoChannelParameters params) throws LynxNackException, InterruptedException, WebSocketCommandException {
            LynxGetServoPulseWidthCommand command = new LynxGetServoPulseWidthCommand((LynxModuleIntf)module, params.getServoChannel());
            return ((LynxGetServoPulseWidthResponse)command.sendReceive()).getPulseWidth();
        }
    }

    private static class SetServoPulseWidthCommand
    extends ManualControlDeviceCommandHandler<ServoPulseWidthParameters, Void> {
        public SetServoPulseWidthCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<ServoPulseWidthParameters> getPayloadClass() {
            return ServoPulseWidthParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, ServoPulseWidthParameters params) throws LynxNackException, InterruptedException, WebSocketCommandException {
            LynxSetServoPulseWidthCommand command = new LynxSetServoPulseWidthCommand((LynxModuleIntf)module, params.getServoChannel(), params.getPulseWidth());
            command.send();
            return null;
        }
    }

    private static class GetServoConfigurationCommand
    extends ManualControlDeviceCommandHandler<ServoChannelParameters, Integer> {
        public GetServoConfigurationCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<ServoChannelParameters> getPayloadClass() {
            return ServoChannelParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer performOperationOnDevice(LynxModule module, ServoChannelParameters params) throws LynxNackException, InterruptedException, WebSocketCommandException {
            LynxGetServoConfigurationCommand command = new LynxGetServoConfigurationCommand((LynxModuleIntf)module, params.getServoChannel());
            return ((LynxGetServoConfigurationResponse)command.sendReceive()).getFramePeriod();
        }
    }
}

