/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceCategory;
import android.preference.PreferenceFragment;
import android.text.TextUtils;
import android.widget.FrameLayout;
import androidx.annotation.StringRes;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.Device;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.Version;
import com.qualcomm.robotcore.wifi.NetworkConnection;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.inspection.R;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.format.FormatStyle;
import org.threeten.bp.temporal.TemporalAccessor;

public class FtcAboutActivity
extends ThemedActivity {
    public static final String TAG = "FtcDriverStationAboutActivity";
    protected final Context context = AppUtil.getDefContext();
    protected final boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
    protected AboutFragment aboutFragment;
    protected Future refreshFuture = null;
    final RecvLoopRunnable.RecvLoopCallback recvLoopCallback = new RecvLoopRunnable.DegenerateCallback(){

        public CallbackResult commandEvent(Command command) {
            RobotLog.vv((String)FtcAboutActivity.TAG, (String)"commandEvent: %s", (Object[])new Object[]{command.getName()});
            if (FtcAboutActivity.this.remoteConfigure) {
                switch (command.getName()) {
                    case "CMD_REQUEST_ABOUT_INFO_RESP": {
                        final RobotCoreCommandList.AboutInfo aboutInfo = RobotCoreCommandList.AboutInfo.deserialize((String)command.getExtra());
                        AppUtil.getInstance().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                FtcAboutActivity.this.refreshRemote(aboutInfo);
                            }
                        });
                        return CallbackResult.HANDLED;
                    }
                }
            }
            return CallbackResult.NOT_HANDLED;
        }
    };
    private static String buildTimeFromBuildConfig = null;

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    public static RobotCoreCommandList.AboutInfo getLocalAboutInfo() {
        RobotCoreCommandList.AboutInfo info = new RobotCoreCommandList.AboutInfo();
        info.appVersion = FtcAboutActivity.getAppVersion();
        info.libVersion = Version.getLibraryVersion();
        info.buildTime = FtcAboutActivity.getBuildTime();
        info.networkProtocolVersion = String.format(Locale.US, "v%d", 124);
        if (Device.isRevControlHub()) {
            info.osVersion = LynxConstants.getControlHubOsVersion();
        } else if (Device.isRevDriverHub()) {
            info.osVersion = LynxConstants.getDriverHubOsVersion();
        }
        NetworkConnection networkConnection = NetworkConnectionHandler.getInstance().getNetworkConnection();
        info.networkConnectionInfo = networkConnection != null ? networkConnection.getInfo() : AppUtil.getDefContext().getString(R.string.unavailable);
        return info;
    }

    protected static String getAppVersion() {
        String appVersion;
        Application context = AppUtil.getDefContext();
        try {
            appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            appVersion = context.getString(R.string.unavailable);
        }
        return appVersion;
    }

    public static void setBuildTimeFromBuildConfig(String buildTime) {
        buildTimeFromBuildConfig = buildTime;
    }

    protected static String getBuildTime() {
        try {
            LocalDateTime buildTime = LocalDateTime.parse((CharSequence)buildTimeFromBuildConfig, (DateTimeFormatter)AppUtil.getInstance().getIso8601DateTimeFormatter());
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime((FormatStyle)FormatStyle.LONG).withZone(ZoneId.systemDefault());
            return formatter.format((TemporalAccessor)buildTime);
        }
        catch (DateTimeParseException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"exception determining build time");
            return AppUtil.getDefContext().getString(R.string.unavailable);
        }
    }

    protected void startRefreshing() {
        this.stopRefreshing();
        int msInterval = 5000;
        this.refreshFuture = ThreadPool.getDefaultScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AppUtil.getInstance().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FtcAboutActivity.this.refresh();
                    }
                });
            }
        }, 0L, msInterval, TimeUnit.MILLISECONDS);
    }

    protected void stopRefreshing() {
        if (this.refreshFuture != null) {
            this.refreshFuture.cancel(false);
            this.refreshFuture = null;
        }
    }

    protected void refreshRemote(RobotCoreCommandList.AboutInfo aboutInfo) {
        this.aboutFragment.refreshRemote(aboutInfo);
    }

    protected void refresh() {
        this.aboutFragment.refreshLocal(FtcAboutActivity.getLocalAboutInfo());
        if (this.remoteConfigure) {
            NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_REQUEST_ABOUT_INFO"));
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        RobotLog.vv((String)TAG, (String)"onCreate()");
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_generic_settings);
        DeviceNameManagerFactory.getInstance().initializeDeviceNameIfNecessary();
        this.aboutFragment = new AboutFragment();
        this.getFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.aboutFragment).commit();
        NetworkConnectionHandler.getInstance().pushReceiveLoopCallback(this.recvLoopCallback);
    }

    protected void onResume() {
        super.onResume();
        this.startRefreshing();
    }

    protected void onPause() {
        this.stopRefreshing();
        super.onPause();
    }

    protected void onDestroy() {
        RobotLog.vv((String)TAG, (String)"onDestroy()");
        super.onDestroy();
        NetworkConnectionHandler.getInstance().removeReceiveLoopCallback(this.recvLoopCallback);
    }

    public static class AboutFragment
    extends PreferenceFragment {
        protected final boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
        private boolean firstRemoteRefresh = true;

        public void refreshLocal(RobotCoreCommandList.AboutInfo aboutInfo) {
            this.setPreferenceSummary(R.string.pref_app_version, aboutInfo.appVersion);
            this.setPreferenceSummary(R.string.pref_lib_version, aboutInfo.libVersion);
            this.setPreferenceSummary(R.string.pref_network_protocol_version, aboutInfo.networkProtocolVersion);
            this.setPreferenceSummary(R.string.pref_build_time, aboutInfo.buildTime);
            this.setPreferenceSummary(R.string.pref_network_connection_info, aboutInfo.networkConnectionInfo);
            this.setPreferenceSummary(R.string.pref_os_version, aboutInfo.osVersion);
        }

        public void refreshRemote(RobotCoreCommandList.AboutInfo aboutInfo) {
            if (this.remoteConfigure) {
                if (this.firstRemoteRefresh && aboutInfo.osVersion != null) {
                    PreferenceCategory prefAppCategoryRc = (PreferenceCategory)this.findPreference(this.getString(R.string.pref_app_category_rc));
                    Preference osVersionPreference = new Preference(this.getPreferenceScreen().getContext());
                    osVersionPreference.setTitle((CharSequence)this.getString(R.string.about_ch_os_version));
                    osVersionPreference.setKey(this.getString(R.string.pref_os_version_rc));
                    prefAppCategoryRc.addPreference(osVersionPreference);
                }
                this.firstRemoteRefresh = false;
                this.setPreferenceSummary(R.string.pref_app_version_rc, aboutInfo.appVersion);
                this.setPreferenceSummary(R.string.pref_lib_version_rc, aboutInfo.libVersion);
                this.setPreferenceSummary(R.string.pref_network_protocol_version_rc, aboutInfo.networkProtocolVersion);
                this.setPreferenceSummary(R.string.pref_build_time_rc, aboutInfo.buildTime);
                this.setPreferenceSummary(R.string.pref_network_connection_info_rc, aboutInfo.networkConnectionInfo);
                this.setPreferenceSummary(R.string.pref_os_version_rc, aboutInfo.osVersion);
            }
        }

        public void refreshAllUnavailable() {
            this.setPreferenceSummary(R.string.pref_app_version, null);
            this.setPreferenceSummary(R.string.pref_lib_version, null);
            this.setPreferenceSummary(R.string.pref_network_protocol_version, null);
            this.setPreferenceSummary(R.string.pref_build_time, null);
            this.setPreferenceSummary(R.string.pref_network_connection_info, null);
            this.setPreferenceSummary(R.string.pref_os_version, null);
            this.setPreferenceSummary(R.string.pref_app_version_rc, null);
            this.setPreferenceSummary(R.string.pref_lib_version_rc, null);
            this.setPreferenceSummary(R.string.pref_network_protocol_version_rc, null);
            this.setPreferenceSummary(R.string.pref_build_time_rc, null);
            this.setPreferenceSummary(R.string.pref_network_connection_info_rc, null);
            this.setPreferenceSummary(R.string.pref_os_version_rc, null);
        }

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.addPreferencesFromResource(R.xml.ftc_about_activity);
            PreferenceCategory prefAppCategory = (PreferenceCategory)this.findPreference(this.getString(R.string.pref_app_category));
            prefAppCategory.setTitle(this.remoteConfigure ? R.string.prefcat_about_ds : R.string.prefcat_about_rc);
            if (Device.isRevControlHub() || Device.isRevDriverHub()) {
                String title = Device.isRevControlHub() ? this.getString(R.string.about_ch_os_version) : this.getString(R.string.about_dh_os_version);
                Preference osVersionPreference = new Preference(this.getPreferenceScreen().getContext());
                osVersionPreference.setTitle((CharSequence)title);
                osVersionPreference.setKey(this.getString(R.string.pref_os_version));
                prefAppCategory.addPreference(osVersionPreference);
            }
            if (this.remoteConfigure) {
                this.addPreferencesFromResource(R.xml.ftc_about_activity_rc);
                Preference prefAppCategoryRc = this.findPreference(this.getString(R.string.pref_app_category_rc));
                prefAppCategoryRc.setTitle(R.string.prefcat_about_rc);
            }
            this.refreshAllUnavailable();
        }

        protected void setPreferenceSummary(@StringRes int idPref, String value) {
            this.setPreferenceSummary(AppUtil.getDefContext().getString(idPref), value);
        }

        protected void setPreferenceSummary(String prefName, String value) {
            Preference preference;
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = AppUtil.getDefContext().getString(R.string.unavailable);
            }
            if ((preference = this.findPreference(prefName)) != null) {
                preference.setSummary((CharSequence)value);
            }
        }
    }
}

